/*
 * Copyright 2025 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected;

/**
 * Payload type with enhanced functionality. To use this functionality, your probe method must return instances of this type instead of {@code String}, declare a
 * parameter with type {@link ProbeContext} to get a context instance and call {@link ProbeContext#createPayload(String, Object, Enum)} to create a payload that it can return.
 * <p>Do not create your own subtypes.</p>
 */
public interface Payload {
    /**
     * The name for this payload.
     * @return the name or {@code null} if none was provided yet
     */
    String getName();

    /**
     * The type of the payload. One of the enum constants of {@link Probe#customTypes()}.
     * @return the type or {@code null} if none was provided
     */
    Enum<?> getEventType();

    /**
     * The control object for this payload.
     * @return the control object or {@code null} if none was provided
     */
    Object getControlObject();
}
