package com.ejt.demo.server.controls;

public class RunOncePerThreadSimulatorControl extends SimulatorControl {

    private ThreadLocal<Boolean> complete = ThreadLocal.withInitial(() -> Boolean.FALSE);

    @Override
    public boolean isExecuteImmediately() {
        try {
            return !complete.get();
        } finally {
            complete.set(Boolean.TRUE);
        }
    }

    @Override
    protected double getRate() {
        return 0;
    }
}
