/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.d.f;
import com.jprofiler.agent.d.h;
import com.jprofiler.agent.triggers.RuntimeTrigger;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.actions.WaitForFinishAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.IOException;
import java.util.List;

public class ThresholdTrigger
extends RuntimeTrigger {
    public static final int DEFAULT_THRESHOLD = 80;
    public static final int DEFAULT_MINIMUM_TIME = 10;
    public static final String DEFAULT_MINIMUM_TIME_UNIT = "s";
    public static final boolean DEFAULT_USE_BELOW_TIME = false;
    public static final int DEFAULT_MINIMUM_BELOW_TIME = 10;
    public static final String DEFAULT_MINIMUM_BELOW_TIME_UNIT = "s";
    public static final int DEFAULT_INHIBIT_DUPLICATE_TIME = 1;
    public static final String DEFAULT_INHIBIT_DUPLICATE_TIME_UNIT = "m";
    private int threshold;
    private long minimumTime;
    private long belowTime;
    private long inhibitDuplicateTime;
    private List<TriggerAction> startActions;
    private List<TriggerAction> endActions;
    private long lastTimeTriggered = -1L;
    private long firstTimeReached = -1L;
    private long firstTimeBelow = -1L;
    private boolean inEvent = false;

    public ThresholdTrigger(XMLElement xMLElement) throws IOException {
        super(xMLElement);
        this.threshold = xMLElement.getIntAttribute("threshold", 80);
        int n2 = xMLElement.getIntAttribute("minimumTime", 10);
        String string = xMLElement.getStringAttribute("minimumTimeUnit", "s");
        this.minimumTime = TriggerManager.getTimeMillis(n2, string);
        n2 = xMLElement.getIntAttribute("inhibitDuplicateTime", 1);
        string = xMLElement.getStringAttribute("inhibitDuplicateTimeUnit", DEFAULT_INHIBIT_DUPLICATE_TIME_UNIT);
        this.inhibitDuplicateTime = TriggerManager.getTimeMillis(n2, string);
        if (ThresholdTrigger.readBooleanValue(xMLElement, "useBelowTime", false)) {
            n2 = xMLElement.getIntAttribute("minimumBelowTime", 10);
            string = xMLElement.getStringAttribute("minimumBelowTimeUnit", "s");
            this.belowTime = TriggerManager.getTimeMillis(n2, string);
        } else {
            this.belowTime = this.minimumTime;
        }
        this.splitActions();
    }

    private void splitActions() {
        int n2 = this.getWaitForFinishIndex();
        if (n2 > -1) {
            this.startActions = this.getActions().subList(0, n2);
            this.endActions = this.getActions().subList(n2 + 1, this.getActions().size());
        } else {
            this.startActions = this.getActions();
        }
    }

    @Override
    protected void changeEnabled(boolean bl2) {
    }

    public void check(int n2, long l2) {
        if (n2 >= this.threshold) {
            this.firstTimeBelow = -1L;
            if (this.firstTimeReached == -1L) {
                this.firstTimeReached = l2;
            }
            if (!(this.inEvent || l2 - this.firstTimeReached < this.minimumTime || this.lastTimeTriggered != -1L && l2 - this.lastTimeTriggered < this.inhibitDuplicateTime)) {
                this.inEvent = true;
                this.executeActions(this.startActions);
            }
        } else if (this.inEvent) {
            if (this.firstTimeBelow == -1L) {
                this.firstTimeBelow = l2;
            }
            if (l2 - this.firstTimeBelow >= this.belowTime) {
                this.executeActions(this.endActions);
                this.firstTimeReached = -1L;
                this.inEvent = false;
                this.lastTimeTriggered = l2;
            }
        } else {
            this.firstTimeReached = -1L;
        }
    }

    private void executeActions(final List<TriggerAction> list) {
        if (this.isEnabled() && list != null && list.size() > 0) {
            new Thread("_jprofiler_threshold_executor"){
                {
                    super(string);
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    TriggerManager.executeNoMethodActions(list);
                }
            }.start();
        }
    }

    private int getWaitForFinishIndex() {
        for (int i2 = 0; i2 < this.getActions().size(); ++i2) {
            TriggerAction triggerAction = this.getActions().get(i2);
            if (!(triggerAction instanceof WaitForFinishAction)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void read(f f2) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        super.read(f2);
        this.threshold = f2.readInt();
        this.minimumTime = f2.readLong();
        this.inhibitDuplicateTime = f2.readLong();
        this.splitActions();
    }

    @Override
    public void write(h h2, int n2) throws IOException {
        super.write(h2, n2);
        h2.writeInt(this.threshold);
        h2.writeLong(this.minimumTime);
        h2.writeLong(this.inhibitDuplicateTime);
    }
}

