/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent;

import com.jprofiler.agent.util.w;
import java.io.File;
import java.net.URL;

public class AgentEnvironment {
    public static final String LIBRARY_NAME_JVMTI = "jprofilerti";
    private static final String PLATFORM_DESCRIPTOR_WINDOWS = "windows";
    private static final String PLATFORM_DESCRIPTOR_WINDOWS_X64 = "windows-x64";
    private static final String PLATFORM_DESCRIPTOR_LINUX_X86 = "linux-x86";
    private static final String PLATFORM_DESCRIPTOR_LINUX_X64 = "linux-x64";
    private static final String PLATFORM_DESCRIPTOR_LINUX_MUSL_X64 = "linux_musl-x64";
    private static final String PLATFORM_DESCRIPTOR_MACOS = "macos";
    private static final String PLATFORM_DESCRIPTOR_LINUX_PPC64LE = "linux-ppc64le";
    private static final String PLATFORM_DESCRIPTOR_LINUX_ARMHF = "linux-armhf";
    private static final String PLATFORM_DESCRIPTOR_LINUX_AARCH64 = "linux-aarch64";
    private static final String PLATFORM_DESCRIPTOR_LINUX_MUSL_AARCH64 = "linux_musl-aarch64";
    private static final String URL_FILE_PREFIX = "file:";
    private static final String URL_JAR_PREFIX = "jar:file:";
    private static final String OS_NAME = System.getProperty("os.name", "");
    private static final String OS_ARCH = System.getProperty("os.arch", "");
    public static final String ALPINE_RELEASE_FILE_NAME = "alpine-release";
    public static final String ALPINE_RELEASE_PATH = "/etc/alpine-release";
    private static File tempDir;
    private static boolean tempDirInitialized;
    private static String nativeTempDir;
    private static File baseDir;
    private static boolean loadedFromJAR;

    public static File getAgentBaseDir() {
        return baseDir;
    }

    public static boolean isLoadedFromJAR() {
        return loadedFromJAR;
    }

    public static String getLibraryFileName(String string) {
        if (AgentEnvironment.isWindows()) {
            return string + ".dll";
        }
        if (AgentEnvironment.isMacOS()) {
            return "lib" + string + ".jnilib";
        }
        return "lib" + string + ".so";
    }

    public static String getOSDescriptor() {
        String string = AgentEnvironment.getPlatformDescriptor(false);
        int n2 = string.indexOf(45);
        if (n2 > -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String getPlatformDescriptor(boolean bl2) {
        if (AgentEnvironment.isWindowsX86()) {
            return PLATFORM_DESCRIPTOR_WINDOWS;
        }
        if (AgentEnvironment.isWindowsX64()) {
            return PLATFORM_DESCRIPTOR_WINDOWS_X64;
        }
        if (AgentEnvironment.isLinuxX86()) {
            return PLATFORM_DESCRIPTOR_LINUX_X86;
        }
        if (AgentEnvironment.isLinuxX64()) {
            if (bl2 && AgentEnvironment.isAlpine()) {
                return PLATFORM_DESCRIPTOR_LINUX_MUSL_X64;
            }
            return PLATFORM_DESCRIPTOR_LINUX_X64;
        }
        if (AgentEnvironment.isLinuxPpc64Le()) {
            return PLATFORM_DESCRIPTOR_LINUX_PPC64LE;
        }
        if (AgentEnvironment.isLinuxAarch64()) {
            if (bl2 && AgentEnvironment.isAlpine()) {
                return PLATFORM_DESCRIPTOR_LINUX_MUSL_AARCH64;
            }
            return PLATFORM_DESCRIPTOR_LINUX_AARCH64;
        }
        if (AgentEnvironment.isLinuxArm32()) {
            return PLATFORM_DESCRIPTOR_LINUX_ARMHF;
        }
        if (AgentEnvironment.isMacOS()) {
            return PLATFORM_DESCRIPTOR_MACOS;
        }
        return "unknown";
    }

    public static String getLibraryPathVariableName() {
        if (AgentEnvironment.isWindows()) {
            return "PATH";
        }
        if (AgentEnvironment.isMacOS()) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isLinuxX86() {
        return AgentEnvironment.isLinux() && AgentEnvironment.isX86();
    }

    public static boolean isLinuxArm32() {
        return AgentEnvironment.isLinux() && AgentEnvironment.isArm();
    }

    public static boolean isArm() {
        return OS_ARCH.startsWith("arm");
    }

    public static boolean isLinuxAarch64() {
        return AgentEnvironment.isLinux() && AgentEnvironment.isAarch64();
    }

    public static boolean isAarch64() {
        return OS_ARCH.equals("aarch64");
    }

    public static boolean isLinuxPpc64Le() {
        return AgentEnvironment.isLinux() && AgentEnvironment.isPpc64Le();
    }

    public static boolean isLinuxX64() {
        return AgentEnvironment.isLinux() && AgentEnvironment.isX64();
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isWindowsX64() {
        return AgentEnvironment.isWindows() && AgentEnvironment.isX64();
    }

    public static boolean isWindowsX86() {
        return AgentEnvironment.isWindows() && AgentEnvironment.isX86();
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isX86() {
        return OS_ARCH.contains("86") && !OS_ARCH.contains("64");
    }

    public static boolean isX64() {
        return OS_ARCH.equals("amd64") || OS_ARCH.equals("x86_64");
    }

    public static boolean isPpc64() {
        return OS_ARCH.equals("ppc64");
    }

    public static boolean isPpc64Le() {
        return OS_ARCH.equals("ppc64le");
    }

    public static boolean isAlpine() {
        return new File(ALPINE_RELEASE_PATH).isFile();
    }

    private static void initLoadingInformation() {
        String string = AgentEnvironment.class.getName().replace('.', '/') + ".class";
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        URL uRL = AgentEnvironment.getResourceUrl(string2);
        if (uRL == null) {
            return;
        }
        String string3 = uRL.toString();
        String string4 = string3.substring(0, string3.lastIndexOf(string) - 1);
        if ((string4 = AgentEnvironment.getWorkaroundPath(string4)).startsWith(URL_JAR_PREFIX)) {
            loadedFromJAR = true;
            int n2 = string4.lastIndexOf(47);
            if (n2 == -1) {
                n2 = string4.lastIndexOf(92);
            }
            if (n2 == -1) {
                return;
            }
            string4 = string4.substring(URL_JAR_PREFIX.length(), n2);
        } else if (string4.startsWith(URL_FILE_PREFIX)) {
            loadedFromJAR = false;
            string4 = string4.substring(URL_FILE_PREFIX.length());
        } else {
            return;
        }
        baseDir = new File(string4);
    }

    private static URL getResourceUrl(String string) {
        try {
            return AgentEnvironment.class.getResource(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getWorkaroundPath(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '%') {
                ++n2;
            } else {
                try {
                    c2 = AgentEnvironment.unescape(string, n2);
                    n2 += 3;
                    if ((c2 & 0x80) != 0) {
                        switch (c2 >> 4) {
                            case 12: 
                            case 13: {
                                char c3 = AgentEnvironment.unescape(string, n2);
                                n2 += 3;
                                c2 = (char)((c2 & 0x1F) << 6 | c3 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c4 = AgentEnvironment.unescape(string, n2);
                                char c5 = AgentEnvironment.unescape(string, n2 += 3);
                                n2 += 3;
                                c2 = (char)((c2 & 0xF) << 12 | (c4 & 0x3F) << 6 | c5 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException();
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static char unescape(String string, int n2) {
        return (char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
    }

    public static void setBaseDir(File file) {
        baseDir = file;
    }

    public static int getPid() {
        return w.getPid();
    }

    public static String getLibraryPath(String string, boolean bl2) {
        return AgentEnvironment.getAgentBaseDir() + File.separator + AgentEnvironment.getRelativeLibraryPath(string, bl2);
    }

    public static String getRelativeLibraryPath(String string, boolean bl2) {
        return AgentEnvironment.getPlatformDescriptor(bl2) + File.separator + AgentEnvironment.getLibraryFileName(string);
    }

    public static String getRelativeLibraryPath() {
        return AgentEnvironment.getRelativeLibraryPath(LIBRARY_NAME_JVMTI, true);
    }

    private static File findTempDir() {
        String string = System.getProperty("jprofiler.tmpdir");
        if (string != null && new File(string).isDirectory()) {
            return new File(string);
        }
        string = System.getenv("JPROFILER_TMPDIR");
        if (string != null && new File(string).isDirectory()) {
            return new File(string);
        }
        string = System.getProperty("java.io.tmpdir");
        if (string != null && new File(string).isDirectory()) {
            return new File(string);
        }
        return null;
    }

    public static synchronized File getTempDir() {
        if (!tempDirInitialized) {
            block8: {
                if (nativeTempDir != null) {
                    tempDir = new File(nativeTempDir);
                } else {
                    try {
                        File file = AgentEnvironment.findTempDir();
                        try {
                            if (file != null) {
                                tempDir = file.getCanonicalFile();
                                break block8;
                            }
                            tempDir = null;
                        }
                        catch (Throwable throwable) {
                            tempDir = file;
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            tempDirInitialized = true;
        }
        return tempDir;
    }

    public static void setNativeTempDir(String string) {
        nativeTempDir = string;
    }

    static {
        AgentEnvironment.initLoadingInformation();
    }
}

