/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.d.b;
import com.jprofiler.agent.e.f;
import com.jprofiler.agent.e.h;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.triggers.actions.AddBookmarkAction;
import com.jprofiler.agent.triggers.actions.HprofHeapdumpAction;
import com.jprofiler.agent.triggers.actions.MarkHeapAction;
import com.jprofiler.agent.triggers.actions.MonitorDumpAction;
import com.jprofiler.agent.triggers.actions.OverrideThreadStatusAction;
import com.jprofiler.agent.triggers.actions.PrintMessageAction;
import com.jprofiler.agent.triggers.actions.PrintMethodInvocationAction;
import com.jprofiler.agent.triggers.actions.RunGcAction;
import com.jprofiler.agent.triggers.actions.RunInterceptorScriptAction;
import com.jprofiler.agent.triggers.actions.RunScriptAction;
import com.jprofiler.agent.triggers.actions.SaveSnapshotAction;
import com.jprofiler.agent.triggers.actions.SleepAction;
import com.jprofiler.agent.triggers.actions.StartCallTracerAction;
import com.jprofiler.agent.triggers.actions.StartMonitorRecordingAction;
import com.jprofiler.agent.triggers.actions.StartProbeRecordingAction;
import com.jprofiler.agent.triggers.actions.StartProbeTrackingAction;
import com.jprofiler.agent.triggers.actions.StartRecordingAction;
import com.jprofiler.agent.triggers.actions.StopCallTracerAction;
import com.jprofiler.agent.triggers.actions.StopMonitorRecordingAction;
import com.jprofiler.agent.triggers.actions.StopProbeRecordingAction;
import com.jprofiler.agent.triggers.actions.StopProbeTrackingAction;
import com.jprofiler.agent.triggers.actions.StopRecordingAction;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.actions.TriggerAllObjectsDumpAction;
import com.jprofiler.agent.triggers.actions.TriggerHeapdumpAction;
import com.jprofiler.agent.triggers.actions.TriggerMBeanSnapshotAction;
import com.jprofiler.agent.triggers.actions.TriggerThreadDumpAction;
import com.jprofiler.agent.triggers.actions.WaitForFinishAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public abstract class RuntimeTrigger {
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_USE_GROUP_ID = false;
    public static final String DEFAULT_GROUP_ID = "";
    private boolean enabled;
    private boolean useGroupId;
    private String groupId = "";
    private List<TriggerAction> actions = new ArrayList<TriggerAction>();

    public static boolean readBooleanValue(XMLElement xMLElement, String string, boolean bl2) {
        String string2 = xMLElement.getStringAttribute(string);
        if (string2 != null) {
            return Boolean.TRUE.toString().equals(string2);
        }
        return bl2;
    }

    protected RuntimeTrigger(XMLElement xMLElement) throws IOException {
        this.enabled = RuntimeTrigger.readBooleanValue(xMLElement, "enabled", true);
        this.useGroupId = RuntimeTrigger.readBooleanValue(xMLElement, "groupId", false);
        this.groupId = xMLElement.getStringAttribute("groupId", DEFAULT_GROUP_ID);
        XMLElement xMLElement2 = b.a(xMLElement, "actions");
        if (xMLElement2 != null) {
            this.readActions(xMLElement2.getChildren(), this.isImmediateTrigger());
        }
    }

    protected RuntimeTrigger() {
        this.enabled = true;
    }

    protected abstract void changeEnabled(boolean var1);

    public void setEnabled(boolean bl2) {
        this.enabled = bl2;
        this.changeEnabled(bl2);
    }

    public boolean isEnabled() {
        return this.enabled && TriggerManager.globalEnabled;
    }

    public void stop() {
    }

    protected boolean isImmediateTrigger() {
        return false;
    }

    public String getUsedGroupId() {
        return this.useGroupId ? this.groupId : DEFAULT_GROUP_ID;
    }

    public List<TriggerAction> getActions() {
        return this.actions;
    }

    public void read(f f2) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        while (f2.readBoolean()) {
            TriggerAction triggerAction = (TriggerAction)Class.forName(f2.readUTF()).newInstance();
            triggerAction.read(f2);
            this.actions.add(triggerAction);
        }
    }

    public void write(h h2, int n2) throws IOException {
        for (TriggerAction triggerAction : this.actions) {
            h2.writeBoolean(true);
            h2.writeUTF(triggerAction.getClass().getName());
            triggerAction.write(h2, n2);
        }
        h2.writeBoolean(false);
    }

    private void readActions(Vector vector, boolean bl2) {
        SleepAction sleepAction = null;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            TriggerAction triggerAction = RuntimeTrigger.readAction((XMLElement)vector.get(i2));
            if (triggerAction == null) continue;
            if (triggerAction instanceof WaitForFinishAction) {
                sleepAction = null;
            }
            if (sleepAction != null && !triggerAction.isTopLevelOnly()) {
                sleepAction.addSubsequentAction(triggerAction);
            } else {
                this.actions.add(triggerAction);
            }
            if (bl2 || !(triggerAction instanceof SleepAction)) continue;
            sleepAction = (SleepAction)triggerAction;
        }
    }

    private static TriggerAction readAction(XMLElement xMLElement) {
        String string;
        switch (string = xMLElement.getName()) {
            case "printMessage": {
                return new PrintMessageAction(xMLElement);
            }
            case "printMethodInvocation": {
                return new PrintMethodInvocationAction(xMLElement);
            }
            case "runScript": {
                return new RunScriptAction(xMLElement);
            }
            case "runInterceptorScript": {
                return new RunInterceptorScriptAction(xMLElement);
            }
            case "sleep": {
                return new SleepAction(xMLElement);
            }
            case "waitForFinish": {
                return new WaitForFinishAction();
            }
            case "overrideThreadStatus": {
                return new OverrideThreadStatusAction(xMLElement);
            }
            case "addBookmark": {
                return new AddBookmarkAction(xMLElement);
            }
            case "hprofHeapdump": {
                return new HprofHeapdumpAction(xMLElement);
            }
            case "saveSnapshot": {
                return new SaveSnapshotAction(xMLElement);
            }
            case "runGc": {
                return new RunGcAction();
            }
            case "monitorDump": {
                return new MonitorDumpAction();
            }
            case "triggerHeapdump": {
                return new TriggerHeapdumpAction(xMLElement);
            }
            case "triggerThreadDump": {
                return new TriggerThreadDumpAction(xMLElement);
            }
            case "triggerAllObjectsDump": {
                return new TriggerAllObjectsDumpAction(xMLElement);
            }
            case "triggerMBeanSnapshot": {
                return new TriggerMBeanSnapshotAction(xMLElement);
            }
            case "markHeap": {
                return new MarkHeapAction();
            }
            case "startRecording": {
                return new StartRecordingAction(xMLElement);
            }
            case "stopRecording": {
                return new StopRecordingAction(xMLElement);
            }
            case "startCallTracer": {
                return new StartCallTracerAction(xMLElement);
            }
            case "stopCallTracer": {
                return new StopCallTracerAction();
            }
            case "startMonitorRecording": {
                return new StartMonitorRecordingAction(xMLElement);
            }
            case "stopMonitorRecording": {
                return new StopMonitorRecordingAction();
            }
            case "startProbeRecording": {
                return new StartProbeRecordingAction(xMLElement);
            }
            case "stopProbeRecording": {
                return new StopProbeRecordingAction(xMLElement);
            }
            case "startProbeTracking": {
                return new StartProbeTrackingAction(xMLElement);
            }
            case "stopProbeTracking": {
                return new StopProbeTrackingAction(xMLElement);
            }
        }
        return null;
    }
}

