/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.probe.structures;

import com.jprofiler.api.agent.ProbeObjectType;
import com.jprofiler.api.agent.ProbeValueType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class TrackingInfo {
    static final int OBJECT_TYPE_CONTROL_OBJECT_ID = 1;
    static final int OBJECT_TYPE_CONTROL_OBJECT_DESCRIPTION = 2;
    static final int OBJECT_TYPE_HOTSPOT = 3;
    static final int VALUE_TYPE_AVERAGE = 1;
    static final int VALUE_TYPE_COUNT = 2;
    static final int VALUE_TYPE_THROUGHPUT = 3;
    private String[] descriptions;
    private ProbeObjectType objectType = ProbeObjectType.HOTSPOT;
    private ProbeValueType valueType = ProbeValueType.COUNT;

    public TrackingInfo() {
    }

    public TrackingInfo(String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType) {
        if (stringArray == null) {
            throw new IllegalArgumentException("description is null");
        }
        if (probeObjectType == null) {
            throw new IllegalArgumentException("objectType is null");
        }
        if (probeValueType == null) {
            throw new IllegalArgumentException("valueType is null");
        }
        this.descriptions = stringArray;
        this.objectType = probeObjectType;
        this.valueType = probeValueType;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.descriptions.length);
        for (String string : this.descriptions) {
            dataOutput.writeUTF(string);
        }
        dataOutput.writeInt(TrackingInfo.getObjectTypeIntValue(this.objectType));
        dataOutput.writeInt(TrackingInfo.getValueTypeIntValue(this.valueType));
    }

    public void read(DataInput dataInput, int n2) throws IOException {
        int n3 = dataInput.readInt();
        this.descriptions = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.descriptions[i2] = dataInput.readUTF();
        }
        this.objectType = TrackingInfo.getObjectTypeFromIntValue(dataInput.readInt());
        this.valueType = TrackingInfo.getValueTypeFromIntValue(dataInput.readInt());
    }

    public String[] getDescriptions() {
        return this.descriptions;
    }

    public ProbeObjectType getObjectType() {
        return this.objectType;
    }

    public ProbeValueType getValueType() {
        return this.valueType;
    }

    public void setDescriptions(String[] stringArray) {
        this.descriptions = stringArray;
    }

    public void setObjectType(ProbeObjectType probeObjectType) {
        this.objectType = probeObjectType;
    }

    public void setValueType(ProbeValueType probeValueType) {
        this.valueType = probeValueType;
    }

    public String toString() {
        return "TrackingInfo{description=" + (this.descriptions == null ? null : Arrays.asList(this.descriptions)) + ", objectType=" + (Object)((Object)this.objectType) + ", valueType=" + (Object)((Object)this.valueType) + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TrackingInfo trackingInfo = (TrackingInfo)object;
        if (!Arrays.equals(this.descriptions, trackingInfo.descriptions)) {
            return false;
        }
        if (this.objectType != null ? !this.objectType.equals((Object)trackingInfo.objectType) : trackingInfo.objectType != null) {
            return false;
        }
        return !(this.valueType != null ? !this.valueType.equals((Object)trackingInfo.valueType) : trackingInfo.valueType != null);
    }

    public int hashCode() {
        int n2 = this.descriptions != null ? Arrays.hashCode(this.descriptions) : 0;
        n2 = 31 * n2 + (this.objectType != null ? this.objectType.hashCode() : 0);
        n2 = 31 * n2 + (this.valueType != null ? this.valueType.hashCode() : 0);
        return n2;
    }

    public static ProbeValueType getValueTypeFromIntValue(int n2) {
        switch (n2) {
            case 1: {
                return ProbeValueType.TIMES;
            }
            case 2: {
                return ProbeValueType.COUNT;
            }
            case 3: {
                return ProbeValueType.THROUGHPUT;
            }
        }
        throw new IllegalArgumentException("unknown value type " + n2);
    }

    public static int getValueTypeIntValue(ProbeValueType probeValueType) {
        if (probeValueType == ProbeValueType.TIMES) {
            return 1;
        }
        if (probeValueType == ProbeValueType.COUNT) {
            return 2;
        }
        if (probeValueType == ProbeValueType.THROUGHPUT) {
            return 3;
        }
        throw new IllegalArgumentException("unknown value type " + (Object)((Object)probeValueType));
    }

    public static ProbeObjectType getObjectTypeFromIntValue(int n2) {
        switch (n2) {
            case 2: {
                return ProbeObjectType.CONTROL_OBJECT_FROM_DESCRIPTION;
            }
            case 1: {
                return ProbeObjectType.CONTROL_OBJECT_FROM_ID;
            }
            case 3: {
                return ProbeObjectType.HOTSPOT;
            }
        }
        throw new IllegalArgumentException("unknown object type " + n2);
    }

    public static int getObjectTypeIntValue(ProbeObjectType probeObjectType) {
        if (probeObjectType == ProbeObjectType.CONTROL_OBJECT_FROM_DESCRIPTION) {
            return 2;
        }
        if (probeObjectType == ProbeObjectType.CONTROL_OBJECT_FROM_ID) {
            return 1;
        }
        if (probeObjectType == ProbeObjectType.HOTSPOT) {
            return 3;
        }
        throw new IllegalArgumentException("unknown object type " + (Object)((Object)probeObjectType));
    }
}

