/*
 * Decompiled with CFR 0.152.
 */
package org.jclasslib.agent;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jclasslib.agent.ClassDescriptor;
import org.jclasslib.agent.CommunicatorMBean;
import org.jclasslib.agent.ModuleResolver;
import org.jclasslib.agent.NoModuleResolverImpl;
import org.jclasslib.agent.ReplacementResult;

public class Communicator
implements CommunicatorMBean {
    private final Instrumentation instrumentation;
    private final ModuleResolver moduleResolver = this.createModuleResolver();

    public Communicator(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    @Override
    public List<ClassDescriptor> getClasses() {
        return Arrays.stream(this.instrumentation.getAllLoadedClasses()).filter(c -> !c.isArray()).map(c -> new ClassDescriptor(c.getName(), this.moduleResolver.getModuleName((Class<?>)c))).collect(Collectors.toList());
    }

    @Override
    public byte[] getClassFile(String fileName) {
        String className = fileName.replace('/', '.');
        return this.findClass(className).map(this::getClassFile).orElse(null);
    }

    @Override
    public ReplacementResult replaceClassFile(String fileName, byte[] bytes) {
        String className = fileName.replace('/', '.');
        Class c = this.findClass(className).orElse(null);
        if (c != null) {
            try {
                this.instrumentation.redefineClasses(new ClassDefinition(c, bytes));
                return ReplacementResult.SUCCESS;
            }
            catch (Throwable e) {
                return new ReplacementResult(e.getMessage());
            }
        }
        return new ReplacementResult("The class could not be found");
    }

    private Optional<Class> findClass(String className) {
        return Arrays.stream(this.instrumentation.getAllLoadedClasses()).filter(c -> c.getName().equals(className)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassFile(Class<?> c) {
        ReadClassFileTransformer transformer = new ReadClassFileTransformer();
        try {
            this.instrumentation.addTransformer(transformer, true);
            this.instrumentation.retransformClasses(c);
        }
        catch (Throwable e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.instrumentation.removeTransformer(transformer);
        }
        return transformer.bytes;
    }

    private ModuleResolver createModuleResolver() {
        try {
            if (!System.getProperty("java.version").startsWith("1.")) {
                return (ModuleResolver)Class.forName("org.jclasslib.agent.ModuleResolverImpl").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return new NoModuleResolverImpl();
    }

    private static class ReadClassFileTransformer
    implements ClassFileTransformer {
        byte[] bytes;

        private ReadClassFileTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (classBeingRedefined != null) {
                this.bytes = classfileBuffer;
            }
            return null;
        }
    }
}

