/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.api.controller;

public class HeapDumpOptions {
    private static final boolean DEFAULT_PRIMITIVE_DATA = !HeapDumpOptions.isJ9VM();
    public static final HeapDumpOptions DEFAULT = new HeapDumpOptions().freeze();
    public static final HeapDumpOptions SELECT_RECORDED = new HeapDumpOptions().selectRecorded(true).freeze();
    public static final HeapDumpOptions NO_FULL_GC = new HeapDumpOptions().fullGc(false).freeze();
    private boolean fullGc = true;
    private boolean primitiveData = DEFAULT_PRIMITIVE_DATA;
    private boolean calculateRetainedSizes = true;
    private boolean selectRecorded = false;
    private boolean retainSoftReferences = true;
    private boolean retainWeakReferences = false;
    private boolean retainPhantomReferences = false;
    private boolean retainFinalizerReferences = false;
    private boolean frozen = false;

    public HeapDumpOptions fullGc(boolean fullGc) {
        this.checkFrozen();
        this.fullGc = fullGc;
        return this;
    }

    public HeapDumpOptions primitiveData(boolean primitiveData) {
        this.checkFrozen();
        this.primitiveData = primitiveData;
        return this;
    }

    public HeapDumpOptions calculateRetainedSizes(boolean calculateRetainedSizes) {
        this.checkFrozen();
        this.calculateRetainedSizes = calculateRetainedSizes;
        return this;
    }

    public HeapDumpOptions selectRecorded(boolean selectRecorded) {
        this.checkFrozen();
        this.selectRecorded = selectRecorded;
        return this;
    }

    public HeapDumpOptions retainSoftReferences(boolean retainSoftReferences) {
        this.checkFrozen();
        this.retainSoftReferences = retainSoftReferences;
        return this;
    }

    public HeapDumpOptions retainWeakReferences(boolean retainWeakReferences) {
        this.checkFrozen();
        this.retainWeakReferences = retainWeakReferences;
        return this;
    }

    public HeapDumpOptions retainPhantomReferences(boolean retainPhantomReferences) {
        this.checkFrozen();
        this.retainPhantomReferences = retainPhantomReferences;
        return this;
    }

    public HeapDumpOptions retainFinalizerReferences(boolean retainFinalizerReferences) {
        this.checkFrozen();
        this.retainFinalizerReferences = retainFinalizerReferences;
        return this;
    }

    public boolean isFullGc() {
        return this.fullGc;
    }

    public boolean isPrimitiveData() {
        return this.primitiveData;
    }

    public boolean isCalculateRetainedSizes() {
        return this.calculateRetainedSizes;
    }

    public boolean isSelectRecorded() {
        return this.selectRecorded;
    }

    public boolean isRetainSoftReferences() {
        return this.retainSoftReferences;
    }

    public boolean isRetainWeakReferences() {
        return this.retainWeakReferences;
    }

    public boolean isRetainPhantomReferences() {
        return this.retainPhantomReferences;
    }

    public boolean isRetainFinalizerReferences() {
        return this.retainFinalizerReferences;
    }

    public HeapDumpOptions freeze() {
        this.frozen = true;
        return this;
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException("parameters are frozen");
        }
    }

    private static boolean isJ9VM() {
        String vmVendor = System.getProperty("java.vm.vendor", "").toLowerCase();
        return vmVendor.contains("ibm") || vmVendor.contains("openj9");
    }
}

