/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.util;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/gjt/jclasslib/util/MenuButton;", "Ljavax/swing/JButton;", "text", "", "popupMenu", "Ljavax/swing/JPopupMenu;", "<init>", "(Ljava/lang/String;Ljavax/swing/JPopupMenu;)V", "setEnabled", "", "enabled", "", "MenuButtonModel", "browser"})
public final class MenuButton
extends JButton {
    @NotNull
    private final JPopupMenu popupMenu;

    public MenuButton(@Nls @NotNull String text, @NotNull JPopupMenu popupMenu) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)popupMenu, (String)"popupMenu");
        super(text);
        this.popupMenu = popupMenu;
        this.setModel(new MenuButtonModel());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.popupMenu.setEnabled(enabled);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gjt/jclasslib/util/MenuButton$MenuButtonModel;", "Ljavax/swing/DefaultButtonModel;", "<init>", "(Lorg/gjt/jclasslib/util/MenuButton;)V", "programmatic", "", "cachedRollover", "setPressed", "", "pressed", "setRollover", "rollover", "fireActionPerformed", "e", "Ljava/awt/event/ActionEvent;", "isPopupMenuShown", "browser"})
    private final class MenuButtonModel
    extends DefaultButtonModel {
        private boolean programmatic;
        private boolean cachedRollover;

        public MenuButtonModel() {
            MenuButton.this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    programmatic = true;
                    if (this.isPressed()) {
                        this.setPressed(false);
                    }
                    if (this.isRollover()) {
                        this.setRollover(cachedRollover);
                    }
                    programmatic = false;
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                }
            });
        }

        @Override
        public void setPressed(boolean pressed) {
            if (this.isPopupMenuShown()) {
                if (pressed) {
                    super.setPressed(true);
                    Rectangle bounds = MenuButton.this.getBounds();
                    int x = bounds.x;
                    MenuButton.this.popupMenu.show(MenuButton.this.getParent(), x, bounds.y + bounds.height);
                } else if (this.programmatic || !MenuButton.this.popupMenu.isVisible()) {
                    super.setPressed(false);
                }
            } else {
                super.setPressed(pressed);
            }
        }

        @Override
        public void setRollover(boolean rollover) {
            if (this.isPopupMenuShown()) {
                this.cachedRollover = rollover;
                if (this.programmatic || rollover || !MenuButton.this.popupMenu.isVisible()) {
                    super.setRollover(rollover);
                }
            } else {
                super.setRollover(rollover);
            }
        }

        @Override
        protected void fireActionPerformed(@NotNull ActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (MenuButton.this.popupMenu.getComponentCount() == 1) {
                Component component = MenuButton.this.popupMenu.getComponent(0);
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JMenuItem");
                ((JMenuItem)component).doClick();
            }
            super.fireActionPerformed(e);
        }

        private final boolean isPopupMenuShown() {
            return MenuButton.this.popupMenu.getComponentCount() > 1;
        }
    }
}

