/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.util;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.util.UiDefaultsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/gjt/jclasslib/util/HyperlinkButton;", "Ljavax/swing/JButton;", "<init>", "()V", "updateUI", "", "getUIClassID", "", "BasicLinkButtonUI", "browser"})
public final class HyperlinkButton
extends JButton {
    public HyperlinkButton() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setRolloverEnabled(true);
        this.setOpaque(false);
    }

    @Override
    public void updateUI() {
        this.setUI(BasicLinkButtonUI.Companion.createUI(this));
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return "LinkButtonUI";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/gjt/jclasslib/util/HyperlinkButton$BasicLinkButtonUI;", "Ljavax/swing/plaf/basic/BasicButtonUI;", "<init>", "()V", "installDefaults", "", "button", "Ljavax/swing/AbstractButton;", "paintText", "graphics", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "rect", "Ljava/awt/Rectangle;", "s", "", "Companion", "browser"})
    private static final class BasicLinkButtonUI
    extends BasicButtonUI {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final BasicStroke STROKE_DASHED;
        @NotNull
        private static final Border BORDER;

        @Override
        protected void installDefaults(@NotNull AbstractButton button) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            super.installDefaults(button);
            button.setBorder(BORDER);
        }

        @Override
        protected void paintText(@NotNull Graphics graphics, @NotNull JComponent c, @NotNull Rectangle rect, @NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Graphics2D g = (Graphics2D)graphics;
            HyperlinkButton button = (HyperlinkButton)c;
            ButtonModel model = button.getModel();
            boolean enabled = button.isEnabled();
            if (enabled && model.isEnabled()) {
                if (model.isPressed()) {
                    button.setForeground(UiDefaultsKt.getActiveLinkColor());
                } else {
                    button.setForeground(UiDefaultsKt.getLinkColor());
                }
            }
            super.paintText((Graphics)g, c, rect, s);
            if (enabled) {
                boolean focus;
                FontMetrics fm = g.getFontMetrics();
                int x = rect.x + this.getTextShiftOffset();
                int y = rect.y + fm.getAscent() + fm.getDescent() + this.getTextShiftOffset() - 1;
                Stroke oldStroke = g.getStroke();
                g.setColor(model.isEnabled() ? button.getForeground() : button.getBackground().brighter());
                boolean bl = focus = button.isFocusPainted() && button.hasFocus() && !model.isArmed() && !model.isPressed();
                if (focus) {
                    g.setStroke(STROKE_DASHED);
                    Object oldAntiAliasValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.drawRect(x - 1, rect.y + 2, rect.width + 3, rect.height - 3);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasValue);
                } else {
                    g.drawLine(x, y, x + rect.width - 1, y);
                }
                g.setStroke(oldStroke);
            }
        }

        @JvmStatic
        @NotNull
        public static final ComponentUI createUI(@Nullable JComponent component) {
            return Companion.createUI(component);
        }

        static {
            float[] fArray = new float[]{2.0f, 2.0f};
            STROKE_DASHED = new BasicStroke(1.0f, 1, 2, 10.0f, fArray, 0.0f);
            BORDER = new EmptyBorder(0, 3, 0, 3);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gjt/jclasslib/util/HyperlinkButton$BasicLinkButtonUI$Companion;", "", "<init>", "()V", "STROKE_DASHED", "Ljava/awt/BasicStroke;", "BORDER", "Ljavax/swing/border/Border;", "createUI", "Ljavax/swing/plaf/ComponentUI;", "component", "Ljavax/swing/JComponent;", "browser"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final ComponentUI createUI(@Nullable JComponent component) {
                return new BasicLinkButtonUI();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

