/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gjt.jclasslib.browser.config.classpath.ClasspathArchiveEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathComponent;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathJrtEntry;
import org.gjt.jclasslib.browser.config.classpath.FindResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0001H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0006H\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u000ej\b\u0012\u0004\u0012\u00020\u0006`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/gjt/jclasslib/browser/config/ClassPathContainer;", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathComponent;", "<init>", "()V", "classpath", "", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathEntry;", "getClasspath", "()Ljava/util/List;", "jreHome", "", "getJreHome", "()Ljava/lang/String;", "mergedEntries", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findClass", "Lorg/gjt/jclasslib/browser/config/classpath/FindResult;", "className", "modulePathSelection", "", "mergeClassesIntoTree", "", "classPathModel", "Ljavax/swing/tree/DefaultTreeModel;", "modulePathModel", "reset", "contains", "component", "createJreEntry", "browser"})
public abstract class ClassPathContainer
implements ClasspathComponent {
    @NotNull
    private final HashSet<ClasspathEntry> mergedEntries = new HashSet();

    @NotNull
    public abstract List<ClasspathEntry> getClasspath();

    @NotNull
    public abstract String getJreHome();

    @Override
    @Nullable
    public FindResult findClass(@NotNull String className, boolean modulePathSelection) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        for (ClasspathEntry entry : this.getClasspath()) {
            FindResult findResult = entry.findClass(className, modulePathSelection);
            if (findResult == null) continue;
            return findResult;
        }
        ClasspathEntry classpathEntry = this.createJreEntry();
        return classpathEntry != null ? classpathEntry.findClass(className, modulePathSelection) : null;
    }

    @Override
    public void mergeClassesIntoTree(@NotNull DefaultTreeModel classPathModel, @NotNull DefaultTreeModel modulePathModel, boolean reset) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)classPathModel, (String)"classPathModel");
            Intrinsics.checkNotNullParameter((Object)modulePathModel, (String)"modulePathModel");
            for (ClasspathEntry entry : this.getClasspath()) {
                if (!reset && this.mergedEntries.contains(entry)) continue;
                entry.mergeClassesIntoTree(classPathModel, modulePathModel, reset);
                this.mergedEntries.add(entry);
            }
            ClasspathEntry classpathEntry = this.createJreEntry();
            if (classpathEntry == null) break block1;
            classpathEntry.mergeClassesIntoTree(classPathModel, modulePathModel, reset);
        }
    }

    @Override
    public boolean contains(@NotNull ClasspathComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component instanceof ClassPathContainer ? Intrinsics.areEqual((Object)this.getJreHome(), (Object)((ClassPathContainer)component).getJreHome()) && this.getClasspath().containsAll((Collection)((ClassPathContainer)component).getClasspath()) : false;
    }

    private final ClasspathEntry createJreEntry() {
        ClasspathEntry classpathEntry;
        if (new File(this.getJreHome(), "lib/modules").exists()) {
            classpathEntry = new ClasspathJrtEntry(this.getJreHome());
        } else if (new File(this.getJreHome(), "lib/rt.jar").exists()) {
            String string = new File(this.getJreHome(), "lib/rt.jar").getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            classpathEntry = new ClasspathArchiveEntry(string);
        } else {
            return null;
        }
        return classpathEntry;
    }
}

