/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserComponent;
import org.gjt.jclasslib.browser.BrowserHistory;
import org.gjt.jclasslib.browser.BrowserTab;
import org.gjt.jclasslib.browser.FrameContent;
import org.gjt.jclasslib.browser.config.BrowserPath;
import org.gjt.jclasslib.util.AlertFacade;
import org.gjt.jclasslib.util.AlertFacadeKt;
import org.gjt.jclasslib.util.ClosableTabComponent;
import org.gjt.jclasslib.util.DnDTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000J\"\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\nJ6\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0!J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u000eH\u0016J\u0006\u0010$\u001a\u00020\u000eJ\u0006\u0010%\u001a\u00020\u000eJ\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010'\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\nJ\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0006\u0010,\u001a\u00020)J\u0006\u0010-\u001a\u00020)J\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u000203H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u00064"}, d2={"Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "Lorg/gjt/jclasslib/util/DnDTabbedPane;", "Lorg/gjt/jclasslib/util/ClosableTabComponent$RemovalChecker;", "container", "Lorg/gjt/jclasslib/browser/FrameContent;", "<init>", "(Lorg/gjt/jclasslib/browser/FrameContent;)V", "getContainer", "()Lorg/gjt/jclasslib/browser/FrameContent;", "selectedTab", "Lorg/gjt/jclasslib/browser/BrowserTab;", "getSelectedTab", "()Lorg/gjt/jclasslib/browser/BrowserTab;", "transferTabsFrom", "", "other", "addTab", "fileName", "", "moduleName", "browserPath", "Lorg/gjt/jclasslib/browser/config/BrowserPath;", "browserTab", "insertTab", "title", "icon", "Ljavax/swing/Icon;", "component", "Ljava/awt/Component;", "tip", "index", "", "tabs", "", "setSelectedComponent", "removeAll", "focus", "updateSelectedTitle", "updateTitleAt", "updateTitleOf", "canRemove", "", "getBrowserTabAt", "removed", "canClose", "hasModified", "isDataFlavorSupported", "transferable", "Ljava/awt/datatransfer/Transferable;", "handleDrop", "event", "Ljava/awt/dnd/DropTargetDropEvent;", "browser"})
@SourceDebugExtension(value={"SMAP\nBrowserTabbedPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserTabbedPane.kt\norg/gjt/jclasslib/browser/BrowserTabbedPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1863#2,2:145\n1755#2,3:147\n1557#2:150\n1628#2,3:151\n1734#2,3:154\n1734#2,3:157\n*S KotlinDebug\n*F\n+ 1 BrowserTabbedPane.kt\norg/gjt/jclasslib/browser/BrowserTabbedPane\n*L\n46#1:145,2\n119#1:147,3\n126#1:150\n126#1:151,3\n129#1:154,3\n132#1:157,3\n*E\n"})
public final class BrowserTabbedPane
extends DnDTabbedPane
implements ClosableTabComponent.RemovalChecker {
    @NotNull
    private final FrameContent container;

    public BrowserTabbedPane(@NotNull FrameContent container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.container = container;
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.focus();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.focus();
            }
        });
    }

    @NotNull
    public final FrameContent getContainer() {
        return this.container;
    }

    @Nullable
    public final BrowserTab getSelectedTab() {
        return (BrowserTab)this.getSelectedComponent();
    }

    public final void transferTabsFrom(@NotNull BrowserTabbedPane other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Iterable $this$forEach$iv = CollectionsKt.toList(other.tabs());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BrowserTab it = (BrowserTab)element$iv;
            boolean bl = false;
            this.addTab(it);
        }
    }

    @NotNull
    public final BrowserTab addTab(@NotNull String fileName, @NotNull String moduleName, @Nullable BrowserPath browserPath) {
        BrowserTab browserTab;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        BrowserTab $this$addTab_u24lambda_u241 = browserTab = new BrowserTab(fileName, moduleName, this.container.getFrame());
        boolean bl = false;
        this.addTab($this$addTab_u24lambda_u241);
        $this$addTab_u24lambda_u241.setBrowserPath(browserPath);
        return browserTab;
    }

    public static /* synthetic */ BrowserTab addTab$default(BrowserTabbedPane browserTabbedPane, String string, String string2, BrowserPath browserPath, int n, Object object) {
        if ((n & 4) != 0) {
            browserPath = null;
        }
        return browserTabbedPane.addTab(string, string2, browserPath);
    }

    public final void addTab(@NotNull BrowserTab browserTab) {
        Intrinsics.checkNotNullParameter((Object)browserTab, (String)"browserTab");
        this.addTab(browserTab.getTabTitle(), browserTab);
        this.setSelectedComponent(browserTab);
    }

    @Override
    public void insertTab(@Nullable String title, @Nullable Icon icon, @NotNull Component component, @Nullable String tip, int index) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super.insertTab(title, icon, component, tip, index);
        this.setTabComponentAt(index, new ClosableTabComponent(this));
        this.fireStateChanged();
    }

    @NotNull
    public final Iterable<BrowserTab> tabs() {
        return new Iterable<BrowserTab>(this){
            final /* synthetic */ BrowserTabbedPane this$0;
            {
                this.this$0 = browserTabbedPane;
            }

            public Iterator<BrowserTab> iterator() {
                boolean bl = false;
                return new Iterator<BrowserTab>(this.this$0){
                    private int index;
                    final /* synthetic */ BrowserTabbedPane this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final int getIndex() {
                        return this.index;
                    }

                    public final void setIndex(int n) {
                        this.index = n;
                    }

                    public BrowserTab next() {
                        int n = this.index;
                        this.index = n + 1;
                        Component component = this.this$0.getComponentAt(n);
                        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTab");
                        return (BrowserTab)component;
                    }

                    public boolean hasNext() {
                        return this.index < this.this$0.getTabCount();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @Override
    public void setSelectedComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super.setSelectedComponent(component);
        this.focus();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.fireStateChanged();
    }

    public final void focus() {
        block0: {
            this.container.focus(this);
            Object object = this.getSelectedTab();
            if (object == null || (object = ((BrowserTab)object).getBrowserComponent()) == null || (object = ((BrowserComponent)object).getHistory()) == null) break block0;
            ((BrowserHistory)object).updateActions();
        }
    }

    public final void updateSelectedTitle() {
        this.updateTitleAt(this.getSelectedIndex());
    }

    public final void updateTitleAt(int index) {
        this.setTitleAt(index, this.getBrowserTabAt(index).getTabTitle());
        this.getTabComponentAt(index).revalidate();
    }

    public final void updateTitleOf(@NotNull BrowserTab browserTab) {
        Intrinsics.checkNotNullParameter((Object)browserTab, (String)"browserTab");
        int index = this.indexOfComponent(browserTab);
        if (index > -1) {
            this.updateTitleAt(index);
        }
    }

    @Override
    public boolean canRemove(int index) {
        return this.getBrowserTabAt(index).getBrowserComponent().canRemove();
    }

    private final BrowserTab getBrowserTabAt(int index) {
        Component component = this.getComponentAt(index);
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTab");
        return (BrowserTab)component;
    }

    @Override
    public void removed(int index) {
        this.container.updateSaveAction();
    }

    public final boolean canClose() {
        return !this.hasModified() || AlertFacade.DefaultImpls.showDiscardCancelDialog$default(AlertFacadeKt.getAlertFacade(), this, BrowserBundle.INSTANCE.getString("message.class.files.modified.title", new Object[0]), BrowserBundle.INSTANCE.getString("message.class.files.modified", new Object[0]), false, 8, null).getSelectedIndex() == 0;
    }

    public final boolean hasModified() {
        boolean bl;
        block3: {
            Iterable<BrowserTab> $this$any$iv = this.tabs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<BrowserTab> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    BrowserTab element$iv;
                    BrowserTab it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!it.getBrowserComponent().isModified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected boolean isDataFlavorSupported(@NotNull Transferable transferable) {
        Intrinsics.checkNotNullParameter((Object)transferable, (String)"transferable");
        return transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleDrop(@NotNull DropTargetDropEvent event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.acceptDrop(1);
        Object object = event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
        Iterable $this$map$iv = (List)object;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type java.io.File");
            collection.add((File)it);
        }
        List files = (List)destination$iv$iv;
        EventQueue.invokeLater(() -> BrowserTabbedPane.handleDrop$lambda$7(this, files, event));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void handleDrop$lambda$7(BrowserTabbedPane this$0, List $files, DropTargetDropEvent $event) {
        boolean bl;
        block12: {
            File it;
            boolean $i$f$all;
            Iterable $this$all$iv;
            this$0.focus();
            if ($files.size() == 1) {
                boolean bl2;
                block11: {
                    $this$all$iv = $files;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (File)element$iv;
                            boolean bl3 = false;
                            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"jar")) continue;
                            bl2 = false;
                            break block11;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    this$0.container.getFrame().openClassFromJar((File)$files.get(0));
                    $event.dropComplete(true);
                    return;
                }
            }
            $this$all$iv = $files;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (File)element$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"class")) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            for (File file : $files) {
                this$0.container.getFrame().openClassFromFile(file);
            }
            $event.dropComplete(true);
            return;
        } else {
            $event.dropComplete(false);
        }
    }
}

