/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import com.install4j.runtime.filechooser.DirectoryChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dom.build.BuilderKt;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserClassFileIOKt;
import org.gjt.jclasslib.browser.BrowserComponent;
import org.gjt.jclasslib.browser.BrowserFrame;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTabbedPane;
import org.gjt.jclasslib.browser.FrameContent;
import org.gjt.jclasslib.browser.config.BrowserPath;
import org.gjt.jclasslib.browser.config.classpath.FindResult;
import org.gjt.jclasslib.io.ClassFileWriter;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.util.AlertFacade;
import org.gjt.jclasslib.util.AlertFacadeKt;
import org.gjt.jclasslib.util.AlertType;
import org.gjt.jclasslib.util.GUIHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\"\u001a\u00020#H\u0016J\u001a\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u0013\u00102\u001a\u0004\u0018\u0001032\u0006\u0010+\u001a\u00020\u0004H\u0082\u0010J\u0010\u00104\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0006\u00105\u001a\u00020#J\b\u00106\u001a\u00020#H\u0002J\b\u00107\u001a\u00020/H\u0016J\b\u00108\u001a\u00020/H\u0016J\u0010\u00109\u001a\u00020#2\u0006\u0010:\u001a\u00020\u0004H\u0016J\b\u0010;\u001a\u00020#H\u0016J\u0006\u0010<\u001a\u00020\u0004J\u0010\u0010=\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010-J\u000e\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020@J\u0006\u0010A\u001a\u00020#J\b\u0010B\u001a\u00020#H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'\u00a8\u0006D"}, d2={"Lorg/gjt/jclasslib/browser/BrowserTab;", "Ljavax/swing/JPanel;", "Lorg/gjt/jclasslib/browser/BrowserServices;", "fileName", "", "moduleName", "frame", "Lorg/gjt/jclasslib/browser/BrowserFrame;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/gjt/jclasslib/browser/BrowserFrame;)V", "getFileName", "()Ljava/lang/String;", "getModuleName", "tabbedPane", "Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "getTabbedPane", "()Lorg/gjt/jclasslib/browser/BrowserTabbedPane;", "frameContent", "Lorg/gjt/jclasslib/browser/FrameContent;", "getFrameContent", "()Lorg/gjt/jclasslib/browser/FrameContent;", "parentFrame", "getParentFrame", "()Lorg/gjt/jclasslib/browser/BrowserFrame;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "getClassFile", "()Lorg/gjt/jclasslib/structures/ClassFile;", "setClassFile", "(Lorg/gjt/jclasslib/structures/ClassFile;)V", "browserComponent", "Lorg/gjt/jclasslib/browser/BrowserComponent;", "getBrowserComponent", "()Lorg/gjt/jclasslib/browser/BrowserComponent;", "activate", "", "backwardAction", "Ljavax/swing/Action;", "getBackwardAction", "()Ljavax/swing/Action;", "forwardAction", "getForwardAction", "openClassFile", "className", "browserPath", "Lorg/gjt/jclasslib/browser/config/BrowserPath;", "saveClassToDirectory", "", "directory", "Ljava/io/File;", "findClass", "Lorg/gjt/jclasslib/browser/config/classpath/FindResult;", "isRetryFindClass", "reload", "select", "canOpenClassFiles", "canSaveClassFiles", "showURL", "urlSpec", "modified", "getTabTitle", "setBrowserPath", "saveWorkspace", "element", "Lorg/w3c/dom/Element;", "saveModified", "resetModified", "Companion", "browser"})
public final class BrowserTab
extends JPanel
implements BrowserServices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileName;
    @NotNull
    private final String moduleName;
    @NotNull
    private ClassFile classFile;
    @NotNull
    private final BrowserComponent browserComponent;
    @NotNull
    public static final String NODE_NAME = "tab";
    @NotNull
    private static final String ATTRIBUTE_FILE_NAME = "fileName";
    @NotNull
    private static final String ATTRIBUTE_MODULE_NAME = "moduleName";

    public BrowserTab(@NotNull String fileName, @NotNull String moduleName, @NotNull BrowserFrame frame) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)ATTRIBUTE_FILE_NAME);
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)ATTRIBUTE_MODULE_NAME);
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.fileName = fileName;
        this.moduleName = moduleName;
        this.classFile = BrowserClassFileIOKt.readClassFile$default(this.fileName, frame, false, 4, null);
        this.browserComponent = new BrowserComponent(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getBrowserComponent(), "Center");
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    private final BrowserTabbedPane getTabbedPane() {
        Container container = SwingUtilities.getAncestorOfClass(BrowserTabbedPane.class, this);
        Intrinsics.checkNotNull((Object)container, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTabbedPane");
        return (BrowserTabbedPane)container;
    }

    private final FrameContent getFrameContent() {
        return this.getTabbedPane().getContainer();
    }

    private final BrowserFrame getParentFrame() {
        return this.getFrameContent().getFrame();
    }

    @Override
    @NotNull
    public ClassFile getClassFile() {
        return this.classFile;
    }

    public void setClassFile(@NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"<set-?>");
        this.classFile = classFile;
    }

    @Override
    @NotNull
    public BrowserComponent getBrowserComponent() {
        return this.browserComponent;
    }

    @Override
    public void activate() {
        this.getTabbedPane().focus();
    }

    @Override
    @NotNull
    public Action getBackwardAction() {
        return this.getParentFrame().getBackwardAction();
    }

    @Override
    @NotNull
    public Action getForwardAction() {
        return this.getParentFrame().getForwardAction();
    }

    @Override
    public void openClassFile(@NotNull String className, @Nullable BrowserPath browserPath) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        FindResult findResult = this.findClass(className);
        if (findResult != null) {
            BrowserTab openTab = this.getFrameContent().findTab(findResult.getFileName());
            if (openTab != null) {
                BrowserTab browserTab;
                BrowserTab $this$openClassFile_u24lambda_u240 = browserTab = openTab;
                boolean bl = false;
                $this$openClassFile_u24lambda_u240.select();
                $this$openClassFile_u24lambda_u240.getBrowserComponent().setBrowserPath(browserPath);
            } else {
                try {
                    BrowserTab browserTab = this.getTabbedPane().addTab(findResult.getFileName(), findResult.getModuleName(), browserPath);
                }
                catch (IOException e) {
                    AlertFacadeKt.getAlertFacade().showMessage(this.getParentFrame(), e);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    public final boolean saveClassToDirectory(@NotNull File directory) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        String simpleClassName = this.getClassFile().getSimpleClassName();
        File packageDirectory = new File(directory, StringsKt.removeSuffix((String)this.getClassFile().getThisClassName(), (CharSequence)simpleClassName));
        packageDirectory.mkdirs();
        File file = new File(packageDirectory, simpleClassName + ".class");
        try {
            ClassFileWriter.writeToFile((File)file, (ClassFile)this.getClassFile());
            bl = true;
        }
        catch (Exception e) {
            AlertFacade alertFacade2 = AlertFacadeKt.getAlertFacade();
            Component component = this.getParentFrame();
            Object[] objectArray = new Object[]{file.getPath()};
            String string = BrowserBundle.INSTANCE.getString("message.class.save.error", objectArray);
            objectArray = new Object[1];
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            objectArray[0] = string2;
            AlertFacade.DefaultImpls.showMessage$default(alertFacade2, component, string, BrowserBundle.INSTANCE.getString("message.error.message", objectArray), AlertType.ERROR, false, 16, null);
            bl = false;
        }
        return bl;
    }

    private final FindResult findClass(String className) {
        FindResult result;
        BrowserTab browserTab = this;
        while ((result = browserTab.getParentFrame().getClasspathComponent().findClass(className, false)) == null && browserTab.isRetryFindClass(className)) {
            browserTab.getParentFrame().getSetupClasspathAction().invoke();
            BrowserTab browserTab2 = browserTab;
            String string = className;
            browserTab = browserTab2;
            className = string;
        }
        return result;
    }

    private final boolean isRetryFindClass(String className) {
        boolean bl;
        if (this.getParentFrame().getVmConnection() != null) {
            Object[] objectArray = new Object[]{className};
            AlertFacade.DefaultImpls.showMessage$default(AlertFacadeKt.getAlertFacade(), this.getParentFrame(), BrowserBundle.INSTANCE.getString("message.class.not.loaded", objectArray), null, AlertType.WARNING, false, 16, null);
            bl = false;
        } else {
            Object[] objectArray = new Object[]{className};
            String string = BrowserBundle.INSTANCE.getString("message.class.not.found", objectArray);
            objectArray = new String[]{BrowserBundle.INSTANCE.getString("action.setup.class.path", new Object[0]), BrowserBundle.INSTANCE.getString("action.cancel", new Object[0])};
            bl = AlertFacade.DefaultImpls.showOptionDialog$default(AlertFacadeKt.getAlertFacade(), this.getParentFrame(), BrowserBundle.INSTANCE.getString("message.class.not.found.title", new Object[0]), string, (String[])objectArray, AlertType.WARNING, false, 32, null).getSelectedIndex() == 0;
        }
        return bl;
    }

    public final void reload() {
        if (this.getBrowserComponent().canRemove()) {
            this.resetModified();
            this.setClassFile(BrowserClassFileIOKt.readClassFile$default(this.fileName, this.getParentFrame(), false, 4, null));
            this.getBrowserComponent().rebuild();
        }
    }

    private final void select() {
        this.getTabbedPane().setSelectedComponent(this);
        this.getTabbedPane().focus();
        this.getBrowserComponent().getTreePane().getTree().requestFocus();
    }

    @Override
    public boolean canOpenClassFiles() {
        return true;
    }

    @Override
    public boolean canSaveClassFiles() {
        return true;
    }

    @Override
    public void showURL(@NotNull String urlSpec) {
        Intrinsics.checkNotNullParameter((Object)urlSpec, (String)"urlSpec");
        GUIHelper.INSTANCE.showURL(urlSpec);
    }

    @Override
    public void modified() {
        this.getTabbedPane().updateSelectedTitle();
        this.getFrameContent().updateSaveAction();
    }

    @NotNull
    public final String getTabTitle() {
        return (this.getBrowserComponent().isModified() ? "* " : "") + (String)(!Intrinsics.areEqual((Object)this.moduleName, (Object)"<unnamed module>") ? this.moduleName + "/" : "") + this.getBrowserComponent().getTitle();
    }

    public final void setBrowserPath(@Nullable BrowserPath browserPath) {
        this.getBrowserComponent().setBrowserPath(browserPath);
    }

    public final void saveWorkspace(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BuilderKt.addElement$default((Element)element, (String)NODE_NAME, null, arg_0 -> BrowserTab.saveWorkspace$lambda$1(this, arg_0), (int)2, null);
    }

    public final void saveModified() {
        if (this.getBrowserComponent().isModified()) {
            try {
                Function0 directoryChooser = () -> BrowserTab.saveModified$lambda$2(this);
                if (BrowserClassFileIOKt.writeClassFile(this.getClassFile(), this.fileName, this.getParentFrame(), this.getParentFrame().getVmConnection(), (Function0<? extends File>)directoryChooser)) {
                    this.resetModified();
                }
            }
            catch (IOException e) {
                AlertFacadeKt.getAlertFacade().showMessage(this.getParentFrame(), e);
            }
        }
    }

    private final void resetModified() {
        this.getBrowserComponent().setModified(false);
        this.getTabbedPane().updateTitleOf(this);
    }

    private static final Unit saveWorkspace$lambda$1(BrowserTab this$0, Element $this$addElement) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"$this$addElement");
            $this$addElement.setAttribute(ATTRIBUTE_FILE_NAME, this$0.fileName);
            $this$addElement.setAttribute(ATTRIBUTE_MODULE_NAME, this$0.moduleName);
            BrowserPath browserPath = this$0.getBrowserComponent().getBrowserPath();
            if (browserPath == null) break block0;
            browserPath.saveWorkspace($this$addElement);
        }
        return Unit.INSTANCE;
    }

    private static final File saveModified$lambda$2(BrowserTab this$0) {
        DirectoryChooser fileChooser = this$0.getParentFrame().getSaveModifiedClassesFileChooser();
        return fileChooser.select() ? fileChooser.getSelectedDirectory() : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gjt/jclasslib/browser/BrowserTab$Companion;", "", "<init>", "()V", "NODE_NAME", "", "ATTRIBUTE_FILE_NAME", "ATTRIBUTE_MODULE_NAME", "create", "Lorg/gjt/jclasslib/browser/BrowserTab;", "element", "Lorg/w3c/dom/Element;", "frame", "Lorg/gjt/jclasslib/browser/BrowserFrame;", "browser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BrowserTab create(@NotNull Element element, @NotNull BrowserFrame frame) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            String string = element.getAttribute(BrowserTab.ATTRIBUTE_FILE_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            Object object = element.getAttributeNode(BrowserTab.ATTRIBUTE_MODULE_NAME);
            if (object == null || (object = object.getValue()) == null) {
                object = "<unnamed module>";
            }
            return new BrowserTab(string, (String)object, frame);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

