/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserFrame;
import org.gjt.jclasslib.browser.VmConnection;
import org.gjt.jclasslib.io.ClassFileReader;
import org.gjt.jclasslib.io.ClassFileWriter;
import org.gjt.jclasslib.io.JimageKt;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.util.AlertFacade;
import org.gjt.jclasslib.util.AlertFacadeKt;
import org.gjt.jclasslib.util.AlertType;
import org.gjt.jclasslib.util.OptionAlertResult;
import org.jclasslib.agent.ReplacementResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a:\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011\u001a\u0012\u0010\u0013\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a<\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002\u001a*\u0010\u0015\u001a\u00020\u00072\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\"\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"readClassFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "fileName", "", "frame", "Lorg/gjt/jclasslib/browser/BrowserFrame;", "suppressEOF", "", "persistentSavingConfirmationIndex", "", "writeClassFile", "classFile", "parentWindow", "Ljava/awt/Window;", "vmConnection", "Lorg/gjt/jclasslib/browser/VmConnection;", "directoryChooser", "Lkotlin/Function0;", "Ljava/io/File;", "getSavingConfirmationIndex", "writeClassFileUnguarded", "writeClassFileToDirectory", "splitJarFileName", "Lkotlin/Pair;", "JAR_PREFIX", "browser"})
public final class BrowserClassFileIOKt {
    private static int persistentSavingConfirmationIndex = -1;
    @NotNull
    private static final String JAR_PREFIX = "jar://";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final ClassFile readClassFile(@NotNull String fileName, @NotNull BrowserFrame frame, boolean suppressEOF) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        try {
            ClassFile classFile;
            VmConnection vmConnection = frame.getVmConnection();
            if (vmConnection != null) {
                byte[] bytes = vmConnection.getCommunicator().getClassFile(fileName);
                if (bytes == null) throw new IOException("The class " + fileName + " was not found");
                classFile = ClassFileReader.readFromInputStream$default((InputStream)new ByteArrayInputStream(bytes), (boolean)false, (int)2, null);
                return classFile;
            } else if (StringsKt.startsWith$default((String)fileName, (String)"jrt:", (boolean)false, (int)2, null)) {
                classFile = ClassFileReader.readFromInputStream((InputStream)JimageKt.getJrtInputStream((String)StringsKt.removePrefix((String)fileName, (CharSequence)"jrt:"), (File)new File(frame.getConfig().getJreHome())), (boolean)suppressEOF);
                return classFile;
            } else if (StringsKt.contains$default((CharSequence)fileName, (char)'!', (boolean)false, (int)2, null)) {
                Pair<String, String> bytes = BrowserClassFileIOKt.splitJarFileName(fileName);
                String jarFileName = (String)bytes.component1();
                String classFileName = (String)bytes.component2();
                Closeable closeable = new JarFile(jarFileName);
                Throwable throwable = null;
                try {
                    JarFile jarFile = (JarFile)closeable;
                    boolean bl = false;
                    JarEntry jarEntry = jarFile.getJarEntry(classFileName);
                    if (jarEntry == null) {
                        throw new IOException("The jar entry " + classFileName + " was not found");
                    }
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    ClassFile classFile2 = ClassFileReader.readFromInputStream((InputStream)inputStream, (boolean)suppressEOF);
                    classFile = classFile2;
                    return classFile;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                classFile = ClassFileReader.readFromFile((File)new File(fileName), (boolean)suppressEOF);
            }
            return classFile;
        }
        catch (FileNotFoundException ex) {
            throw new IOException("The file " + fileName + " was not found");
        }
        catch (EOFException ex) {
            Object[] objectArray = new Object[]{fileName};
            if (AlertFacade.DefaultImpls.showYesNoDialog$default(AlertFacadeKt.getAlertFacade(), frame, BrowserBundle.INSTANCE.getString("message.eof.title", new Object[0]), BrowserBundle.INSTANCE.getString("message.eof", objectArray), false, 8, null).getSelectedIndex() == 0) {
                return BrowserClassFileIOKt.readClassFile(fileName, frame, true);
            }
            ex.printStackTrace();
            throw new IOException("An (expected) EOF occurred while reading " + fileName);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IOException("An error occurred while reading " + fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("The file " + fileName + " does not seem to contain a class file");
        }
    }

    public static /* synthetic */ ClassFile readClassFile$default(String string, BrowserFrame browserFrame, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return BrowserClassFileIOKt.readClassFile(string, browserFrame, bl);
    }

    public static final boolean writeClassFile(@NotNull ClassFile classFile, @NotNull String fileName, @Nullable Window parentWindow, @Nullable VmConnection vmConnection, @NotNull Function0<? extends File> directoryChooser) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(directoryChooser, (String)"directoryChooser");
        if (StringsKt.startsWith$default((String)fileName, (String)"jrt:", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{fileName};
            return AlertFacade.DefaultImpls.showYesNoDialog$default(AlertFacadeKt.getAlertFacade(), parentWindow, BrowserBundle.INSTANCE.getString("message.jrt.read.only.title", new Object[0]), BrowserBundle.INSTANCE.getString("message.jrt.read.only", objectArray), false, 8, null).getSelectedIndex() == 0 ? BrowserClassFileIOKt.writeClassFileToDirectory(directoryChooser, classFile, parentWindow) : false;
        }
        switch (BrowserClassFileIOKt.getSavingConfirmationIndex(parentWindow)) {
            case 0: {
                bl = BrowserClassFileIOKt.writeClassFileUnguarded(classFile, fileName, parentWindow, vmConnection, directoryChooser);
                break;
            }
            case 1: {
                bl = BrowserClassFileIOKt.writeClassFileToDirectory(directoryChooser, classFile, parentWindow);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getSavingConfirmationIndex(Window parentWindow) {
        int n;
        if (persistentSavingConfirmationIndex == -1) {
            void var2_2;
            String[] stringArray = new String[]{BrowserBundle.INSTANCE.getString("button.overwrite", new Object[0]), BrowserBundle.INSTANCE.getString("button.choose.directory", new Object[0]), BrowserBundle.INSTANCE.getString("button.cancel", new Object[0])};
            OptionAlertResult optionAlertResult = AlertFacadeKt.getAlertFacade().showOptionDialog(parentWindow, BrowserBundle.INSTANCE.getString("message.save.confirmation.title", new Object[0]), BrowserBundle.INSTANCE.getString("message.save.confirmation", new Object[0]), stringArray, AlertType.QUESTION, true);
            int selectedIndex = optionAlertResult.component1();
            boolean suppressionSelected = optionAlertResult.component2();
            if (suppressionSelected) {
                Object[] objectArray = new Integer[]{1, 2};
                if (CollectionsKt.listOf((Object[])objectArray).contains(selectedIndex)) {
                    persistentSavingConfirmationIndex = selectedIndex;
                }
            }
            n = var2_2;
        } else {
            n = persistentSavingConfirmationIndex;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean writeClassFileUnguarded(ClassFile classFile, String fileName, Window parentWindow, VmConnection vmConnection, Function0<? extends File> directoryChooser) {
        boolean bl;
        if (vmConnection != null) {
            ReplacementResult result = vmConnection.getCommunicator().replaceClassFile(fileName, ClassFileWriter.writeToByteArray((ClassFile)classFile));
            if (!result.isSuccess()) {
                Object[] objectArray = new Object[]{result.getErrorMessage()};
                AlertFacade.DefaultImpls.showMessage$default(AlertFacadeKt.getAlertFacade(), parentWindow, BrowserBundle.INSTANCE.getString("message.could.not.redefine.class.file", new Object[0]), BrowserBundle.INSTANCE.getString("error.message.was.0", objectArray), AlertType.ERROR, false, 16, null);
            }
            bl = result.isSuccess();
        } else if (StringsKt.startsWith$default((String)fileName, (String)JAR_PREFIX, (boolean)false, (int)2, null)) {
            bl = BrowserClassFileIOKt.writeClassFileUnguarded(classFile, StringsKt.substringAfter$default((String)fileName, (String)JAR_PREFIX, null, (int)2, null), parentWindow, null, directoryChooser);
        } else if (StringsKt.contains$default((CharSequence)fileName, (char)'!', (boolean)false, (int)2, null)) {
            Pair<String, String> pair = "jclasslib";
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path = Files.createTempFile((String)pair, null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempFile(...)");
            Path tempOutputFile = path;
            try {
                ClassFileWriter.writeToFile((Path)tempOutputFile, (ClassFile)classFile);
                pair = BrowserClassFileIOKt.splitJarFileName(fileName);
                String jarFileName = (String)pair.component1();
                String classFileName = (String)pair.component2();
                Path path2 = Paths.get(jarFileName, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                Closeable closeable = FileSystems.newFileSystem(path2, null);
                Throwable throwable = null;
                try {
                    FileSystem fs = (FileSystem)closeable;
                    boolean bl2 = false;
                    Path path3 = tempOutputFile;
                    Path path4 = fs.getPath(classFileName, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getPath(...)");
                    Path path5 = path4;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    Path path6 = Files.copy(path3, path5, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"copy(...)");
                    Path path7 = path6;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            finally {
                Files.deleteIfExists(tempOutputFile);
            }
            bl = true;
        } else {
            ClassFileWriter.writeToFile((File)new File(fileName), (ClassFile)classFile);
            bl = true;
        }
        return bl;
    }

    private static final boolean writeClassFileToDirectory(Function0<? extends File> directoryChooser, ClassFile classFile, Window parentWindow) {
        boolean bl;
        File directory = (File)directoryChooser.invoke();
        if (directory != null) {
            String alternativePath = new File(directory, classFile.getSimpleClassName() + ".class").getPath();
            Intrinsics.checkNotNull((Object)alternativePath);
            bl = BrowserClassFileIOKt.writeClassFileUnguarded(classFile, alternativePath, parentWindow, null, directoryChooser);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final Pair<String, String> splitJarFileName(String fileName) {
        String[] stringArray = new String[]{"!"};
        return (Pair)CollectionsKt.first((List)CollectionsKt.zipWithNext((Iterable)StringsKt.split$default((CharSequence)fileName, (String[])stringArray, (boolean)false, (int)2, (int)2, null)));
    }
}

