/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.eclipse.Eclipse3xMetalUtils;
import com.jidesoft.plaf.eclipse.Eclipse3xWindowsUtils;
import com.jidesoft.plaf.eclipse.EclipseMetalUtils;
import com.jidesoft.plaf.eclipse.EclipseWindowsUtils;
import com.jidesoft.plaf.office2003.Office2003WindowsUtils;
import com.jidesoft.plaf.office2007.Office2007WindowsUtils;
import com.jidesoft.plaf.vsnet.VsnetMetalUtils;
import com.jidesoft.plaf.vsnet.VsnetWindowsUtils;
import com.jidesoft.plaf.xerto.XertoMetalUtils;
import com.jidesoft.plaf.xerto.XertoPainter;
import com.jidesoft.plaf.xerto.XertoWindowsUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LookAndFeelFactory
implements ProductNames {
    public static final String WINDOWS_CLASSIC_LNF = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
    public static final String WINDOWS_LNF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String METAL_LNF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String SYNTH_LNF = "javax.swing.plaf.synth.SynthLookAndFeel";
    public static final String AQUA_LNF = "apple.laf.AquaLookAndFeel";
    public static final String AQUA_LNF_6 = "com.apple.laf.AquaLookAndFeel";
    public static final String QUAQUA_LNF = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
    public static final String ALLOY_LNF = "com.incors.plaf.alloy.AlloyLookAndFeel";
    public static final String SYNTHETICA_LNF = "de.javasoft.plaf.synthetica.SyntheticaLookAndFeel";
    public static final String SYNTHETICA_LNF_PREFIX = "de.javasoft.plaf.synthetica.Synthetica";
    public static final String PLASTIC3D_LNF = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    @Deprecated
    public static final String PLASTIC3D_LNF_1_3 = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_LNF = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    public static final String TONIC_LNF = "com.digitprop.tonic.TonicLookAndFeel";
    public static final String FLAT_LNF = "com.formdev.flatlaf.FlatLaf";
    public static final String A03_LNF = "a03.swing.plaf.A03LookAndFeel";
    public static final String DARCULA_LNF = "com.bulenkov.darcula.DarculaLaf";
    public static final String PGS_LNF = "com.pagosoft.plaf.PgsLookAndFeel";
    public static final String GTK_LNF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String MOTIF_LNF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String BIZ_LNF = "de.centigrade.bizlaf.BizLookAndFeel";
    public static final String NIMBUS_LNF_NAME = "NimbusLookAndFeel";
    public static final int VSNET_STYLE_WITHOUT_MENU = 0;
    public static final int VSNET_STYLE = 1;
    public static final int ECLIPSE_STYLE = 2;
    public static final int OFFICE2003_STYLE = 3;
    public static final int XERTO_STYLE = 4;
    public static final int XERTO_STYLE_WITHOUT_MENU = 6;
    public static final int ECLIPSE3X_STYLE = 5;
    public static final int OFFICE2007_STYLE = 7;
    public static final int EXTENSION_STYLE_VSNET_WITHOUT_MENU = 0;
    public static final int EXTENSION_STYLE_VSNET = 1;
    public static final int EXTENSION_STYLE_ECLIPSE = 2;
    public static final int EXTENSION_STYLE_OFFICE2003 = 3;
    public static final int EXTENSION_STYLE_XERTO = 4;
    public static final int EXTENSION_STYLE_ECLIPSE3X = 5;
    public static final int EXTENSION_STYLE_XERTO_WITHOUT_MENU = 6;
    public static final int EXTENSION_STYLE_OFFICE2007 = 7;
    @Deprecated
    public static final int EXTENSION_STYLE_OFFICE2003_WITHOUT_MENU = 8;
    @Deprecated
    public static final int EXTENSION_STYLE_OFFICE2007_WITHOUT_MENU = 9;
    public static final int EXTENSION_STYLE_ECLIPSE_WITHOUT_MENU = 10;
    public static final int EXTENSION_STYLE_ECLIPSE3X_WITHOUT_MENU = 11;
    private static int _style = -1;
    private static int _defaultStyle = -1;
    private static LookAndFeel _lookAndFeel;
    private static PropertyChangeListener _listener;
    public static final String JIDE_EXTENSION_INSTALLED = "jidesoft.extensionInstalled";
    public static final String JIDE_STYLE_INSTALLED = "jidesoft.extensionStyle";
    private static List<UIDefaultsCustomizer> _uiDefaultsCustomizers;
    private static List<UIDefaultsInitializer> _uiDefaultsInitializers;
    private static Map<String, String> _installedLookAndFeels;
    private static boolean _loadLookAndFeelClass;
    public static final String LAF_INSTALLED = "installed";
    public static final String LAF_NOT_INSTALLED = "not installed";
    private static Map<String, String> _defaultInitializers;
    private static Map<String, String> _defaultCustomizers;
    private static int _productsUsed;

    protected LookAndFeelFactory() {
    }

    public static int getDefaultStyle() {
        if (_defaultStyle == -1) {
            String string = SecurityUtils.getProperty("jide.defaultStyle", "-1");
            try {
                _defaultStyle = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (_defaultStyle == -1) {
                int n2;
                try {
                    n2 = SystemInfo.isWindowsVistaAbove() && LookAndFeelFactory.isWindowsLookAndFeel(UIManager.getLookAndFeel()) && SystemInfo.isJdk6Above() ? 7 : (XPUtils.isXPStyleOn() && LookAndFeelFactory.isWindowsLookAndFeel(UIManager.getLookAndFeel()) ? 3 : ((LookAndFeelFactory.getProductsUsed() & 0x10) == 0 ? 0 : 1));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    n2 = (LookAndFeelFactory.getProductsUsed() & 0x10) == 0 ? 0 : 1;
                }
                return n2;
            }
        }
        return _defaultStyle;
    }

    public static void setDefaultStyle(int n2) {
        _defaultStyle = n2;
    }

    public static void installJideExtension() {
        LookAndFeelFactory.installJideExtension(_style == -1 ? LookAndFeelFactory.getDefaultStyle() : _style);
    }

    public static void installJideExtension(int n2) {
        LookAndFeelFactory.installJideExtension(UIManager.getLookAndFeelDefaults(), UIManager.getLookAndFeel(), n2);
    }

    public static boolean isJideExtensionInstalled() {
        return UIDefaultsLookup.getBoolean(JIDE_EXTENSION_INSTALLED);
    }

    public static void installJideExtension(UIDefaults uIDefaults, LookAndFeel lookAndFeel, int n2) {
        Object object;
        if (LookAndFeelFactory.isJideExtensionInstalled() && _style == n2 && _lookAndFeel == lookAndFeel) {
            return;
        }
        LookAndFeelFactory.workAroundSwingIssues();
        if (_listener == null) {
            _listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                        _style = -1;
                    }
                }
            };
        }
        UIManager.removePropertyChangeListener(_listener);
        UIManager.addPropertyChangeListener(_listener);
        _style = n2;
        uIDefaults.put(JIDE_STYLE_INSTALLED, (Object)_style);
        _lookAndFeel = lookAndFeel;
        UIDefaultsInitializer[] uIDefaultsInitializerArray = LookAndFeelFactory.getUIDefaultsInitializers();
        for (UIDefaultsInitializer uIDefaultsInitializer : uIDefaultsInitializerArray) {
            if (uIDefaultsInitializer == null) continue;
            uIDefaultsInitializer.initialize(uIDefaults);
        }
        LookAndFeelFactory.initialize(lookAndFeel.getClass().getName(), uIDefaults);
        if (lookAndFeel.getClass().getName().equals(ALLOY_LNF) && LookAndFeelFactory.isAlloyLnfInstalled() || lookAndFeel.getClass().getName().equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel") && LookAndFeelFactory.isPlastic3DLnfInstalled() || lookAndFeel.getClass().getName().equals(PLASTICXP_LNF) && LookAndFeelFactory.isPlasticXPLnfInstalled() || lookAndFeel.getClass().getName().equals(PGS_LNF) && LookAndFeelFactory.isPgsLnfInstalled() || lookAndFeel.getClass().getName().contains("Flat") && LookAndFeelFactory.isFlatLnfInstalled() || lookAndFeel.getClass().getName().equals(TONIC_LNF) && LookAndFeelFactory.isTonicLnfInstalled()) {
            switch (n2) {
                case 7: 
                case 9: {
                    VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2007WindowsUtils.initClassDefaults(uIDefaults, false);
                    break;
                }
                case 3: 
                case 8: {
                    VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2003WindowsUtils.initClassDefaults(uIDefaults, false);
                    break;
                }
                case 0: 
                case 1: {
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    uIDefaults.put("JideTabbedPane.defaultTabShape", (Object)4);
                    uIDefaults.put("JideTabbedPane.selectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uIDefaults.put("JideTabbedPane.unselectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uIDefaults.put("JideTabbedPane.foreground", UIDefaultsLookup.getColor("controlText"));
                    uIDefaults.put("JideTabbedPane.light", UIDefaultsLookup.getColor("control"));
                    int n3 = LookAndFeelFactory.getProductsUsed();
                    if ((n3 & 1) == 0) break;
                    ImageIcon imageIcon = IconsFactory.getImageIcon(VsnetWindowsUtils.class, "icons/title_buttons_windows.gif");
                    uIDefaults.put("DockableFrameUI", "com.jidesoft.plaf.vsnet.VsnetDockableFrameUI");
                    uIDefaults.put("DockableFrameTitlePane.hideIcon", IconsFactory.getIcon(null, imageIcon, 0, 0, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.unfloatIcon", IconsFactory.getIcon(null, imageIcon, 0, 10, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.floatIcon", IconsFactory.getIcon(null, imageIcon, 0, 20, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.autohideIcon", IconsFactory.getIcon(null, imageIcon, 0, 30, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.stopAutohideIcon", IconsFactory.getIcon(null, imageIcon, 0, 40, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.hideAutohideIcon", IconsFactory.getIcon(null, imageIcon, 0, 50, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.maximizeIcon", IconsFactory.getIcon(null, imageIcon, 0, 60, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.restoreIcon", IconsFactory.getIcon(null, imageIcon, 0, 70, 10, 10));
                    uIDefaults.put("DockableFrameTitlePane.buttonGap", (Object)4);
                    uIDefaults.put("DockableFrame.titleBorder", new BorderUIResource(BorderFactory.createEmptyBorder(1, 0, 2, 0)));
                    uIDefaults.put("DockableFrame.border", new BorderUIResource(BorderFactory.createEmptyBorder(2, 0, 0, 0)));
                    break;
                }
                case 2: 
                case 10: {
                    EclipseMetalUtils.initComponentDefaults(uIDefaults);
                    EclipseMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 5: 
                case 11: {
                    Eclipse3xMetalUtils.initComponentDefaults(uIDefaults);
                    Eclipse3xMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uIDefaults);
                    XertoMetalUtils.initClassDefaults(uIDefaults);
                }
            }
            if (n2 == 4 || n2 == 6) {
                UIDefaultsLookup.put(uIDefaults, "Theme.painter", XertoPainter.getInstance());
            } else {
                UIDefaultsLookup.put(uIDefaults, "Theme.painter", BasicPainter.getInstance());
            }
        } else if (lookAndFeel.getClass().getName().equals(MetalLookAndFeel.class.getName())) {
            switch (n2) {
                case 1: 
                case 3: 
                case 7: {
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaultsWithMenu(uIDefaults);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initComponentDefaults(uIDefaults);
                    EclipseMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xMetalUtils.initComponentDefaults(uIDefaults);
                    Eclipse3xMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 0: 
                case 8: 
                case 9: {
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uIDefaults);
                    XertoMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
            }
        } else if (lookAndFeel instanceof MetalLookAndFeel) {
            switch (n2) {
                case 0: 
                case 1: 
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 2: 
                case 10: {
                    EclipseMetalUtils.initClassDefaults(uIDefaults);
                    EclipseMetalUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 5: 
                case 11: {
                    Eclipse3xMetalUtils.initClassDefaults(uIDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uIDefaults);
                    XertoMetalUtils.initClassDefaults(uIDefaults);
                }
            }
        } else if (LookAndFeelFactory.isWindowsLookAndFeel(lookAndFeel)) {
            switch (n2) {
                case 7: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2007WindowsUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 9: {
                    VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                    VsnetWindowsUtils.initClassDefaults(uIDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uIDefaults);
                    Office2007WindowsUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 3: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                    Office2003WindowsUtils.initClassDefaults(uIDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 8: {
                    VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                    VsnetWindowsUtils.initClassDefaults(uIDefaults);
                    Office2003WindowsUtils.initClassDefaults(uIDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 2: {
                    EclipseWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                    EclipseWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                    break;
                }
                case 10: {
                    EclipseWindowsUtils.initClassDefaults(uIDefaults);
                    EclipseWindowsUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                    Eclipse3xWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                    break;
                }
                case 11: {
                    Eclipse3xWindowsUtils.initClassDefaults(uIDefaults);
                    Eclipse3xWindowsUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 1: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                    break;
                }
                case 0: {
                    VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                    VsnetWindowsUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 4: {
                    XertoWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                    XertoWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                    break;
                }
                case 6: {
                    XertoWindowsUtils.initComponentDefaults(uIDefaults);
                    XertoWindowsUtils.initClassDefaults(uIDefaults);
                }
            }
        } else if (LookAndFeelFactory.isAquaLnfInstalled() && (LookAndFeelFactory.isLnfInUse(AQUA_LNF_6) || LookAndFeelFactory.isLnfInUse(AQUA_LNF)) || LookAndFeelFactory.isQuaquaLnfInstalled() && LookAndFeelFactory.isLnfInUse(QUAQUA_LNF)) {
            try {
                object = LookAndFeelFactory.getUIManagerClassLoader().loadClass("com.jidesoft.plaf.aqua.AquaJideUtils");
                ((Class)object).getMethod("initComponentDefaults", UIDefaults.class).invoke(null, uIDefaults);
                ((Class)object).getMethod("initClassDefaults", UIDefaults.class).invoke(null, uIDefaults);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                JideSwingUtilities.throwInvocationTargetException(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException(noSuchMethodException);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException(securityException);
            }
        } else {
            switch (n2) {
                case 7: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                        Office2007WindowsUtils.initComponentDefaults(uIDefaults);
                        Office2007WindowsUtils.initClassDefaults(uIDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 9: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                        Office2007WindowsUtils.initComponentDefaults(uIDefaults);
                        Office2007WindowsUtils.initClassDefaults(uIDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 3: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                        Office2003WindowsUtils.initClassDefaults(uIDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 8: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uIDefaults);
                        Office2003WindowsUtils.initClassDefaults(uIDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 2: {
                    if (SystemInfo.isWindows()) {
                        EclipseWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                        EclipseWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                        break;
                    }
                    EclipseMetalUtils.initClassDefaults(uIDefaults);
                    EclipseMetalUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 10: {
                    if (SystemInfo.isWindows()) {
                        EclipseWindowsUtils.initClassDefaults(uIDefaults);
                        EclipseWindowsUtils.initComponentDefaults(uIDefaults);
                        break;
                    }
                    EclipseMetalUtils.initClassDefaults(uIDefaults);
                    EclipseMetalUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 5: {
                    if (SystemInfo.isWindows()) {
                        Eclipse3xWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                        Eclipse3xWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                        break;
                    }
                    Eclipse3xMetalUtils.initClassDefaults(uIDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 11: {
                    if (SystemInfo.isWindows()) {
                        Eclipse3xWindowsUtils.initClassDefaults(uIDefaults);
                        Eclipse3xWindowsUtils.initComponentDefaults(uIDefaults);
                        break;
                    }
                    Eclipse3xMetalUtils.initClassDefaults(uIDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uIDefaults);
                    break;
                }
                case 1: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 0: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaults(uIDefaults);
                        VsnetWindowsUtils.initComponentDefaults(uIDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uIDefaults);
                    VsnetMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 4: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaultsWithMenu(uIDefaults);
                        XertoWindowsUtils.initComponentDefaultsWithMenu(uIDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uIDefaults);
                    XertoMetalUtils.initClassDefaults(uIDefaults);
                    break;
                }
                case 6: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaults(uIDefaults);
                        XertoWindowsUtils.initComponentDefaults(uIDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uIDefaults);
                    XertoMetalUtils.initClassDefaults(uIDefaults);
                }
            }
        }
        uIDefaults.put(JIDE_EXTENSION_INSTALLED, Boolean.TRUE);
        LookAndFeelFactory.customize(lookAndFeel.getClass().getName(), uIDefaults);
        object = LookAndFeelFactory.getUIDefaultsCustomizers();
        for (Object object2 : object) {
            if (object2 == null) continue;
            object2.customize(uIDefaults);
        }
    }

    private static void workAroundSwingIssues() {
        Object object = UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft");
        if (object instanceof Object[]) {
            Object[] objectArray;
            for (Object object2 : objectArray = (Object[])object) {
                if (!"DOWN".equals(object2)) continue;
                return;
            }
            Object[] objectArray2 = new Object[objectArray.length + 14];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            int n2 = objectArray.length;
            objectArray2[n2++] = "DOWN";
            objectArray2[n2++] = "selectNext";
            objectArray2[n2++] = "UP";
            objectArray2[n2++] = "selectPrevious";
            objectArray2[n2++] = "KP_DOWN";
            objectArray2[n2++] = "selectNext";
            objectArray2[n2++] = "KP_UP";
            objectArray2[n2++] = "selectPrevious";
            objectArray2[n2++] = "ENTER";
            objectArray2[n2++] = "return";
            objectArray2[n2++] = "SPACE";
            objectArray2[n2++] = "return";
            objectArray2[n2++] = "ESCAPE";
            objectArray2[n2] = "cancel";
            UIManager.put("PopupMenu.selectedWindowInputMapBindings.RightToLeft", objectArray2);
        }
    }

    public static void registerDefaultInitializer(String string, String string2) {
        if (_defaultInitializers == null) {
            _defaultInitializers = new HashMap<String, String>();
        }
        _defaultInitializers.put(string, string2);
    }

    public static void unregisterDefaultInitializer(String string) {
        if (_defaultInitializers != null) {
            _defaultInitializers.remove(string);
        }
    }

    public static void clearDefaultInitializers() {
        if (_defaultInitializers != null) {
            _defaultInitializers.clear();
        }
    }

    public static void registerDefaultCustomizer(String string, String string2) {
        if (_defaultCustomizers == null) {
            _defaultCustomizers = new HashMap<String, String>();
        }
        _defaultCustomizers.put(string, string2);
    }

    public static void unregisterDefaultCustomizer(String string) {
        if (_defaultCustomizers != null) {
            _defaultCustomizers.remove(string);
        }
    }

    public static void clearDefaultCustomizers() {
        if (_defaultCustomizers != null) {
            _defaultCustomizers.clear();
        }
    }

    private static void initialize(String string, UIDefaults uIDefaults) {
        String string2;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector2.insertElementAt(string, 0);
        String string3 = LookAndFeelFactory.guessLookAndFeelName(string);
        if (string3 != null && string3.trim().length() > 0) {
            vector.insertElementAt(string3, 0);
        }
        try {
            Class object;
            Object object2 = Class.forName(string);
            while (object2 != null && (object = ((Class)object2).getSuperclass()) != null && LookAndFeel.class.isAssignableFrom(object)) {
                string = object.getName();
                vector2.insertElementAt(string, 0);
                string3 = LookAndFeelFactory.guessLookAndFeelName(string);
                if (string3 != null && string3.trim().length() > 0) {
                    vector.insertElementAt(string3, 0);
                }
                object2 = object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (String string4 : vector2) {
            string2 = LookAndFeelFactory.findDefaultInitializer(string4);
            if (string2 == null) continue;
            LookAndFeelFactory.invokeInitialize(uIDefaults, string2);
        }
        for (String string5 : vector) {
            string2 = LookAndFeelFactory.getDefaultInitializer(string5);
            if (string2 == null) continue;
            LookAndFeelFactory.invokeInitialize(uIDefaults, string2);
        }
    }

    private static void invokeInitialize(UIDefaults uIDefaults, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            Method method = obj.getClass().getMethod("initialize", UIDefaults.class);
            method.invoke(obj, uIDefaults);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static String getDefaultInitializer(String string) {
        return "com.jidesoft.plaf." + string.toLowerCase() + "." + string + "Initializer";
    }

    private static String findDefaultInitializer(String string) {
        String string2;
        if (_defaultInitializers != null && (string2 = _defaultInitializers.get(string)) != null) {
            return string2;
        }
        return null;
    }

    private static void customize(String string, UIDefaults uIDefaults) {
        String string2;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        vector2.insertElementAt(string, 0);
        String string3 = LookAndFeelFactory.guessLookAndFeelName(string);
        if (string3 != null && string3.trim().length() > 0) {
            vector.insertElementAt(string3, 0);
        }
        try {
            Class object;
            Object object2 = Class.forName(string);
            while (object2 != null && (object = ((Class)object2).getSuperclass()) != null && LookAndFeel.class.isAssignableFrom(object)) {
                string = object.getName();
                vector2.insertElementAt(string, 0);
                string3 = LookAndFeelFactory.guessLookAndFeelName(string);
                if (string3 != null && string3.trim().length() > 0) {
                    vector.insertElementAt(string3, 0);
                }
                object2 = object;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (String string4 : vector2) {
            string2 = LookAndFeelFactory.findDefaultCustomizer(string4);
            if (string2 == null) continue;
            LookAndFeelFactory.invokeCustomize(uIDefaults, string2);
        }
        for (String string5 : vector) {
            string2 = LookAndFeelFactory.getDefaultCustomizer(string5);
            if (string2 == null) continue;
            LookAndFeelFactory.invokeCustomize(uIDefaults, string2);
        }
    }

    private static void invokeCustomize(UIDefaults uIDefaults, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            Method method = obj.getClass().getMethod("customize", UIDefaults.class);
            method.invoke(obj, uIDefaults);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static String getDefaultCustomizer(String string) {
        return "com.jidesoft.plaf." + string.toLowerCase() + "." + string + "Customizer";
    }

    private static String findDefaultCustomizer(String string) {
        String string2;
        if (_defaultCustomizers != null && (string2 = _defaultCustomizers.get(string)) != null) {
            return string2;
        }
        return null;
    }

    private static String guessLookAndFeelName(String string) {
        int n2 = string.lastIndexOf(".") + 1;
        if (string.endsWith("LookAndFeel")) {
            return string.substring(n2, string.length() - "LookAndFeel".length());
        }
        if (string.endsWith("Laf")) {
            return string.substring(n2, string.length() - "Laf".length());
        }
        if (string.endsWith("Lnf")) {
            return string.substring(n2, string.length() - "Lnf".length());
        }
        return null;
    }

    public static boolean isLnfInstalled(String string) {
        String string2 = _installedLookAndFeels.get(string);
        if (string2 != null) {
            return LAF_INSTALLED.equals(string2);
        }
        return LookAndFeelFactory.isLoadLookAndFeelClass() && LookAndFeelFactory.loadLnfClass(string) != null;
    }

    public static ClassLoader getUIManagerClassLoader() {
        Object object = UIManager.get("ClassLoader");
        if (object instanceof ClassLoader) {
            return (ClassLoader)object;
        }
        ClassLoader classLoader = LookAndFeelFactory.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static boolean isLnfInUse(String string) {
        return (!_installedLookAndFeels.containsKey(string) || _installedLookAndFeels.get(string) != null && !_installedLookAndFeels.get(string).equals(LAF_NOT_INSTALLED)) && LookAndFeelFactory.isAssignableFrom(string, UIManager.getLookAndFeel().getClass());
    }

    public static void setLnfInstalled(String string, boolean bl2) {
        _installedLookAndFeels.put(string, bl2 ? LAF_INSTALLED : LAF_NOT_INSTALLED);
    }

    private static Class loadLnfClass(String string) {
        try {
            Class<?> clazz = LookAndFeelFactory.getUIManagerClassLoader().loadClass(string);
            HashMap<String, String> hashMap = new HashMap<String, String>(_installedLookAndFeels);
            hashMap.put(string, LAF_INSTALLED);
            _installedLookAndFeels = hashMap;
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            HashMap<String, String> hashMap = new HashMap<String, String>(_installedLookAndFeels);
            hashMap.put(string, LAF_NOT_INSTALLED);
            _installedLookAndFeels = hashMap;
            return null;
        }
    }

    private static boolean isAssignableFrom(String string, Class clazz) {
        if (string.equals(clazz.getName())) {
            return true;
        }
        Class clazz2 = LookAndFeelFactory.loadLnfClass(string);
        return clazz2 != null && clazz2.isAssignableFrom(clazz);
    }

    public static boolean isAquaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(AQUA_LNF_6) || LookAndFeelFactory.isLnfInstalled(AQUA_LNF);
    }

    public static boolean isQuaquaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(QUAQUA_LNF);
    }

    public static boolean isAlloyLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(ALLOY_LNF);
    }

    public static boolean isBizlafLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(BIZ_LNF);
    }

    public static boolean isGTKLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(GTK_LNF);
    }

    public static boolean isPlastic3DLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }

    @Deprecated
    public static boolean isPlastic3D13LnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }

    public static boolean isPlasticXPLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PLASTICXP_LNF);
    }

    public static boolean isTonicLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(TONIC_LNF);
    }

    public static boolean isFlatLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(FLAT_LNF);
    }

    public static boolean isA03LnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(A03_LNF);
    }

    public static boolean isDarculaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(DARCULA_LNF);
    }

    public static boolean isPgsLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PGS_LNF);
    }

    public static boolean isSyntheticaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF);
    }

    public static boolean isNimbusLnfInstalled() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
            if (lookAndFeelInfo.getClassName().indexOf(NIMBUS_LNF_NAME) == -1) continue;
            return true;
        }
        return false;
    }

    public static void installDefaultLookAndFeelAndExtension() {
        LookAndFeelFactory.installDefaultLookAndFeel();
        LookAndFeelFactory.installJideExtension();
    }

    public static void installDefaultLookAndFeel() {
        try {
            String string = SecurityUtils.getProperty("swing.defaultlaf", null);
            if (string == null) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static LookAndFeel getLookAndFeel() {
        return _lookAndFeel;
    }

    public static int getStyle() {
        return _style;
    }

    public static UIDefaultsCustomizer[] getUIDefaultsCustomizers() {
        return _uiDefaultsCustomizers.toArray(new UIDefaultsCustomizer[_uiDefaultsCustomizers.size()]);
    }

    public static void addUIDefaultsCustomizer(UIDefaultsCustomizer uIDefaultsCustomizer) {
        if (!_uiDefaultsCustomizers.contains(uIDefaultsCustomizer)) {
            _uiDefaultsCustomizers.add(uIDefaultsCustomizer);
        }
    }

    public static void removeUIDefaultsCustomizer(UIDefaultsCustomizer uIDefaultsCustomizer) {
        _uiDefaultsCustomizers.remove(uIDefaultsCustomizer);
    }

    public static UIDefaultsInitializer[] getUIDefaultsInitializers() {
        return _uiDefaultsInitializers.toArray(new UIDefaultsInitializer[_uiDefaultsInitializers.size()]);
    }

    public static void addUIDefaultsInitializer(UIDefaultsInitializer uIDefaultsInitializer) {
        if (!_uiDefaultsInitializers.contains(uIDefaultsInitializer)) {
            _uiDefaultsInitializers.add(uIDefaultsInitializer);
        }
    }

    public static void removeUIDefaultsInitializer(UIDefaultsInitializer uIDefaultsInitializer) {
        _uiDefaultsInitializers.remove(uIDefaultsInitializer);
    }

    public static void verifyDefaults(UIDefaults uIDefaults, Object[] objectArray) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = objectArray[i2 + 1];
            if (object == null) {
                System.out.println("The value for " + objectArray[i2] + " is null");
                continue;
            }
            Object object2 = uIDefaults.get(objectArray[i2]);
            if (object2 == null) continue;
            System.out.println("The value for " + objectArray[i2] + " exists which is " + object2);
        }
    }

    public static void putDefaults(UIDefaults uIDefaults, Object[] objectArray) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = objectArray[i2 + 1];
            if (object == null) {
                uIDefaults.remove(objectArray[i2]);
                continue;
            }
            if (uIDefaults.get(objectArray[i2]) != null) continue;
            uIDefaults.put(objectArray[i2], object);
        }
    }

    public static void overwriteDefaults(UIDefaults uIDefaults, Object[] objectArray) {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; i2 += 2) {
            Object object = objectArray[i2 + 1];
            if (object == null) {
                uIDefaults.remove(objectArray[i2]);
                continue;
            }
            uIDefaults.put(objectArray[i2], object);
        }
    }

    public static int getProductsUsed() {
        if (_productsUsed == -1) {
            _productsUsed = 0;
            try {
                Class.forName("com.jidesoft.docking.Product");
                _productsUsed |= 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.action.Product");
                _productsUsed |= 0x10;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.document.Product");
                _productsUsed |= 2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.grid.Product");
                _productsUsed |= 4;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.wizard.Product");
                _productsUsed |= 8;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.pivot.Product");
                _productsUsed |= 0x20;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.shortcut.Product");
                _productsUsed |= 0x40;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.editor.Product");
                _productsUsed |= 0x80;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.rss.Product");
                _productsUsed |= 0x100;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.treemap.Product");
                _productsUsed |= 0x8000;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.chart.Product");
                _productsUsed |= 0x1000;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.diff.Product");
                _productsUsed |= 0x4000;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return _productsUsed;
    }

    public static boolean isWindowsLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(WINDOWS_LNF);
            return clazz.isInstance(lookAndFeel);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public static boolean isWindowsClassicLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel == null) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName(WINDOWS_CLASSIC_LNF);
            return clazz.isInstance(lookAndFeel);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    public static void setProductsUsed(int n2) {
        _productsUsed = n2;
    }

    public static boolean isCurrentLnfDecorated() {
        return !LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF) || !LookAndFeelFactory.isLnfInUse(SYNTHETICA_LNF);
    }

    public static boolean isLoadLookAndFeelClass() {
        return _loadLookAndFeelClass;
    }

    public static void setLoadLookAndFeelClass(boolean bl2) {
        _loadLookAndFeelClass = bl2;
    }

    public static boolean isMnemonicHidden() {
        return !UIManager.getBoolean("Button.showMnemonics");
    }

    public static void main(String[] stringArray) {
    }

    static {
        _uiDefaultsCustomizers = new Vector<UIDefaultsCustomizer>();
        _uiDefaultsInitializers = new Vector<UIDefaultsInitializer>();
        _installedLookAndFeels = new HashMap<String, String>();
        _loadLookAndFeelClass = true;
        _productsUsed = -1;
    }

    public static interface UIDefaultsInitializer {
        public void initialize(UIDefaults var1);
    }

    public static interface UIDefaultsCustomizer {
        public void customize(UIDefaults var1);
    }
}

