/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.laf.IndeterminateStateComponent;
import com.install4j.api.laf.LookAndFeelHandler;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class ExternalFlatLafLookAndFeelHandler
implements LookAndFeelHandler {
    private float userScaleFactor = 0.0f;

    @Override
    public void applyLookAndFeel(boolean darkDesktop) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDark() {
        return UIManager.getBoolean("laf.dark");
    }

    @Override
    @NotNull
    public JCheckBox createTriStateCheckBox() {
        return new FlatLafTriStateCheckBox();
    }

    @Override
    public boolean isWideTreeSelection() {
        return UIManager.getBoolean("Tree.wideSelection");
    }

    @Override
    public void disableExtraSelectionPainting(JTree tree) {
        tree.putClientProperty("JTree.paintSelection", false);
    }

    @Override
    public float getCustomScaleFactor() {
        if (this.userScaleFactor == 0.0f) {
            try {
                this.userScaleFactor = ((Float)Class.forName("com.formdev.flatlaf.util.UIScale").getDeclaredMethod("getUserScaleFactor", new Class[0]).invoke(null, new Object[0])).floatValue();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.userScaleFactor = 1.0f;
            }
        }
        return this.userScaleFactor;
    }

    private static class FlatLafTriStateCheckBox
    extends JCheckBox
    implements IndeterminateStateComponent {
        private FlatLafTriStateCheckBox() {
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
            this.putClientProperty("JButton.selectedState", indeterminate ? "indeterminate" : null);
        }

        @Override
        public void setSelected(boolean selected) {
            this.setIndeterminate(false);
            super.setSelected(selected);
        }
    }
}

