/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.helper.fileinst.ExtendedFileOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FileOptionsConfig
extends AbstractConfig {
    private Map<String, ExtendedFileOptions> fileNameToFileOptions = new HashMap<String, ExtendedFileOptions>();
    private List<String> launchers = new ArrayList<String>();

    @Override
    protected void read(Element element) {
        for (Element childElement : FileOptionsConfig.childElements(element)) {
            String fileName = FileOptionsConfig.readAttribute(childElement, "name", "").replace('\\', '/');
            String mode = AbstractConfig.readAttribute(childElement, "mode", "644");
            int overwrite = FileOptionsConfig.readAttribute(childElement, "overwrite", 4);
            boolean shared = FileOptionsConfig.readAttribute(childElement, "shared", false);
            ExtendedFileOptions fileOptions = new ExtendedFileOptions(mode, OverwriteMode.getFromIntValue(overwrite), shared);
            UninstallMode uninstallMode = UninstallMode.getFromIntValue(FileOptionsConfig.readAttribute(childElement, "uninstallMode", 0));
            fileOptions.setUninstallMode(uninstallMode);
            for (Element attributeElement : FileOptionsConfig.childElements(childElement)) {
                fileOptions.addExtendedAttribute(FileOptionsConfig.readAttribute(attributeElement, "name", ""), FileOptionsConfig.readAttribute(attributeElement, "value", ""));
            }
            this.fileNameToFileOptions.put(fileName, fileOptions);
            if (!FileOptionsConfig.readAttribute(childElement, "isLauncher", false)) continue;
            this.launchers.add(fileName);
        }
    }

    public List<String> getLaunchers() {
        return this.launchers;
    }

    public FileOptions getOptions(String fileName) {
        fileName = fileName.replace('\\', '/');
        while (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return this.fileNameToFileOptions.get(fileName);
    }
}

