/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.immutable.collections;

import io.matthewnelson.immutable.collections.ImmutableList;
import io.matthewnelson.immutable.collections.ImmutableMap;
import io.matthewnelson.immutable.collections.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u001a#\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u0004\u001a/\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0007\"\u0002H\u0002H\u0007\u00a2\u0006\u0004\b\u0004\u0010\b\u001a5\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f*\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\nH\u0007\u00a2\u0006\u0002\b\r\u001aS\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2*\u0010\u000f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u00100\u0007\"\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u0010H\u0007\u00a2\u0006\u0004\b\r\u0010\u0011\u001a#\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0013\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u0014\u001a/\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0013\"\u0004\b\u0000\u0010\u00022\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00020\u0007\"\u0002H\u0002H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0016\u00a8\u0006\u0017"}, d2={"toImmutableList", "", "T", "", "listOf", "immutableListOf", "elements", "", "([Ljava/lang/Object;)Ljava/util/List;", "toImmutableMap", "", "K", "V", "mapOf", "immutableMapOf", "pairs", "Lkotlin/Pair;", "([Lkotlin/Pair;)Ljava/util/Map;", "toImmutableSet", "", "setOf", "immutableSetOf", "([Ljava/lang/Object;)Ljava/util/Set;", "io.matthewnelson.immutable_collections_jvm"})
@JvmName(name="Immutable")
public final class Immutable {
    @JvmName(name="listOf")
    @NotNull
    public static final <T> List<T> listOf(@NotNull Collection<? extends T> $this$toImmutableList) {
        Intrinsics.checkNotNullParameter($this$toImmutableList, (String)"<this>");
        if ($this$toImmutableList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        if ($this$toImmutableList instanceof ImmutableList) {
            return (List)$this$toImmutableList;
        }
        return new ImmutableList(CollectionsKt.toList((Iterable)$this$toImmutableList));
    }

    @JvmName(name="listOf")
    @NotNull
    public static final <T> List<T> listOf(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.length == 0) {
            return CollectionsKt.emptyList();
        }
        return new ImmutableList(ArraysKt.toList((Object[])elements));
    }

    @JvmName(name="mapOf")
    @NotNull
    public static final <K, V> Map<K, V> mapOf(@NotNull Map<K, ? extends V> $this$toImmutableMap) {
        Intrinsics.checkNotNullParameter($this$toImmutableMap, (String)"<this>");
        if ($this$toImmutableMap.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if ($this$toImmutableMap instanceof ImmutableMap) {
            return $this$toImmutableMap;
        }
        return new ImmutableMap(MapsKt.toMap($this$toImmutableMap));
    }

    @JvmName(name="mapOf")
    @NotNull
    public static final <K, V> Map<K, V> mapOf(Pair<? extends K, ? extends V> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        if (pairs.length == 0) {
            return MapsKt.emptyMap();
        }
        return new ImmutableMap(MapsKt.toMap(pairs));
    }

    @JvmName(name="setOf")
    @NotNull
    public static final <T> Set<T> setOf(@NotNull Collection<? extends T> $this$toImmutableSet) {
        Intrinsics.checkNotNullParameter($this$toImmutableSet, (String)"<this>");
        if ($this$toImmutableSet.isEmpty()) {
            return SetsKt.emptySet();
        }
        if ($this$toImmutableSet instanceof ImmutableSet) {
            return (Set)$this$toImmutableSet;
        }
        return new ImmutableSet(CollectionsKt.toSet((Iterable)$this$toImmutableSet));
    }

    @JvmName(name="setOf")
    @NotNull
    public static final <T> Set<T> setOf(T ... elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.length == 0) {
            return SetsKt.emptySet();
        }
        return new ImmutableSet(ArraysKt.toSet((Object[])elements));
    }
}

