/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm.impl;

import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleAccess;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import java.io.IOException;
import java.io.Serializable;

public class HelperConsoleAccess
implements ConsoleAccess,
Serializable {
    private transient HelperCommunication helperCommunication = HelperCommunication.getInstance();

    @Override
    public void println(String text) {
        this.print(text);
        this.println();
    }

    @Override
    public void print(String text) {
        this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> ConsoleImpl.getInstance().getConsoleAccess().print(text));
    }

    @Override
    public void println() {
        this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> ConsoleImpl.getInstance().getConsoleAccess().println());
    }

    @Override
    public void flush() {
        this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> ConsoleImpl.getInstance().getConsoleAccess().flush());
    }

    @Override
    public String readLine(String prompt) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchStringChecked(ExecutionContext.UNELEVATED, context -> ConsoleImpl.getInstance().getConsoleAccess().readLine(prompt));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readPassword(String prompt) throws UserCanceledException {
        try {
            return this.helperCommunication.fetchStringChecked(ExecutionContext.UNELEVATED, context -> ConsoleImpl.getInstance().getConsoleAccess().readPassword(prompt));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void cancel() {
        this.helperCommunication.runAction(ExecutionContext.UNELEVATED, context -> ConsoleImpl.getInstance().getConsoleAccess().cancel());
    }
}

