/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.util;

import com.jprofiler.agent.util.i;
import com.jprofiler.agent.util.u;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class Evaluation {
    public static final int PRIMITIVE_VALUE = 1;
    public static final int CONTAINS = 2;
    public static final int STARTS_WITH = 3;
    public static final int ENDS_WITH = 4;
    public static final int EQUALS = 5;
    public static final int REGEXP = 6;
    public static final int EXPRESSION = 7;
    public static final int NULL_REFERENCE = 8;
    public static final int NON_NULL_REFERENCE = 9;
    public static final int INSTANCE_OF = 10;
    public static final int JPROFILER_BOOLEAN = 4;
    public static final int JPROFILER_CHAR = 5;
    public static final int JPROFILER_FLOAT = 6;
    public static final int JPROFILER_DOUBLE = 7;
    public static final int JPROFILER_BYTE = 8;
    public static final int JPROFILER_SHORT = 9;
    public static final int JPROFILER_INT = 10;
    public static final int JPROFILER_LONG = 11;
    private static boolean[] notFound = new boolean[1];
    private static Throwable lastThrowable;

    private static native boolean getBooleanField(Object var0, Class var1, boolean[] var2);

    private static native char getCharField(Object var0, Class var1, boolean[] var2);

    private static native float getFloatField(Object var0, Class var1, boolean[] var2);

    private static native double getDoubleField(Object var0, Class var1, boolean[] var2);

    private static native byte getByteField(Object var0, Class var1, boolean[] var2);

    private static native short getShortField(Object var0, Class var1, boolean[] var2);

    private static native int getIntField(Object var0, Class var1, boolean[] var2);

    private static native long getLongField(Object var0, Class var1, boolean[] var2);

    public static boolean compareString(String string, String string2, int n2, boolean bl) {
        if (string == null) {
            return false;
        }
        if (bl) {
            string2 = string2.toLowerCase();
            string = string.toLowerCase();
        }
        if (n2 == 3) {
            return string.startsWith(string2);
        }
        if (n2 == 4) {
            return string.endsWith(string2);
        }
        if (n2 == 2) {
            return string.contains(string2);
        }
        if (n2 == 5) {
            return string.equals(string2);
        }
        if (n2 == 6) {
            return string.matches(string2);
        }
        return false;
    }

    static void addScriptClass(boolean bl, String string, byte[] byArray) {
        i.a().a(bl, string, byArray);
    }

    static boolean evalBooleanExpression(Object object, Object object2) {
        try {
            return i.a().a(object);
        }
        catch (Throwable throwable) {
            lastThrowable = throwable;
            return false;
        }
    }

    static String runStringScript(Object object, boolean bl) {
        try {
            String string = i.a().b(object);
            if (string == null) {
                return null;
            }
            if (!bl || string.length() <= 1000) {
                return string;
            }
            return string.substring(0, 997) + "...";
        }
        catch (Throwable throwable) {
            lastThrowable = throwable;
            return null;
        }
    }

    static String getLastException() {
        if (lastThrowable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        lastThrowable.printStackTrace(new PrintWriter(stringWriter));
        lastThrowable = null;
        return stringWriter.toString();
    }

    static String getToString(Object object, Object object2) {
        String string;
        try {
            string = object.toString();
        }
        catch (Throwable throwable) {
            try {
                string = "[toString() threw an exception: " + throwable.toString() + "]";
            }
            catch (Throwable throwable2) {
                string = "[toString() threw an exception]";
            }
        }
        if (string == null) {
            return null;
        }
        if (string.length() <= 10000) {
            return string;
        }
        return string.substring(0, 9997) + "...";
    }

    static StringParameters getStringParameters(String string, int n2, boolean bl) {
        return new StringParameters(string, n2, bl);
    }

    static boolean evalToString(Object object, StringParameters stringParameters) {
        try {
            if (object != null) {
                return Evaluation.compareString(object.toString(), stringParameters.value, stringParameters.filterType, stringParameters.ignoreCase);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static PrimitiveParameters getPrimitiveParameters(int n2, String string, String string2, int n3) {
        return new PrimitiveParameters(n2, string, string2, n3);
    }

    static boolean evalPrimitive(Object object, PrimitiveParameters primitiveParameters) {
        try {
            if (object != null && primitiveParameters.fromValue != null) {
                u u2;
                if (primitiveParameters.filterType == 1) {
                    return Evaluation.evalPrimitiveField(object, primitiveParameters);
                }
                if (primitiveParameters.fromValue instanceof Object[] && (u2 = new u(object)).a() == primitiveParameters.type) {
                    return Evaluation.comparePrimitiveArray(u2, (Object[])primitiveParameters.fromValue, primitiveParameters.filterType);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean evalPrimitiveField(Object object, PrimitiveParameters primitiveParameters) {
        Evaluation.notFound[0] = false;
        switch (primitiveParameters.type) {
            case 4: {
                boolean bl = Evaluation.getBooleanField(object, object.getClass(), notFound);
                if (!notFound[0]) {
                    return bl == (Boolean)primitiveParameters.fromValue;
                }
                return false;
            }
            case 5: {
                char c2 = Evaluation.getCharField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return c2 >= ((Character)primitiveParameters.fromValue).charValue() && c2 <= ((Character)primitiveParameters.toValue).charValue();
                }
                return false;
            }
            case 6: {
                float f2 = Evaluation.getFloatField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return f2 >= ((Number)primitiveParameters.fromValue).floatValue() && f2 <= ((Number)primitiveParameters.toValue).floatValue();
                }
                return false;
            }
            case 7: {
                double d2 = Evaluation.getDoubleField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return d2 >= ((Number)primitiveParameters.fromValue).doubleValue() && d2 <= ((Number)primitiveParameters.toValue).doubleValue();
                }
                return false;
            }
            case 8: {
                byte by = Evaluation.getByteField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return by >= ((Number)primitiveParameters.fromValue).byteValue() && by <= ((Number)primitiveParameters.toValue).byteValue();
                }
                return false;
            }
            case 9: {
                short s2 = Evaluation.getShortField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return s2 >= ((Number)primitiveParameters.fromValue).shortValue() && s2 <= ((Number)primitiveParameters.toValue).shortValue();
                }
                return false;
            }
            case 10: {
                int n2 = Evaluation.getIntField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return n2 >= ((Number)primitiveParameters.fromValue).intValue() && n2 <= ((Number)primitiveParameters.toValue).intValue();
                }
                return false;
            }
            case 11: {
                long l2 = Evaluation.getLongField(object, object.getClass(), notFound);
                if (!notFound[0] && primitiveParameters.toValue != null) {
                    return l2 >= ((Number)primitiveParameters.fromValue).longValue() && l2 <= ((Number)primitiveParameters.toValue).longValue();
                }
                return false;
            }
        }
        return false;
    }

    public static boolean comparePrimitiveArray(List list, Object[] objectArray, int n2) {
        if (list.size() < objectArray.length) {
            return false;
        }
        if (n2 == 5 && list.size() != objectArray.length) {
            return false;
        }
        if (n2 == 2) {
            return Evaluation.indexOf(list, objectArray) > -1;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            Object var5_5 = null;
            if (n2 == 3 || n2 == 5) {
                var5_5 = list.get(i2);
            } else if (n2 == 4) {
                var5_5 = list.get(list.size() - objectArray.length + i2);
            }
            if (Evaluation.equals(object, var5_5)) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    private static int indexOf(List list, Object[] objectArray) {
        int n2 = list.size();
        int n3 = objectArray.length;
        if (n2 == 0) {
            return n3 == 0 ? n2 : -1;
        }
        if (n3 == 0) {
            return 0;
        }
        Object object = objectArray[0];
        int n4 = n2 - n3;
        for (int i2 = 0; i2 <= n4; ++i2) {
            if (!Evaluation.equals(list.get(i2), object)) {
                while (++i2 <= n4 && !Evaluation.equals(list.get(i2), object)) {
                }
            }
            if (i2 > n4) continue;
            int n5 = i2 + 1;
            int n6 = n5 + n3 - 1;
            int n7 = 1;
            while (n5 < n6 && Evaluation.equals(list.get(n5), objectArray[n7])) {
                ++n5;
                ++n7;
            }
            if (n5 != n6) continue;
            return i2;
        }
        return -1;
    }

    static class StringParameters {
        String value;
        int filterType;
        boolean ignoreCase;

        StringParameters(String string, int n2, boolean bl) {
            this.value = string;
            this.filterType = n2;
            this.ignoreCase = bl;
        }
    }

    static class PrimitiveParameters {
        int type;
        Object fromValue;
        Object toValue;
        int filterType;

        PrimitiveParameters(int n2, String string, String string2, int n3) {
            this.type = n2;
            this.filterType = n3;
            this.fromValue = this.parse(string);
            this.toValue = this.parse(string2);
        }

        private Object parse(String string) {
            try {
                if (this.filterType == 1) {
                    return this.parseSingleValue(string);
                }
                if (this.type == 5) {
                    Character[] characterArray = new Character[string.length()];
                    for (int i2 = 0; i2 < characterArray.length; ++i2) {
                        characterArray[i2] = Character.valueOf(string.charAt(i2));
                    }
                    return characterArray;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(this.parseSingleValue(stringTokenizer.nextToken()));
                }
                return arrayList.toArray(this.getArray(arrayList.size()));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        private Object[] getArray(int n2) {
            switch (this.type) {
                case 4: {
                    return new Boolean[n2];
                }
                case 5: {
                    return new Character[n2];
                }
                case 6: {
                    return new Float[n2];
                }
                case 7: {
                    return new Double[n2];
                }
                case 8: {
                    return new Byte[n2];
                }
                case 9: {
                    return new Short[n2];
                }
                case 10: {
                    return new Integer[n2];
                }
                case 11: {
                    return new Long[n2];
                }
            }
            throw new IllegalArgumentException(String.valueOf(this.type));
        }

        private Object parseSingleValue(String string) {
            switch (this.type) {
                case 4: {
                    return Boolean.valueOf(string);
                }
                case 5: {
                    return Character.valueOf(string.charAt(0));
                }
                case 6: {
                    return Float.valueOf(string);
                }
                case 7: {
                    return Double.valueOf(string);
                }
                case 8: {
                    return Byte.valueOf(string);
                }
                case 9: {
                    return Short.valueOf(string);
                }
                case 10: {
                    return Integer.valueOf(string);
                }
                case 11: {
                    return Long.valueOf(string);
                }
            }
            return null;
        }
    }
}

