/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.actions;

import com.jprofiler.agent.d.c;
import com.jprofiler.agent.triggers.TriggerActionChain;
import com.jprofiler.agent.triggers.TriggerLog;
import com.jprofiler.agent.triggers.actions.InvokeInterceptorAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;

public class PrintMethodInvocationAction
extends InvokeInterceptorAction {
    public static final boolean DEFAULT_PRINT_STACK_TRACE = false;

    public PrintMethodInvocationAction(XMLElement xMLElement) {
        super(new Target(xMLElement.getBooleanAttribute("printStackTrace", false)));
    }

    private static class Target
    implements TriggerActionChain.ActionChainTarget {
        private boolean printStackTrace;

        public Target(boolean bl) {
            this.printStackTrace = bl;
        }

        public void methodEnter(Class clazz, c c2, Object object, Object[] objectArray) {
            TriggerLog.out.println("trigger method enter:");
            this.printMethod(c2);
            TriggerLog.out.println("  object " + object);
            TriggerLog.out.println("  parameters " + (objectArray != null ? Arrays.asList(objectArray) : "[]"));
            if (this.printStackTrace) {
                TriggerLog.out.println("  stack trace: ");
                StringWriter stringWriter = new StringWriter();
                new Exception("Stack trace").printStackTrace(new PrintWriter((Writer)stringWriter, true));
                TriggerLog.out.print(stringWriter.toString());
            }
            TriggerLog.out.println();
        }

        public void methodExit(Class clazz, c c2, Object object) {
            TriggerLog.out.println("trigger method exit:");
            this.printMethod(c2);
            TriggerLog.out.println("  return value " + object);
        }

        public void methodException(Class clazz, c c2, Throwable throwable) {
            TriggerLog.out.println("trigger method exception exit:");
            this.printMethod(c2);
            TriggerLog.out.println("  throwable " + throwable);
        }

        private void printMethod(c c2) {
            TriggerLog.out.println("  declaringClass " + c2.a().replace('/', '.'));
            TriggerLog.out.println("  methodName " + c2.b());
            TriggerLog.out.println("  methodSignature " + c2.c());
        }
    }
}

