/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.actions;

import com.jprofiler.agent.AgentEnvironment;
import com.jprofiler.agent.f;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.actions.TriggerUtil;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import com.jprofiler.agent.util.ab;
import com.jprofiler.agent.util.logging.a;
import com.jprofiler.agent.util.logging.b;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class HprofHeapdumpAction
extends TriggerAction {
    public static final String DEFAULT_FILE_NAME = "";
    public static final boolean DEFAULT_FULL_GC = true;
    public static final boolean DEFAULT_NUMBER = false;
    private String fileName;
    private boolean fullGc;
    private boolean number;

    public HprofHeapdumpAction(XMLElement xMLElement) {
        this.fileName = xMLElement.getStringAttribute("file", DEFAULT_FILE_NAME);
        this.fullGc = xMLElement.getBooleanAttribute("fullGc", true);
        this.number = xMLElement.getBooleanAttribute("number", false);
    }

    public void execute(boolean bl) {
        HprofHeapdumpAction.triggerHprofDump(a.a, this.fileName, this.fullGc, this.number, false);
    }

    public static String triggerHprofDump(b b2, String string, boolean bl, boolean bl2, boolean bl3) {
        if (!f.a().b()) {
            HprofHeapdumpAction.printVmTypeWarning();
        } else {
            try {
                String string2 = TriggerUtil.getSnapshotFilename(string, HprofHeapdumpAction.getTempSuffix(bl3), bl2);
                String string3 = bl3 ? File.createTempFile("jhd", ".hpz", AgentEnvironment.getTempDir()).getAbsolutePath() : string2;
                HprofHeapdumpAction.dump(b2, string2, bl);
                if (bl3) {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(string3)));
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                    TriggerUtil.pumpStream(bufferedInputStream, bufferedOutputStream);
                    ((InputStream)bufferedInputStream).close();
                    ((OutputStream)bufferedOutputStream).close();
                    new File(string2).delete();
                }
                return string3;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (throwable.getCause() != null) {
                    throwable2 = throwable.getCause();
                }
                System.err.println("JProfiler> Error saving heap snapshot:");
                throwable2.printStackTrace();
            }
        }
        return null;
    }

    private static void printVmTypeWarning() {
        if (ab.c()) {
            System.err.println("JProfiler> *****************************************************");
            System.err.println("JProfiler> WARNING: Could not save HPROF or PHD snapshot. ");
            System.err.println("JProfiler> Only available on Java 6+ HotSpot VMs and OpenJ9 VMs.");
            System.err.println("JProfiler> *****************************************************");
        } else {
            System.err.println("JProfiler> ************************************************");
            System.err.println("JProfiler> WARNING: Could not save HPROF snapshot. ");
            System.err.println("JProfiler> Only available on Java 6+ HotSpot VMs.");
            System.err.println("JProfiler> ************************************************");
        }
    }

    public static void dump(String string, boolean bl) throws Exception {
        HprofHeapdumpAction.dump(a.a, string, bl);
    }

    public static void dump(b b2, String string, boolean bl) throws Exception {
        new File(string).delete();
        b2.a("Saving heap snapshot '" + string + "' ... ");
        f.a().a(string, bl);
        b2.a("Done.");
    }

    public static String getTempSuffix(boolean bl) {
        if (bl) {
            return ".dat";
        }
        if (ab.c()) {
            return ".phd";
        }
        return ".hprof";
    }
}

