/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.d.c;
import com.jprofiler.agent.probe.ProbeHandler;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.triggers.actions.InvokeInterceptorAction;
import com.jprofiler.agent.triggers.actions.OverrideThreadStatusAction;
import com.jprofiler.agent.triggers.actions.ResetThreadStatusAction;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.actions.WaitForFinishAction;
import com.jprofiler.agent.util.s;
import com.jprofiler.api.agent.probe.InterceptionMethod;
import com.jprofiler.api.agent.probe.ProbeMetaData;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerActionChain {
    private TriggerAction[] enterActions;
    private TriggerAction[] exitActions;
    private ActionChainTarget[] chainTargets;
    private boolean ignoreRecursiveCalls;
    private boolean enabled;
    private ThreadLocal<s> enterCount = new ThreadLocal<s>(){

        @Override
        protected s initialValue() {
            return new s();
        }
    };

    public TriggerActionChain(List<TriggerAction> list, boolean bl) {
        this.ignoreRecursiveCalls = bl;
        ArrayList<TriggerAction> arrayList = new ArrayList<TriggerAction>();
        ArrayList<TriggerAction> arrayList2 = new ArrayList<TriggerAction>();
        ArrayList<ActionChainTarget> arrayList3 = new ArrayList<ActionChainTarget>();
        boolean bl2 = true;
        for (TriggerAction triggerAction : list) {
            if (triggerAction instanceof InvokeInterceptorAction) {
                ActionChainTarget actionChainTarget = ((InvokeInterceptorAction)triggerAction).getActionChainTarget();
                if (actionChainTarget == null) continue;
                arrayList3.add(actionChainTarget);
                continue;
            }
            if (triggerAction instanceof WaitForFinishAction) {
                bl2 = false;
                continue;
            }
            if (triggerAction instanceof OverrideThreadStatusAction) {
                arrayList.add(triggerAction);
                arrayList2.add(new ResetThreadStatusAction());
                continue;
            }
            if (bl2) {
                arrayList.add(triggerAction);
                continue;
            }
            arrayList2.add(triggerAction);
        }
        this.enterActions = arrayList.toArray(new TriggerAction[0]);
        this.exitActions = arrayList2.toArray(new TriggerAction[0]);
        this.chainTargets = arrayList3.toArray(new ActionChainTarget[0]);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void methodEnter(Class clazz, c c2, Object object, Object[] objectArray) {
        try {
            if (this.checkEnter()) {
                if (!this.enabled || !TriggerManager.globalEnabled) {
                    return;
                }
                for (TriggerAction object2 : this.enterActions) {
                    object2.execute(true);
                }
                for (ActionChainTarget actionChainTarget : this.chainTargets) {
                    actionChainTarget.methodEnter(clazz, c2, object, objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            ProbeHandler.handleThrowable(throwable);
        }
    }

    public void methodExit(Class clazz, c c2, Object object) {
        try {
            if (this.checkExit()) {
                if (!this.enabled || !TriggerManager.globalEnabled) {
                    return;
                }
                for (ActionChainTarget object2 : this.chainTargets) {
                    object2.methodExit(clazz, c2, object);
                }
                for (TriggerAction triggerAction : this.exitActions) {
                    triggerAction.execute(true);
                }
            }
        }
        catch (Throwable throwable) {
            ProbeHandler.handleThrowable(throwable);
        }
    }

    public void methodException(Class clazz, c c2, Throwable throwable) {
        try {
            if (this.checkExit()) {
                if (!this.enabled || !TriggerManager.globalEnabled) {
                    return;
                }
                for (ActionChainTarget object : this.chainTargets) {
                    object.methodException(clazz, c2, throwable);
                }
                for (TriggerAction triggerAction : this.exitActions) {
                    triggerAction.execute(true);
                }
            }
        }
        catch (Throwable throwable2) {
            ProbeHandler.handleThrowable(throwable2);
        }
    }

    private boolean checkExit() {
        if (this.ignoreRecursiveCalls) {
            s s2 = this.enterCount.get();
            --s2.a;
            return s2.a == 0;
        }
        return true;
    }

    private boolean checkEnter() {
        if (this.ignoreRecursiveCalls) {
            s s2 = this.enterCount.get();
            ++s2.a;
            return s2.a == 1;
        }
        return true;
    }

    public InterceptionMethod[] getInterceptionMethods() {
        return null;
    }

    public ProbeMetaData getMetaData() {
        return null;
    }

    public static interface ActionChainTarget {
        public void methodEnter(Class var1, c var2, Object var3, Object[] var4);

        public void methodExit(Class var1, c var2, Object var3);

        public void methodException(Class var1, c var2, Throwable var3);
    }
}

