/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.triggers.RuntimeTrigger;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.IOException;

public class TimerTrigger
extends RuntimeTrigger {
    public static final int DEFAULT_OFFSET_TIME = 1;
    public static final String DEFAULT_OFFSET_TIME_UNIT = "m";
    public static final int DEFAULT_INTERVAL_TIME = 1;
    public static final String DEFAULT_INTERVAL_TIME_UNIT = "m";
    public static final String DEFAULT_TYPE = "unlimited";
    public static final int DEFAULT_COUNT = 1;
    private long offsetMillis;
    private long intervalMillis;
    private int totalCount;
    private boolean unlimited;
    private final Timer timer = new Timer();

    public TimerTrigger(XMLElement xMLElement) throws IOException {
        super(xMLElement);
        int n2 = xMLElement.getIntAttribute("offsetTime", 1);
        String string = xMLElement.getStringAttribute("offsetTimeUnit", "m");
        this.offsetMillis = TriggerManager.getTimeMillis(n2, string);
        int n3 = xMLElement.getIntAttribute("intervalTime", 1);
        String string2 = xMLElement.getStringAttribute("intervalTimeUnit", "m");
        this.intervalMillis = TriggerManager.getTimeMillis(n3, string2);
        String string3 = xMLElement.getStringAttribute("type", DEFAULT_TYPE);
        this.unlimited = DEFAULT_TYPE.equals(string3);
        this.totalCount = xMLElement.getIntAttribute("count", 1);
        this.timer.start();
    }

    public void stop() {
        this.timer.stopped = true;
    }

    protected void changeEnabled(boolean bl) {
    }

    private class Timer
    extends Thread {
        private volatile boolean stopped;

        public Timer() {
            super("_jprofiler_trigger_timer");
            this.setDaemon(true);
        }

        public void run() {
            for (int i2 = 0; !this.stopped && (TimerTrigger.this.unlimited || i2 < TimerTrigger.this.totalCount); ++i2) {
                try {
                    Thread.sleep(i2 == 0 ? TimerTrigger.this.offsetMillis : TimerTrigger.this.intervalMillis);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (this.stopped || !TimerTrigger.this.isEnabled()) continue;
                TriggerManager.executeNoMethodActions(TimerTrigger.this.getActions());
            }
        }
    }
}

