/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.d.b;
import com.jprofiler.agent.e.f;
import com.jprofiler.agent.e.h;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.triggers.actions.AddBookmarkAction;
import com.jprofiler.agent.triggers.actions.HprofHeapdumpAction;
import com.jprofiler.agent.triggers.actions.MarkHeapAction;
import com.jprofiler.agent.triggers.actions.OverrideThreadStatusAction;
import com.jprofiler.agent.triggers.actions.PrintMessageAction;
import com.jprofiler.agent.triggers.actions.PrintMethodInvocationAction;
import com.jprofiler.agent.triggers.actions.RunGcAction;
import com.jprofiler.agent.triggers.actions.RunInterceptorScriptAction;
import com.jprofiler.agent.triggers.actions.RunScriptAction;
import com.jprofiler.agent.triggers.actions.SaveSnapshotAction;
import com.jprofiler.agent.triggers.actions.SleepAction;
import com.jprofiler.agent.triggers.actions.StartCallTracerAction;
import com.jprofiler.agent.triggers.actions.StartMonitorRecordingAction;
import com.jprofiler.agent.triggers.actions.StartProbeRecordingAction;
import com.jprofiler.agent.triggers.actions.StartProbeTrackingAction;
import com.jprofiler.agent.triggers.actions.StartRecordingAction;
import com.jprofiler.agent.triggers.actions.StopCallTracerAction;
import com.jprofiler.agent.triggers.actions.StopMonitorRecordingAction;
import com.jprofiler.agent.triggers.actions.StopProbeRecordingAction;
import com.jprofiler.agent.triggers.actions.StopProbeTrackingAction;
import com.jprofiler.agent.triggers.actions.StopRecordingAction;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.actions.TriggerHeapdumpAction;
import com.jprofiler.agent.triggers.actions.TriggerThreadDumpAction;
import com.jprofiler.agent.triggers.actions.WaitForFinishAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuntimeTrigger {
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_USE_GROUP_ID = false;
    public static final String DEFAULT_GROUP_ID = "";
    private boolean enabled;
    private boolean useGroupId;
    private String groupId = "";
    private List<TriggerAction> actions = new ArrayList<TriggerAction>();

    public static boolean readBooleanValue(XMLElement xMLElement, String string, boolean bl) {
        String string2 = xMLElement.getStringAttribute(string);
        if (string2 != null) {
            return Boolean.TRUE.toString().equals(string2);
        }
        return bl;
    }

    protected RuntimeTrigger(XMLElement xMLElement) throws IOException {
        this.enabled = RuntimeTrigger.readBooleanValue(xMLElement, "enabled", true);
        this.useGroupId = RuntimeTrigger.readBooleanValue(xMLElement, "groupId", false);
        this.groupId = xMLElement.getStringAttribute("groupId", DEFAULT_GROUP_ID);
        XMLElement xMLElement2 = b.a(xMLElement, "actions");
        if (xMLElement2 != null) {
            this.readActions(xMLElement2.getChildren(), this.isImmediateTrigger());
        }
    }

    protected RuntimeTrigger() {
        this.enabled = true;
    }

    protected abstract void changeEnabled(boolean var1);

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.changeEnabled(bl);
    }

    public boolean isEnabled() {
        return this.enabled && TriggerManager.globalEnabled;
    }

    public void stop() {
    }

    protected boolean isImmediateTrigger() {
        return false;
    }

    public String getUsedGroupId() {
        return this.useGroupId ? this.groupId : DEFAULT_GROUP_ID;
    }

    public List<TriggerAction> getActions() {
        return this.actions;
    }

    public void read(f f2) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        while (f2.readBoolean()) {
            TriggerAction triggerAction = (TriggerAction)Class.forName(f2.readUTF()).newInstance();
            triggerAction.read(f2);
            this.actions.add(triggerAction);
        }
    }

    public void write(h h2, int n2) throws IOException {
        for (TriggerAction triggerAction : this.actions) {
            h2.writeBoolean(true);
            h2.writeUTF(triggerAction.getClass().getName());
            triggerAction.write(h2, n2);
        }
        h2.writeBoolean(false);
    }

    private void readActions(Vector vector, boolean bl) {
        SleepAction sleepAction = null;
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            TriggerAction triggerAction = RuntimeTrigger.readAction((XMLElement)vector.get(i2));
            if (triggerAction == null) continue;
            if (triggerAction instanceof WaitForFinishAction) {
                sleepAction = null;
            }
            if (sleepAction != null && !triggerAction.isTopLevelOnly()) {
                sleepAction.addSubsequentAction(triggerAction);
            } else {
                this.actions.add(triggerAction);
            }
            if (bl || !(triggerAction instanceof SleepAction)) continue;
            sleepAction = (SleepAction)triggerAction;
        }
    }

    private static TriggerAction readAction(XMLElement xMLElement) {
        String string = xMLElement.getName();
        if (string.equals("printMessage")) {
            return new PrintMessageAction(xMLElement);
        }
        if (string.equals("printMethodInvocation")) {
            return new PrintMethodInvocationAction(xMLElement);
        }
        if (string.equals("runScript")) {
            return new RunScriptAction(xMLElement);
        }
        if (string.equals("runInterceptorScript")) {
            return new RunInterceptorScriptAction(xMLElement);
        }
        if (string.equals("sleep")) {
            return new SleepAction(xMLElement);
        }
        if (string.equals("waitForFinish")) {
            return new WaitForFinishAction();
        }
        if (string.equals("overrideThreadStatus")) {
            return new OverrideThreadStatusAction(xMLElement);
        }
        if (string.equals("addBookmark")) {
            return new AddBookmarkAction(xMLElement);
        }
        if (string.equals("hprofHeapdump")) {
            return new HprofHeapdumpAction(xMLElement);
        }
        if (string.equals("saveSnapshot")) {
            return new SaveSnapshotAction(xMLElement);
        }
        if (string.equals("runGc")) {
            return new RunGcAction();
        }
        if (string.equals("triggerHeapdump")) {
            return new TriggerHeapdumpAction(xMLElement);
        }
        if (string.equals("triggerThreadDump")) {
            return new TriggerThreadDumpAction();
        }
        if (string.equals("markHeap")) {
            return new MarkHeapAction();
        }
        if (string.equals("startRecording")) {
            return new StartRecordingAction(xMLElement);
        }
        if (string.equals("stopRecording")) {
            return new StopRecordingAction(xMLElement);
        }
        if (string.equals("startCallTracer")) {
            return new StartCallTracerAction(xMLElement);
        }
        if (string.equals("stopCallTracer")) {
            return new StopCallTracerAction();
        }
        if (string.equals("startMonitorRecording")) {
            return new StartMonitorRecordingAction(xMLElement);
        }
        if (string.equals("stopMonitorRecording")) {
            return new StopMonitorRecordingAction();
        }
        if (string.equals("startProbeRecording")) {
            return new StartProbeRecordingAction(xMLElement);
        }
        if (string.equals("stopProbeRecording")) {
            return new StopProbeRecordingAction(xMLElement);
        }
        if (string.equals("startProbeTracking")) {
            return new StartProbeTrackingAction(xMLElement);
        }
        if (string.equals("stopProbeTracking")) {
            return new StopProbeTrackingAction(xMLElement);
        }
        return null;
    }
}

