/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.triggers.RuntimeTrigger;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class OOMTrigger
extends RuntimeTrigger {
    private static boolean messageShown = false;

    private static void setGuarded(boolean bl) {
        String string = System.getProperty("java.version");
        try {
            if (string.compareTo("1.6") >= 0) {
                OOMTrigger.set(bl);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (messageShown) {
            return;
        }
        System.err.println("JProfiler> **********************************************************");
        System.err.println("JProfiler> WARNING: Could not set the OutOfMemory trigger");
        System.err.println("JProfiler> programmatically. This is only possible on Java 6 VMs or");
        System.err.println("JProfiler> better from Oracle.");
        System.err.println("JProfiler> **********************************************************");
        messageShown = true;
    }

    private static void set(boolean bl) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        mBeanServer.invoke(objectName, "setVMOption", new Object[]{"HeapDumpOnOutOfMemoryError", bl ? "true" : "false"}, new String[]{"java.lang.String", "java.lang.String"});
    }

    public OOMTrigger(XMLElement xMLElement) throws IOException {
        super(xMLElement);
    }

    protected void changeEnabled(boolean bl) {
        OOMTrigger.setGuarded(bl);
    }
}

