/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.sampler;

import com.jprofiler.agent.AttachManager;
import com.jprofiler.agent.probe.ProbeHandler;
import com.jprofiler.agent.sampler.b;
import com.jprofiler.agent.sampler.c;
import com.jprofiler.agent.sampler.d;
import com.jprofiler.agent.sampler.e;
import com.jprofiler.agent.sampler.f;
import com.jprofiler.agent.sampler.g;
import com.jprofiler.agent.sampler.h;
import com.jprofiler.agent.scripts.TelemetryScript;
import com.jprofiler.agent.triggers.ThresholdManager;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import com.jprofiler.agent.util.a.b.q;
import com.jprofiler.agent.util.ab;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sampler
extends Thread {
    private static final com.jprofiler.agent.sampler.a additionalTelemetryProvider = Sampler.initDataProvider();
    private static boolean firstInit = true;
    private static final List<d> mBeanTelemetries = new ArrayList<d>();
    private static final List<e> scriptTelemetries = new ArrayList<e>();

    private static native long doSampling(long var0, long var2, long[] var4, long[] var5, long[] var6, Object[] var7);

    private static native void initDescriptions(String[] var0, int[] var1, long[] var2, long var3, int var5);

    static native long getSystemCpuMillis();

    static native long getProcessCpuMillis();

    private static com.jprofiler.agent.sampler.a initDataProvider() {
        try {
            Class.forName("java.lang.management.MemoryUsage");
            return new c();
        }
        catch (Throwable throwable) {
            return new com.jprofiler.agent.sampler.a();
        }
    }

    public static long getTelemetryValue(Number number, int n2, int n3) {
        long l2 = number instanceof Double || number instanceof Float ? (long)(number.doubleValue() * (double)n2) : (number instanceof BigDecimal ? ((BigDecimal)number).movePointRight(n3).longValue() : number.longValue() * (long)n2);
        return l2;
    }

    public Sampler(String string) {
        super(string);
        this.setDaemon(true);
        this.setPriority(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        int n2 = !AttachManager.attachMode && ab.c() && Sampler.isJBoss() ? 2000 : 0;
        int n3 = Integer.getInteger("jprofiler.sampleDelay", n2);
        if (n3 > 0) {
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (firstInit) {
            firstInit = false;
            this.initAllDescriptions();
        }
        additionalTelemetryProvider.c();
        Runtime runtime = Runtime.getRuntime();
        int n4 = 1;
        try {
            long[] lArray = additionalTelemetryProvider.a(true);
            long l2 = runtime.totalMemory();
            long l3 = runtime.freeMemory();
            int n5 = -1;
            long l4 = runtime.maxMemory();
            if (l4 != Long.MAX_VALUE) {
                n5 = (int)((l2 - l3) * 100L / l4);
            }
            long l5 = Sampler.doSampling(l2, l3, lArray, this.getMBeanData(), this.getScriptData(), Sampler.getMBeanErrors());
            ThresholdManager.check(n5, additionalTelemetryProvider.e());
            q q2 = ProbeHandler.getJavaCollector().telemetryTimes;
            // MONITORENTER : q2
            if (l5 != -1L) {
                ProbeHandler.doSampling(l5);
            }
            // MONITOREXIT : q2
        }
        catch (Throwable throwable) {
            Object var18_14 = null;
            try {
                Thread.sleep(1000L);
                n4 = com.jprofiler.agent.util.g.a(n4);
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static boolean isJBoss() {
        return System.getProperty("sun.java.command", "").toLowerCase().contains("jboss") || System.getProperty("jboss.modules.system.pkgs") != null || System.getProperty("org.jboss.boot.log.file") != null;
    }

    private static long getMaximumHeap() {
        long l2 = Runtime.getRuntime().maxMemory();
        return l2 == Long.MAX_VALUE ? -1L : l2;
    }

    private long[] getMBeanData() {
        return Sampler.getData(mBeanTelemetries);
    }

    private long[] getScriptData() {
        return Sampler.getData(scriptTelemetries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] getData(List<? extends b> list) {
        List<? extends b> list2 = list;
        synchronized (list2) {
            if (list.isEmpty()) {
                return null;
            }
            long[] lArray = new long[list.size()];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = list.get(i2).a();
            }
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getMBeanErrors() {
        int n2;
        List<h> list = null;
        String[] stringArray = scriptTelemetries;
        synchronized (stringArray) {
            for (n2 = 0; n2 < scriptTelemetries.size(); ++n2) {
                list = scriptTelemetries.get(n2).a(list);
            }
        }
        stringArray = mBeanTelemetries;
        synchronized (stringArray) {
            for (n2 = 0; n2 < mBeanTelemetries.size(); ++n2) {
                list = mBeanTelemetries.get(n2).a(list);
            }
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        stringArray = new String[list.size()];
        int[] nArray = new int[list.size()];
        String[] stringArray2 = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            h h2 = list.get(i2);
            stringArray[i2] = h2.a();
            nArray[i2] = h2.b().a();
            stringArray2[i2] = h2.c();
        }
        return new Object[]{stringArray, nArray, stringArray2};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetErrorReport() {
        List<b> list = scriptTelemetries;
        synchronized (list) {
            for (e b2 : scriptTelemetries) {
                b2.c();
            }
        }
        list = mBeanTelemetries;
        synchronized (list) {
            for (d d2 : mBeanTelemetries) {
                d2.c();
            }
        }
    }

    private void initAllDescriptions() {
        List<a> list = additionalTelemetryProvider.b();
        if (list.size() > 0) {
            String[] stringArray = new String[list.size()];
            int[] nArray = new int[list.size()];
            long[] lArray = new long[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                a a2 = list.get(i2);
                stringArray[i2] = a2.a;
                nArray[i2] = a2.b;
                lArray[i2] = a2.c;
            }
            Sampler.initDescriptions(stringArray, nArray, lArray, Sampler.getMaximumHeap(), 0);
        }
    }

    public static long getAvailablePermGen() {
        return additionalTelemetryProvider.a();
    }

    public static void updateConfig(XMLElement xMLElement) {
        try {
            XMLElement xMLElement2 = com.jprofiler.agent.d.b.a(xMLElement, "customTelemetries");
            if (xMLElement2 != null) {
                Sampler.readCustomTelemetries(xMLElement2.getChildren());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void readCustomTelemetries(Vector vector) throws IOException {
        ArrayList<d> arrayList = new ArrayList<d>();
        ArrayList<e> arrayList2 = new ArrayList<e>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            XMLElement xMLElement = (XMLElement)vector.get(i2);
            String string = xMLElement.getStringAttribute("name", "");
            if (string.length() <= 0) continue;
            Vector vector2 = xMLElement.getChildren();
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                Object object;
                String string2;
                XMLElement xMLElement2 = (XMLElement)vector2.get(i3);
                String string3 = xMLElement2.getStringAttribute("name", "");
                if (xMLElement2.getName().equals("scriptLine")) {
                    string2 = com.jprofiler.agent.d.b.b(xMLElement2, "script");
                    if (string2 == null || string2.length() <= 0) continue;
                    try {
                        object = (TelemetryScript)((Object)com.jprofiler.agent.d.a.a(string2, ClassLoader.getSystemClassLoader()));
                        arrayList2.add(new e(string, string3, (TelemetryScript)object));
                    }
                    catch (Throwable throwable) {
                        System.err.println("JProfiler> could not load telemetry script class");
                        throwable.printStackTrace();
                    }
                    continue;
                }
                if (!com.jprofiler.agent.mbean.c.a || !xMLElement2.getName().equals("mbeanLine")) continue;
                string2 = xMLElement2.getStringAttribute("beanName", "");
                object = xMLElement2.getStringAttribute("attributePath", "");
                if (string2.length() <= 0 || ((String)object).length() <= 0) continue;
                try {
                    String[] stringArray = com.jprofiler.agent.mbean.b.b((String)object);
                    arrayList.add(new d(string, string3, ObjectName.getInstance(string2), stringArray));
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("JProfiler> could not add mbean telemetry");
                    throwable.printStackTrace();
                }
            }
        }
        Sampler.updateMbeanTelemetries(arrayList);
        Sampler.updateScriptTelemetries(arrayList2);
    }

    public static void updateTelemetries(f f2) {
        ArrayList<d> arrayList = new ArrayList<d>();
        for (f.a a2 : f2.a()) {
            if (a2.a().length() <= 0 || a2.c().length() <= 0 || a2.d().length() <= 0) continue;
            try {
                String[] stringArray = com.jprofiler.agent.mbean.b.b(a2.d());
                arrayList.add(new d(a2.a(), a2.b(), ObjectName.getInstance(a2.c()), stringArray));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Sampler.updateMbeanTelemetries(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMbeanTelemetries(List<d> list) {
        List<d> list2 = mBeanTelemetries;
        synchronized (list2) {
            mBeanTelemetries.clear();
            mBeanTelemetries.addAll(list);
            Sampler.initCustomDescriptions(list, 11);
        }
    }

    private static void initCustomDescriptions(List<? extends b> list, int n2) {
        String[] stringArray = new String[list.size()];
        int[] nArray = new int[list.size()];
        long[] lArray = new long[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            b b2 = list.get(i2);
            stringArray[i2] = b2.b();
            nArray[i2] = n2;
            lArray[i2] = -1L;
        }
        Sampler.initDescriptions(stringArray, nArray, lArray, Sampler.getMaximumHeap(), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateScriptTelemetries(List<e> list) {
        List<e> list2 = scriptTelemetries;
        synchronized (list2) {
            scriptTelemetries.clear();
            scriptTelemetries.addAll(list);
            Sampler.initCustomDescriptions(list, 12);
        }
    }

    static byte[] setScriptTelemetries(byte[] byArray) throws IOException {
        g g2 = new g();
        g2.a(new com.jprofiler.agent.e.g(new ByteArrayInputStream(byArray)), 65);
        return null;
    }

    static byte[] setTelemetries(byte[] byArray) throws IOException {
        if (!com.jprofiler.agent.mbean.c.a) {
            return null;
        }
        f f2 = new f();
        f2.a(new com.jprofiler.agent.e.g(new ByteArrayInputStream(byArray)), 65);
        Sampler.updateTelemetries(f2);
        return null;
    }

    public static class a {
        String a;
        int b;
        long c;

        public a(String string, int n2, long l2) {
            this.a = string;
            this.b = n2;
            this.c = l2;
        }

        public String a() {
            return this.a;
        }

        public int b() {
            return this.b;
        }

        public long c() {
            return this.c;
        }
    }
}

