/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.probe.structures;

import com.jprofiler.agent.probe.p;
import com.jprofiler.agent.probe.structures.TrackingInfo;
import com.jprofiler.agent.probe.structures.a;
import com.jprofiler.agent.probe.structures.h;
import com.jprofiler.agent.probe.structures.n;
import com.jprofiler.agent.util.a.b.x;
import com.jprofiler.agent.util.a.b.z;
import com.jprofiler.api.agent.ProbeObjectType;
import com.jprofiler.api.agent.probe.DataType;
import com.jprofiler.api.agent.probe.ProbeMetaData;
import com.jprofiler.api.agent.probe.Unit;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataImpl
extends ProbeMetaData {
    public static final String MSG_NO_DESCRIPTION = "[No description set]";
    private String name;
    private String description = "[No description set]";
    private String payloadName;
    private boolean payload;
    private boolean recordEvents;
    private boolean telemetry;
    private boolean controlObjectView;
    private boolean deferredOperations;
    private boolean secondaryPayloads;
    private List<a> additionalControlObjectData = new ArrayList<a>();
    private List<n> telemetries = new ArrayList<n>();
    private String[] sumNames = new String[0];
    private int telemetryCount;
    private int customTelemetryCount;
    private boolean annotatePayloads;
    private boolean formatPayloadOperation;
    private boolean uncappedEvents;
    private boolean untimed;
    private boolean heapWalkerControlObject;
    private boolean payloadHotspots = true;
    private boolean uncappedPayloads;
    private boolean async;
    private final Set<ProbeObjectType> trackableObjects = new HashSet<ProbeObjectType>();
    private transient x<n[]> customTypeToTelemetryDescriptors = new z<n[]>();
    private transient x<Integer> customTypeToSumGroupIndex = new z<Integer>();
    private h eventMetaData = new h();
    private List<h> specialEventMetaData = new ArrayList<h>();

    public MetaDataImpl() {
    }

    public MetaDataImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = string;
        this.payloadName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeUTF(this.description);
        dataOutputStream.writeUTF(this.payloadName);
        dataOutputStream.writeUTF(this.eventMetaData.e());
        dataOutputStream.writeUTF(this.eventMetaData.f());
        dataOutputStream.writeBoolean(this.payload);
        dataOutputStream.writeBoolean(this.recordEvents);
        dataOutputStream.writeBoolean(this.telemetry);
        dataOutputStream.writeBoolean(this.controlObjectView);
        dataOutputStream.writeBoolean(this.deferredOperations);
        dataOutputStream.writeBoolean(this.secondaryPayloads);
        Iterator<Object> iterator = this.trackableObjects;
        synchronized (iterator) {
            dataOutputStream.writeInt(this.trackableObjects.size());
            for (ProbeObjectType probeObjectType : this.trackableObjects) {
                dataOutputStream.writeInt(TrackingInfo.getObjectTypeIntValue(probeObjectType));
            }
        }
        dataOutputStream.writeInt(h.b(this.eventMetaData.g()));
        this.eventMetaData.b(dataOutputStream);
        dataOutputStream.writeInt(this.additionalControlObjectData.size());
        for (a a2 : this.additionalControlObjectData) {
            a2.a(dataOutputStream);
        }
        dataOutputStream.writeInt(this.telemetries.size());
        for (n n2 : this.telemetries) {
            n2.a(dataOutputStream);
        }
        com.jprofiler.agent.util.p.a((DataOutput)dataOutputStream, this.sumNames);
        com.jprofiler.agent.util.p.a((DataOutput)dataOutputStream, this.eventMetaData.b());
        com.jprofiler.agent.util.p.a((DataOutput)dataOutputStream, this.eventMetaData.d());
        com.jprofiler.agent.util.p.a((DataOutput)dataOutputStream, this.eventMetaData.c());
        dataOutputStream.writeBoolean(this.formatPayloadOperation);
        dataOutputStream.writeBoolean(this.uncappedEvents);
        dataOutputStream.writeBoolean(this.untimed);
        dataOutputStream.writeBoolean(this.heapWalkerControlObject);
        dataOutputStream.writeBoolean(this.payloadHotspots);
        dataOutputStream.writeBoolean(this.uncappedPayloads);
        dataOutputStream.writeBoolean(this.async);
        dataOutputStream.writeInt(this.specialEventMetaData.size());
        for (h h2 : this.specialEventMetaData) {
            h2.a(dataOutputStream);
        }
    }

    public void read(DataInput dataInput, String string, int n2) throws IOException {
        int n3;
        int n4;
        this.name = dataInput.readUTF();
        this.description = p.a(dataInput.readUTF());
        this.payloadName = p.a(dataInput.readUTF());
        this.eventMetaData.a(p.a(dataInput.readUTF()));
        this.eventMetaData.b(p.a(dataInput.readUTF()));
        this.payload = dataInput.readBoolean();
        this.recordEvents = dataInput.readBoolean();
        this.telemetry = dataInput.readBoolean();
        this.controlObjectView = dataInput.readBoolean();
        if (n2 >= 32) {
            this.deferredOperations = dataInput.readBoolean();
            this.secondaryPayloads = dataInput.readBoolean();
            n4 = dataInput.readInt();
            for (n3 = 0; n3 < n4; ++n3) {
                this.trackableObjects.add(TrackingInfo.getObjectTypeFromIntValue(dataInput.readInt()));
            }
        }
        this.eventMetaData.a(h.b(dataInput.readInt()));
        this.eventMetaData.a(dataInput, n2);
        n4 = dataInput.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            this.additionalControlObjectData.add(a.a(dataInput, n2));
        }
        this.telemetryCount = n.a(this.telemetries, dataInput, n2);
        this.sumNames = com.jprofiler.agent.util.p.a(dataInput);
        this.eventMetaData.a(com.jprofiler.agent.util.p.a(dataInput));
        this.eventMetaData.b(com.jprofiler.agent.util.p.a(dataInput));
        this.eventMetaData.a(com.jprofiler.agent.util.p.a(dataInput, false));
        if (n2 >= 36) {
            this.formatPayloadOperation = dataInput.readBoolean();
        } else if ("builtin.PersistenceProbe".equals(string)) {
            this.formatPayloadOperation = true;
        }
        if (n2 >= 38) {
            this.uncappedEvents = dataInput.readBoolean();
            this.untimed = dataInput.readBoolean();
            this.heapWalkerControlObject = dataInput.readBoolean();
        }
        if (n2 >= 54) {
            this.payloadHotspots = dataInput.readBoolean();
            this.uncappedPayloads = dataInput.readBoolean();
        }
        if (n2 >= 59) {
            this.async = dataInput.readBoolean();
        }
        if (n2 >= 47) {
            n3 = dataInput.readInt();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.specialEventMetaData.add(new h().b(dataInput, n2));
            }
        }
    }

    public x<n[]> getCustomTypeToTelemetryDescriptors() {
        return this.customTypeToTelemetryDescriptors;
    }

    public x getCustomTypeToSumGroupIndex() {
        return this.customTypeToSumGroupIndex;
    }

    public ProbeMetaData addCountTelemetry(String string, int[] nArray, String string2, boolean bl) {
        this.addBuiltInTelemetry(new n(3, this.telemetryCount++, string, Unit.PER_SECOND, 0, string2, bl), nArray);
        return this;
    }

    public ProbeMetaData addThroughputTelemetry(String string, int[] nArray, String string2, boolean bl) {
        this.addBuiltInTelemetry(new n(4, this.telemetryCount++, string, Unit.BYTES, 0, string2, bl), nArray);
        return this;
    }

    public ProbeMetaData addAverageDurationTelemetry(String string, int[] nArray, String string2, boolean bl) {
        this.addBuiltInTelemetry(new n(5, this.telemetryCount++, string, Unit.MICROSECONDS, 0, string2, bl), nArray);
        return this;
    }

    private void addBuiltInTelemetry(n n2, int[] nArray) {
        for (int n3 : nArray) {
            n[] nArray2 = this.customTypeToTelemetryDescriptors.c(n3);
            if (nArray2 == null) {
                nArray2 = new n[1];
            } else {
                n[] nArray3 = new n[nArray2.length + 1];
                System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
                nArray2 = nArray3;
            }
            nArray2[nArray2.length - 1] = n2;
            this.customTypeToTelemetryDescriptors.a(n3, nArray2);
        }
        this.telemetries.add(n2);
    }

    public ProbeMetaData addOpenControlObjectTelemetry(String string, String string2) {
        this.telemetries.add(new n(2, this.telemetryCount++, string, Unit.PLAIN, 0, string2, false));
        return this;
    }

    public ProbeMetaData addCustomTelemetry(String string, Unit unit, int n2, String string2, boolean bl) {
        ++this.customTelemetryCount;
        this.telemetries.add(new n(1, this.telemetryCount++, string, unit, n2, string2, bl));
        return this;
    }

    @Override
    public ProbeMetaData addOpenControlObjectTelemetry(String string) {
        return this.addOpenControlObjectTelemetry(string, "");
    }

    @Override
    @Deprecated
    public ProbeMetaData addCustomTelemetry(String string, Unit unit, float f2) {
        this.addCustomTelemetry(string, unit, MetaDataImpl.getScale(f2), "", false);
        return this;
    }

    private static int getScale(float f2) {
        return f2 == 0.0f ? 0 : (int)Math.round(Math.log10(f2));
    }

    @Override
    public ProbeMetaData startTelemetryGroup(String string) {
        return this.startTelemetryGroup(string, false);
    }

    public ProbeMetaData startTelemetryGroup(String string, boolean bl) {
        return this.startTelemetryGroup(string, bl, "", false);
    }

    public ProbeMetaData startTelemetryGroup(String string, boolean bl, String string2, boolean bl2) {
        this.telemetries.add(new n(string, bl, string2, bl2));
        return this;
    }

    public int getCustomTelemetryCount() {
        return this.customTelemetryCount;
    }

    public ProbeMetaData addSumGroup(String string, int[] nArray) {
        Integer n2 = this.sumNames.length;
        String[] stringArray = new String[this.sumNames.length + 1];
        System.arraycopy(this.sumNames, 0, stringArray, 0, this.sumNames.length);
        stringArray[this.sumNames.length] = string;
        this.sumNames = stringArray;
        for (int n3 : nArray) {
            this.customTypeToSumGroupIndex.a(n3, n2);
        }
        return this;
    }

    public String[] getSumNames() {
        return this.sumNames;
    }

    public h getEventMetaData() {
        return this.eventMetaData;
    }

    @Override
    public ProbeMetaData addAdditionalData(String string, DataType dataType) {
        return this.addAdditionalData(string, dataType, false);
    }

    public ProbeMetaData addAdditionalData(String string, DataType dataType, boolean bl) {
        this.eventMetaData.a(string, dataType, bl);
        return this;
    }

    @Override
    public ProbeMetaData addAdditionalControlObjectData(String string, DataType dataType, boolean bl) {
        this.additionalControlObjectData.add(new a(string, dataType, bl, false));
        return this;
    }

    public List<a> getAdditionalControlObjectData() {
        return this.additionalControlObjectData;
    }

    public List<n> getTelemetries() {
        return this.telemetries;
    }

    @Override
    public ProbeMetaData customTypeNames(String ... stringArray) {
        this.eventMetaData.a(stringArray);
        return this;
    }

    public boolean isControlObjectView() {
        return this.controlObjectView;
    }

    @Override
    public ProbeMetaData controlObjectView(boolean bl) {
        this.controlObjectView = bl;
        this.addTrackableObject(ProbeObjectType.CONTROL_OBJECT_FROM_DESCRIPTION);
        this.addTrackableObject(ProbeObjectType.CONTROL_OBJECT_FROM_ID);
        return this;
    }

    @Override
    public ProbeMetaData customColors(int ... nArray) {
        this.eventMetaData.a(nArray);
        return this;
    }

    public boolean isPayload() {
        return this.payload;
    }

    @Override
    public ProbeMetaData payload(boolean bl) {
        this.payload = bl;
        this.addTrackableObject(ProbeObjectType.HOTSPOT);
        return this;
    }

    public boolean isRecordEvents() {
        return this.recordEvents;
    }

    @Override
    public ProbeMetaData events(boolean bl) {
        this.recordEvents = bl;
        return this;
    }

    public boolean isTelemetry() {
        return this.telemetry;
    }

    @Override
    public ProbeMetaData telemetry(boolean bl) {
        this.telemetry = bl;
        return this;
    }

    public ProbeMetaData deferredOperations(boolean bl) {
        this.deferredOperations = bl;
        return this;
    }

    public boolean isDeferredOperations() {
        return this.deferredOperations;
    }

    public boolean isSecondaryPayloads() {
        return this.secondaryPayloads;
    }

    public ProbeMetaData secondaryPayloads(boolean bl) {
        this.secondaryPayloads = bl;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPayloadName() {
        return this.payloadName;
    }

    @Override
    public ProbeMetaData payloadName(String string) {
        this.payloadName = string;
        return this;
    }

    @Override
    public ProbeMetaData openTypeName(String string) {
        this.eventMetaData.a(string);
        return this;
    }

    @Override
    public ProbeMetaData closeTypeName(String string) {
        this.eventMetaData.b(string);
        return this;
    }

    @Override
    public ProbeMetaData description(String string) {
        this.description = string;
        return this;
    }

    public Collection getTrackableObjects() {
        return this.trackableObjects;
    }

    public ProbeMetaData addTrackableObject(ProbeObjectType probeObjectType) {
        this.trackableObjects.add(probeObjectType);
        return this;
    }

    @Override
    public ProbeMetaData recordOnStartup(boolean bl) {
        return this;
    }

    public boolean isAnnotatePayloads() {
        return this.annotatePayloads;
    }

    @Override
    public ProbeMetaData annotatePayloads(boolean bl) {
        this.annotatePayloads = bl;
        return this;
    }

    public int getTelemetryCount() {
        return this.telemetryCount;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MetaDataImpl metaDataImpl = (MetaDataImpl)object;
        if (this.uncappedEvents != metaDataImpl.uncappedEvents) {
            return false;
        }
        if (this.untimed != metaDataImpl.untimed) {
            return false;
        }
        if (this.payloadHotspots != metaDataImpl.payloadHotspots) {
            return false;
        }
        if (this.uncappedPayloads != metaDataImpl.uncappedPayloads) {
            return false;
        }
        if (this.payload != metaDataImpl.payload) {
            return false;
        }
        if (this.telemetry != metaDataImpl.telemetry) {
            return false;
        }
        if (this.deferredOperations != metaDataImpl.deferredOperations) {
            return false;
        }
        if (this.secondaryPayloads != metaDataImpl.secondaryPayloads) {
            return false;
        }
        if (this.recordEvents != metaDataImpl.recordEvents) {
            return false;
        }
        if (this.additionalControlObjectData != null ? !this.additionalControlObjectData.equals(metaDataImpl.additionalControlObjectData) : metaDataImpl.additionalControlObjectData != null) {
            return false;
        }
        if (!Arrays.equals(this.sumNames, metaDataImpl.sumNames)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(metaDataImpl.name) : metaDataImpl.name != null) {
            return false;
        }
        if (this.payloadName != null ? !this.payloadName.equals(metaDataImpl.payloadName) : metaDataImpl.payloadName != null) {
            return false;
        }
        if (this.telemetries != null ? !this.telemetries.equals(metaDataImpl.telemetries) : metaDataImpl.telemetries != null) {
            return false;
        }
        return this.eventMetaData.equals(metaDataImpl.eventMetaData);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean isFormatPayloadOperation() {
        return this.formatPayloadOperation;
    }

    public MetaDataImpl formatPayloadOperation(boolean bl) {
        this.formatPayloadOperation = bl;
        return this;
    }

    public boolean isUncappedEvents() {
        return this.uncappedEvents;
    }

    public MetaDataImpl uncappedEvents(boolean bl) {
        this.uncappedEvents = bl;
        return this;
    }

    public boolean isUntimed() {
        return this.untimed;
    }

    public MetaDataImpl untimed(boolean bl) {
        this.untimed = bl;
        return this;
    }

    public boolean isPayloadHotspots() {
        return this.payload && this.payloadHotspots;
    }

    public MetaDataImpl payloadHotspots(boolean bl) {
        this.payloadHotspots = bl;
        return this;
    }

    public boolean isUncappedPayloads() {
        return this.uncappedPayloads;
    }

    public MetaDataImpl uncappedPayloads(boolean bl) {
        this.uncappedPayloads = bl;
        return this;
    }

    public boolean isHeapWalkerControlObject() {
        return this.heapWalkerControlObject;
    }

    public MetaDataImpl heapWalkerControlObject(boolean bl) {
        this.heapWalkerControlObject = bl;
        return this;
    }

    public void addSpecialEventMetaData(h h2) {
        this.specialEventMetaData.add(h2);
    }

    public List<h> getSpecialEventMetaData() {
        return this.specialEventMetaData;
    }

    public MetaDataImpl async(boolean bl) {
        this.async = bl;
        return this;
    }

    public boolean isAsync() {
        return this.async;
    }
}

