/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent;

import com.jprofiler.agent.Agent;
import com.jprofiler.agent.ProbeThreadManager;
import com.jprofiler.agent.probe.CallSite;
import com.jprofiler.agent.probe.ProbeHandler;
import com.jprofiler.agent.probe.d;
import com.jprofiler.agent.probe.d.b;
import com.jprofiler.agent.probe.g.c;
import com.jprofiler.agent.probe.l;
import com.jprofiler.agent.probe.payload.BasePayloadInfo;
import com.jprofiler.agent.probe.structures.h;
import com.jprofiler.agent.probe.structures.i;
import com.jprofiler.agent.probe.structures.m;
import com.jprofiler.agent.util.a.b.x;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProfilerThreadManager
implements ProbeThreadManager {
    public static final int NO_STACK_CALL_TREE_ID = 2147483547;
    private static final JProfilerThreadManager INITIAL_THREAD_MANAGER = new JProfilerThreadManager(0L);
    private static final long FIRST_DEFERRED_MASK = 0x100000000L;
    public long threadId;
    public short lineNumberHint;
    private long[] payloadData;
    private final CallSite cachedCallSite = new CallSite();
    private Map<c, i> eventCollections;
    private static ThreadLocal<JProfilerThreadManager> threadManagerLocal = new ThreadLocal();

    private static native JProfilerThreadManager getCurrentJProfilerThreadManager(Thread var0);

    private JProfilerThreadManager(long l2) {
        this.threadId = l2;
    }

    public static JProfilerThreadManager create(long l2) {
        return new JProfilerThreadManager(l2);
    }

    public static JProfilerThreadManager getJProfilerThreadManager() {
        JProfilerThreadManager jProfilerThreadManager = threadManagerLocal.get();
        if (jProfilerThreadManager == null) {
            jProfilerThreadManager = JProfilerThreadManager.getCurrentJProfilerThreadManager(Thread.currentThread());
            if (jProfilerThreadManager != null) {
                threadManagerLocal.set(jProfilerThreadManager);
            } else {
                jProfilerThreadManager = INITIAL_THREAD_MANAGER;
            }
        }
        return jProfilerThreadManager;
    }

    @Override
    public CallSite enterCallSite(String string, String string2, boolean bl) {
        int n2 = ProbeHandler.getCallSiteId(this.threadId, true, true, false, false, false);
        if (n2 == 0) {
            return null;
        }
        this.cachedCallSite.init(n2, 0L);
        return this.cachedCallSite;
    }

    @Override
    public void exitCallSite() {
    }

    public void fillTiming(BasePayloadInfo basePayloadInfo) {
        this.fillTiming(basePayloadInfo, false);
    }

    public void fillTiming(BasePayloadInfo basePayloadInfo, boolean bl) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.fillPayloadInfo0(lArray, 0, false, this.threadId, bl, false);
        basePayloadInfo.copyData(lArray);
    }

    public void fillTimingAndId(BasePayloadInfo basePayloadInfo, int n2) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.fillPayloadInfo0(lArray, n2, true, this.threadId, false, false);
        basePayloadInfo.copyData(lArray);
    }

    public void fillAsyncNoStack(BasePayloadInfo basePayloadInfo) {
        basePayloadInfo.setCallTreeId(2147483547);
        basePayloadInfo.setThreadManagerId(this.threadId);
        basePayloadInfo.setTimeStampMicro(Agent.getCounter());
        basePayloadInfo.setDeferred();
        basePayloadInfo.setBlockedMicro(System.nanoTime());
    }

    @Override
    public void fillAsync(BasePayloadInfo basePayloadInfo, int n2) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.fillPayloadInfo0(lArray, n2, true, this.threadId, false, true);
        basePayloadInfo.copyData(lArray);
        basePayloadInfo.setDeferred();
        basePayloadInfo.setBlockedMicro(System.nanoTime());
    }

    @Override
    public void fillAsync(d d2, BasePayloadInfo basePayloadInfo, int n2) {
        if (d2 == null || d2.b() == 0L) {
            this.fillAsync(basePayloadInfo, n2);
        } else {
            basePayloadInfo.copyData(d2);
            basePayloadInfo.setDeferred();
            basePayloadInfo.setBlockedMicro(System.nanoTime());
        }
    }

    @Override
    public d createDeferredAsyncSite(boolean bl, boolean bl2, int n2) {
        long[] lArray = this.getPayloadData();
        if (bl2) {
            long l2 = ProbeHandler.getDeferredAsyncSite0(lArray, bl, n2, this.threadId);
            int n3 = (int)l2;
            long l3 = lArray[1];
            if (n3 == 0 && l3 == 0L) {
                return null;
            }
            if ((l2 & 0x100000000L) != 0L) {
                return new d.a(n3, (int)lArray[0], l3, lArray[6]);
            }
            return new d(n3, (int)lArray[0], l3, lArray[6]);
        }
        long l4 = ProbeHandler.getDeferredAsyncSite0(null, bl, 0, this.threadId);
        int n4 = (int)l4;
        if (n4 == 0) {
            return null;
        }
        if ((l4 & 0x100000000L) != 0L) {
            return new d.a(n4, 0, 0L, 0L);
        }
        return new d(n4, 0, 0L, 0L);
    }

    @Override
    public d createAsyncSite(boolean bl, boolean bl2, int n2) {
        if (bl2) {
            long[] lArray = this.getPayloadData();
            int n3 = ProbeHandler.getAsyncSite0(lArray, bl, n2, this.threadId);
            long l2 = lArray[1];
            if (n3 == 0 && l2 == 0L) {
                return null;
            }
            return new d(n3, (int)lArray[0], l2, lArray[6]);
        }
        int n4 = ProbeHandler.getAsyncSite0(null, bl, 0, this.threadId);
        if (n4 == 0) {
            return null;
        }
        return new d(n4, 0, 0L, 0L);
    }

    public static void restartAsyncTime(BasePayloadInfo basePayloadInfo) {
        basePayloadInfo.setBlockedMicro(System.nanoTime());
    }

    public static void calculateAsyncTime(BasePayloadInfo basePayloadInfo) {
        basePayloadInfo.setWaitingMicro((System.nanoTime() - basePayloadInfo.getBlockedMicro()) / 1000L + basePayloadInfo.getWaitingMicro());
        basePayloadInfo.setBlockedMicro(0L);
        basePayloadInfo.setRunnableMicro(0L);
        basePayloadInfo.setNetioMicro(0L);
    }

    private long[] getPayloadData() {
        if (this.payloadData == null) {
            this.payloadData = new long[7];
        }
        return this.payloadData;
    }

    @Override
    public long enterInterceptionMethod(String string, int n2, boolean bl) {
        long l2 = ProbeHandler.getInterceptionMethodId(string, n2);
        this.enterSpecialMethod(l2, n2, true, bl);
        return l2;
    }

    @Override
    public long enterInterceptionMethod(int n2, String string, int n3, boolean bl) {
        long l2 = ProbeHandler.getLocalCallSiteMethodId(n2, string, n3);
        this.enterSpecialMethod(l2, n3, true, bl);
        return l2;
    }

    private static boolean isTrackingType(int n2) {
        return n2 >= 3 && n2 <= 10;
    }

    public void enterSpecialMethod(long l2, int n2, boolean bl, boolean bl2) {
        if (l2 != 0L) {
            if (JProfilerThreadManager.isTrackingType(n2)) {
                this.getAndResetLineNumberHint();
            }
            ProbeHandler.enterInterceptionMethod0(l2, n2, this.threadId, bl, bl2);
        }
    }

    public void enterPayloadSpecialMethod(long l2, int n2, BasePayloadInfo basePayloadInfo) {
        if (l2 != 0L) {
            long[] lArray = this.getPayloadData();
            ProbeHandler.enterPayloadInterceptionMethod0(l2, n2, this.threadId, lArray);
            basePayloadInfo.copyData(lArray);
        }
    }

    @Override
    public long enterInterceptionMethod(m m2, int n2, boolean bl) {
        return this.enterInterceptionMethod(m2.b(), n2, bl);
    }

    public void exitPayloadInterceptionMethod(long l2, BasePayloadInfo basePayloadInfo) {
        if (l2 != Long.MAX_VALUE) {
            long[] lArray = this.getPayloadData();
            ProbeHandler.exitPayloadInterceptionMethod0(l2, this.threadId, lArray);
            basePayloadInfo.calcDifference(lArray);
        }
    }

    @Override
    public boolean exitInterceptionMethod(long l2, Object object) {
        if (l2 != Long.MAX_VALUE) {
            ProbeHandler.exitInterceptionMethod0(l2, this.threadId);
        }
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(c c2, b b2, int n2) {
        JProfilerThreadManager jProfilerThreadManager = this;
        synchronized (jProfilerThreadManager) {
            i i2;
            if (this.eventCollections == null) {
                this.eventCollections = new HashMap<c, i>();
            }
            if ((i2 = this.eventCollections.get(c2)) == null) {
                i2 = new i(n2);
                this.eventCollections.put(c2, i2);
            }
            i2.a(b2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public i removeEvents(c c2) {
        i i2 = null;
        JProfilerThreadManager jProfilerThreadManager = this;
        synchronized (jProfilerThreadManager) {
            if (this.eventCollections != null && !this.eventCollections.isEmpty()) {
                i2 = this.eventCollections.remove(c2);
            }
        }
        return i2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public i getAndResetEvents(c c2) {
        JProfilerThreadManager jProfilerThreadManager = this;
        synchronized (jProfilerThreadManager) {
            if (this.eventCollections != null) {
                return this.eventCollections.remove(c2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeEventObjects(c c2, h h2, byte[] byArray, c.a a2, DataOutputStream dataOutputStream, x<l> x2) throws IOException {
        JProfilerThreadManager jProfilerThreadManager = this;
        synchronized (jProfilerThreadManager) {
            i i2;
            if (this.eventCollections != null && (i2 = this.eventCollections.get(c2)) != null) {
                return c2.a(i2, h2, byArray, a2, dataOutputStream, x2);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEvents() {
        JProfilerThreadManager jProfilerThreadManager = this;
        synchronized (jProfilerThreadManager) {
            if (this.eventCollections != null) {
                this.eventCollections.clear();
            }
        }
    }

    public short getAndResetLineNumberHint() {
        short s2 = this.lineNumberHint;
        this.lineNumberHint = 0;
        return s2;
    }
}

