/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent;

import com.jprofiler.agent.Agent;
import com.jprofiler.agent.AgentEnvironment;
import com.jprofiler.agent.c.a;
import com.jprofiler.agent.probe.ProbeHandler;
import com.jprofiler.agent.probe.c;
import com.jprofiler.agent.probe.f.i;
import com.jprofiler.agent.probe.structures.TrackingInfo;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.util.ab;
import com.jprofiler.agent.util.j;
import com.jprofiler.api.agent.HeapDumpOptions;
import com.jprofiler.api.agent.ProbeObjectType;
import com.jprofiler.api.agent.ProbeValueType;
import com.jprofiler.api.agent.TrackingOptions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.CheckReturnValue;

public class ControllerImpl {
    private static final String ERROR_MESSAGE = "JProfiler> Native library not found. Ignoring controller call.";
    private static final String ERROR_MESSAGE_SESSION = "JProfiler> Profiling session must be configured. Ignoring controller call.";
    private static volatile File shutdownSnapshotFile = null;
    private static boolean publicControllerDisabled = Boolean.getBoolean("jprofiler.disableController");

    private static native void startCPURecording0(boolean var0, boolean var1);

    private static native void stopCPURecording0();

    private static native void startAllocRecording0(boolean var0);

    private static native void stopAllocRecording0();

    private static native void triggerHeapDump0(boolean var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7);

    private static native void triggerThreadDump0();

    private static native void saveSnapshot0(byte[] var0, Object var1);

    private static native void startThreadProfiling0();

    private static native void stopThreadProfiling0();

    private static native void startVMTelemetryRecording0();

    private static native void stopVMTelemetryRecording0();

    private static native void startCallTracer0(int var0, boolean var1, boolean var2);

    private static native void stopCallTracer0();

    private static native void startMonitorRecording0(int var0, int var1);

    private static native void stopMonitorRecording0();

    private static native void markHeap0();

    public static boolean isPublicControllerDisabled() {
        return publicControllerDisabled;
    }

    public static void setPublicControllerDisabled(boolean bl) {
        publicControllerDisabled = bl;
    }

    public static synchronized void startCPURecording(boolean bl) {
        ControllerImpl.startCPURecording(bl, false);
    }

    public static synchronized void startCPURecording(boolean bl, boolean bl2) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            if (bl) {
                ProbeHandler.reset();
            }
            ControllerImpl.startCPURecording0(bl, bl2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void startCPURecording(boolean bl, TrackingOptions trackingOptions) {
        i.a(trackingOptions);
        ControllerImpl.startCPURecording(bl);
    }

    public static synchronized void stopCPURecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopCPURecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void startAllocRecording(boolean bl, TrackingOptions trackingOptions) {
        i.a(trackingOptions);
        ControllerImpl.startAllocRecording(bl);
    }

    public static synchronized void startAllocRecording(boolean bl) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startAllocRecording0(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void stopAllocRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopAllocRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void addBookmark(String string) {
        ControllerImpl.addBookmark(string, null, false);
    }

    public static synchronized void addBookmark(String string, Integer n2, boolean bl) {
        if (string == null) {
            string = "";
        }
        if (n2 != null || bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{#");
            if (n2 != null) {
                stringBuilder.append(Integer.toHexString(n2 & 0xFFFFFF));
            } else {
                stringBuilder.append("none");
            }
            stringBuilder.append(',');
            stringBuilder.append(bl ? "dashed" : "solid");
            stringBuilder.append(",}");
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            Agent.addBookmark(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void triggerThreadDump() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.triggerThreadDump0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void triggerHeapDump(final HeapDumpOptions heapDumpOptions) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            Thread thread = new Thread("_jprofiler_offline_comm"){

                public void run() {
                    ControllerImpl.triggerHeapDumpInternal(heapDumpOptions);
                }
            };
            thread.start();
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static synchronized void triggerHeapDumpImmediate(HeapDumpOptions heapDumpOptions) {
        ControllerImpl.triggerHeapDumpInternal(heapDumpOptions);
    }

    private static void triggerHeapDumpInternal(HeapDumpOptions heapDumpOptions) {
        try {
            ControllerImpl.triggerHeapDump0(heapDumpOptions.isFullGc(), heapDumpOptions.isRetainSoftReferences(), heapDumpOptions.isRetainWeakReferences(), heapDumpOptions.isRetainPhantomReferences(), heapDumpOptions.isRetainFinalizerReferences(), heapDumpOptions.isSelectRecorded(), heapDumpOptions.isPrimitiveData(), heapDumpOptions.isCalculateRetainedSizes());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void markHeap() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            Thread thread = new Thread("_jprofiler_offline_comm"){

                public void run() {
                    try {
                        ControllerImpl.markHeap0();
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        System.err.println(ControllerImpl.ERROR_MESSAGE);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        System.err.println(ControllerImpl.ERROR_MESSAGE);
                    }
                }
            };
            thread.start();
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static synchronized void saveSnapshot(File file) {
        ControllerImpl.saveSnapshot(file, false);
    }

    public static synchronized File saveSnapshot(final File file, boolean bl) {
        if (file == null) {
            return null;
        }
        try {
            if (!ControllerImpl.init()) {
                return null;
            }
            if (bl) {
                return ControllerImpl.saveSnapshotNow(file);
            }
            final File[] fileArray = new File[1];
            Thread thread = new Thread("_jprofiler_offline_comm"){

                public void run() {
                    fileArray[0] = ControllerImpl.saveSnapshotNow(file);
                }
            };
            thread.start();
            thread.join();
            return fileArray[0];
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return null;
    }

    private static File saveSnapshotNow(File file) {
        if (file != null) {
            try {
                file = file.getAbsoluteFile();
                if (file.isDirectory()) {
                    file = ControllerImpl.displaySnapshotError(file, "is a directory");
                } else if (file.getParentFile() == null || !file.getParentFile().isDirectory()) {
                    file = ControllerImpl.displaySnapshotError(file, "has no existing parent directory");
                } else if (!ControllerImpl.isWritable(file)) {
                    file = ControllerImpl.displaySnapshotError(file, "cannot be written");
                }
                ControllerImpl.saveSnapshot0(ab.a(file, true), ProbeHandler.getJavaCollector());
            }
            catch (Throwable throwable) {
                System.err.println("JProfiler> Could not save snapshot");
                throwable.printStackTrace();
            }
            j.a(file);
        }
        return file;
    }

    private static boolean isWritable(File file) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.close();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static File displaySnapshotError(File file, String string) throws IOException {
        System.err.println("JProfiler> " + file.getAbsolutePath() + " " + string + ". Using temporary file.");
        file = File.createTempFile("snap", ".jps", AgentEnvironment.getTempDir());
        return file;
    }

    public static void startCallTracer(int n2, boolean bl, boolean bl2) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startCallTracer0(n2, bl, bl2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void stopCallTracer() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopCallTracer0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void setComplexityRecording(boolean bl) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            a.a(bl);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startThreadProfiling() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startThreadProfiling0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void stopThreadProfiling() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopThreadProfiling0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startMonitorRecording(int n2, int n3) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startMonitorRecording0(n2, n3);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startMonitorRecording() {
        ControllerImpl.startMonitorRecording(100, 100000);
    }

    public static void stopMonitorRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopMonitorRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startVMTelemetryRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startVMTelemetryRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void stopVMTelemetryRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopVMTelemetryRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void saveSnapshotOnExit(File file) {
        if (file == null) {
            return;
        }
        if (shutdownSnapshotFile == null) {
            shutdownSnapshotFile = file;
            Agent.setHasShutdownActions(true);
        } else {
            shutdownSnapshotFile = file;
        }
    }

    static void handleShutdownActions() {
        File file = shutdownSnapshotFile;
        if (file != null) {
            ControllerImpl.saveSnapshot(file, true);
        }
    }

    public static void startProbeRecording(String string, boolean bl, boolean ... blArray) {
        ControllerImpl.setProbeRecording(string, true, bl, blArray);
    }

    public static void stopProbeRecording(String string) {
        ControllerImpl.setProbeRecording(string, false, false, null);
    }

    public static void startProbeTracking(String string, String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType) {
        ControllerImpl.setProbeTracking(string, stringArray, probeObjectType, probeValueType, true);
    }

    public static void stopProbeTracking(String string, String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType) {
        ControllerImpl.setProbeTracking(string, stringArray, probeObjectType, probeValueType, false);
    }

    private static synchronized void setProbeTracking(String string, String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType, boolean bl) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            TrackingInfo trackingInfo = new TrackingInfo(stringArray, probeObjectType, probeValueType);
            Agent.setProbeTracking(string, trackingInfo, bl, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("JProfiler> Tracking " + (Object)((Object)probeValueType) + " of " + (Object)((Object)probeObjectType) + " for " + string + " is not available");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void setProbeRecording(String string, boolean bl, boolean bl2, boolean[] blArray) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            string = c.i(string);
            Agent.setProbeRecording(string, bl, bl2, blArray, true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    @CheckReturnValue
    private static boolean init() {
        Agent.initFromController();
        if (!com.jprofiler.agent.d.a.d) {
            System.err.println(ERROR_MESSAGE_SESSION);
            return false;
        }
        return true;
    }

    public static void enableTriggerGroup(boolean bl, String string) {
        try {
            TriggerManager.setGroupEnabled(bl, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void enableTriggers(boolean bl) {
        TriggerManager.globalEnabled = bl;
    }

    private ControllerImpl() {
    }
}

