/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TriggerUtil {
    public static final int BUFFER_SIZE = 32768;

    public static long pumpStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return TriggerUtil.pumpStream(inputStream, outputStream, Long.MAX_VALUE);
    }

    public static long pumpStream(InputStream inputStream, OutputStream outputStream, long l2) throws IOException {
        int n2;
        long l3;
        int n3;
        byte[] byArray = new byte[32768];
        for (l3 = 0L; l3 < l2 && (n2 = inputStream.read(byArray)) != -1; l3 += (long)n3) {
            n3 = (int)Math.min((long)n2, l2 - l3);
            outputStream.write(byArray, 0, n3);
        }
        return l3;
    }

    public static byte[] readFile(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)file.length());
        FileInputStream fileInputStream = new FileInputStream(file);
        TriggerUtil.pumpStream(fileInputStream, byteArrayOutputStream);
        fileInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeFile(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        TriggerUtil.pumpStream(new ByteArrayInputStream(byArray), fileOutputStream);
        fileOutputStream.close();
    }

    public static String getSnapshotFilename(String string, String string2, boolean bl) {
        if ((string = string.trim()).equals("")) {
            string = "dump";
        }
        if (!string.endsWith(string2)) {
            string = string + string2;
        }
        if (bl) {
            String string3 = string.substring(0, string.length() - string2.length());
            int n2 = 0;
            do {
                string = string3 + "." + n2 + string2;
                ++n2;
            } while (new File(string).exists());
        }
        return string;
    }
}

