/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.triggers.RuntimeTrigger;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class OOMTrigger
extends RuntimeTrigger {
    private static boolean messageShown = false;

    private static void setGuarded(boolean bl) {
        try {
            OOMTrigger.set(bl);
            return;
        }
        catch (Throwable throwable) {
            if (messageShown) {
                return;
            }
            System.err.println("JProfiler> **********************************************************");
            System.err.println("JProfiler> WARNING: Could not set the OutOfMemory trigger");
            System.err.println("JProfiler> programmatically. This is only possible on Hotspot VMs ");
            System.err.println("JProfiler> with MBean support.");
            System.err.println("JProfiler> **********************************************************");
            messageShown = true;
            return;
        }
    }

    private static void set(boolean bl) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        mBeanServer.invoke(objectName, "setVMOption", new Object[]{"HeapDumpOnOutOfMemoryError", bl ? "true" : "false"}, new String[]{"java.lang.String", "java.lang.String"});
    }

    public OOMTrigger(XMLElement xMLElement) throws IOException {
        super(xMLElement);
    }

    @Override
    protected void changeEnabled(boolean bl) {
        OOMTrigger.setGuarded(bl);
    }
}

