/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.ejt.internal.io.StreamConsumerThread;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;

public class Execution {
    public static boolean executeAndWait(String[] command, StringBuffer output) throws IOException {
        return Execution.executeWithReturnCode(command, output, false) == 0;
    }

    public static int executeWithReturnCode(String[] command, StringBuffer output, boolean utf8) throws IOException {
        return Execution.executeWithReturnCode(command, output, output, utf8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeWithReturnCode(String[] command, StringBuffer output, StringBuffer error, boolean utf8) throws IOException {
        if (!InstallerUtil.isWindows() && Boolean.getBoolean("install4j.executionWithScript")) {
            File scriptFile = File.createTempFile("i4j", ".sh");
            try {
                Process process = Execution.executeWithScript(command, scriptFile);
                int n = Execution.handleProcess(process, output, error, utf8);
                return n;
            }
            finally {
                scriptFile.delete();
            }
        }
        Process process = new ProcessBuilder(command).start();
        return Execution.handleProcess(process, output, error, utf8);
    }

    public static Result executeAndWaitWithResult(String ... command) {
        try {
            StringBuffer output = new StringBuffer();
            StringBuffer error = new StringBuffer();
            int returnCode = Execution.executeWithReturnCode(command, output, error, false);
            return new Result(returnCode, output.toString(), error.toString());
        }
        catch (IOException e) {
            return new Result(5000, "", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int handleProcess(Process process, StringBuffer output, StringBuffer error, boolean utf8) throws IOException {
        try {
            StreamConsumerThread.consumeOutput(process, output, error, utf8);
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            int n = 1;
            return n;
        }
        finally {
            process.destroy();
        }
    }

    private static Process executeWithScript(String[] command, File scriptFile) throws IOException {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(scriptFile)), StandardCharsets.UTF_8));){
            pw.println("#!/bin/sh");
            for (int i = 0; i < command.length; ++i) {
                pw.print("\"" + command[i] + "\"");
                if (i >= command.length - 1) continue;
                pw.print(" ");
            }
            pw.println();
        }
        String[] cmd = new String[]{"/bin/sh", scriptFile.getAbsolutePath()};
        return new ProcessBuilder(cmd).start();
    }

    public static class Result {
        public final int returnCode;
        public final String output;
        public final String error;

        public Result(int returnCode, String output, String error) {
            this.returnCode = returnCode;
            this.output = output;
            this.error = error;
        }

        public boolean isSuccess() {
            return this.returnCode == 0;
        }

        public String toString() {
            return "Result{returnCode=" + this.returnCode + ", output='" + this.output + '\'' + ", error='" + this.error + '\'' + '}';
        }
    }
}

