/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.integration;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class FirstRun {
    private static final boolean DEBUG = Boolean.getBoolean("install4j.debugFirstRun");
    private static final String FIRST_RUN_NODE_INTERNAL = "/com/install4j/firstrun/internal";
    private static final String FIRST_RUN_NODE_USER = "/com/install4j/firstrun/user";
    private static boolean[] firstRunCache = new boolean[2];

    public static synchronized boolean isFirstRun(boolean internal) {
        block6: {
            String uuid;
            int cacheIndex;
            int n = cacheIndex = internal ? 0 : 1;
            if (firstRunCache[cacheIndex]) {
                return true;
            }
            File runtimeDir = ResourceHelper.getRuntimeDir();
            if (runtimeDir == null) {
                return false;
            }
            File uuidFile = new File(runtimeDir, "build.uuid");
            if (uuidFile.isFile() && (uuid = FirstRun.readUUID(uuidFile)) != null) {
                try {
                    String pathHash = FirstRun.encodeSha1(MessageDigest.getInstance("SHA-1").digest(FileUtil.getCanonicalPath(runtimeDir).getBytes(StandardCharsets.UTF_8)));
                    InstallerUtil.disablePreferencesLogging();
                    Preferences root = Preferences.userRoot();
                    root.sync();
                    Preferences firstRunNode = root.node(internal ? FIRST_RUN_NODE_INTERNAL : FIRST_RUN_NODE_USER);
                    if (!Objects.equals(firstRunNode.get(pathHash, ""), uuid)) {
                        firstRunNode.put(pathHash, uuid);
                        root.flush();
                        FirstRun.firstRunCache[cacheIndex] = true;
                        return true;
                    }
                }
                catch (NoSuchAlgorithmException | BackingStoreException e) {
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private static String encodeSha1(byte[] digest) {
        StringBuilder builder = new StringBuilder();
        for (byte b : digest) {
            String str = Integer.toString(b & 0xFF, 16);
            if (str.length() == 1) {
                builder.append('0');
            }
            builder.append(str);
        }
        return builder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readUUID(File uuidFile) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(uuidFile), StandardCharsets.UTF_8));){
            String string = reader.readLine();
            return string;
        }
        catch (Throwable t) {
            if (!DEBUG) return null;
            t.printStackTrace();
            return null;
        }
    }
}

