/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MacosJVMLocator {
    private static final String OLD_APPLE_ROOT_LOCATION = "/System/Library/Frameworks/JavaVM.framework/Versions";
    public static final String OLD_APPLE_HOME_DIR = "Home";
    private static final String[] OLD_APPLE_JDK_FILES = new String[]{"Commands/javac", "Home/src.jar"};
    private static final String OLD_APPLE_JAVA_EXECUTABLE = "Commands/java";
    private static final String NEW_APPLE_ROOT_LOCATIONS = "/System/Library/Java/JavaVirtualMachines";
    private static final String NEW_HOME_DIR = "Contents/Home";
    private static final String[] NEW_JDK_FILES = new String[]{"Contents/Home/bin/javac"};
    private static final String NEW_JAVA_EXECUTABLE = "Contents/Home/bin/java";
    private static final String ORACLE_ROOT_LOCATIONS = "/Library/Java/JavaVirtualMachines";
    private static final String JRE_PLUGIN = "/Library/Internet Plug-Ins/JavaAppletPlugin.plugin";

    public static Collection<JVMLocator.JVMLocation> getJVMLocations() {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        MacosJVMLocator.addJVMs(ret, NEW_APPLE_ROOT_LOCATIONS, NEW_JAVA_EXECUTABLE, NEW_JDK_FILES, NEW_HOME_DIR);
        if (ret.isEmpty()) {
            MacosJVMLocator.addJVMs(ret, OLD_APPLE_ROOT_LOCATION, OLD_APPLE_JAVA_EXECUTABLE, OLD_APPLE_JDK_FILES, OLD_APPLE_HOME_DIR);
        }
        MacosJVMLocator.addJVMs(ret, ORACLE_ROOT_LOCATIONS, NEW_JAVA_EXECUTABLE, NEW_JDK_FILES, NEW_HOME_DIR);
        MacosJVMLocator.checkBundle(ret, new File(JRE_PLUGIN), NEW_JAVA_EXECUTABLE, NEW_JDK_FILES, NEW_HOME_DIR);
        return ret;
    }

    private static void addJVMs(Set<JVMLocator.JVMLocation> ret, String rootLocation, String javaExecutable, String[] jdkFiles, String homeDir) {
        File[] files = new File(rootLocation).listFiles();
        if (files != null) {
            for (File file : files) {
                MacosJVMLocator.checkBundle(ret, file, javaExecutable, jdkFiles, homeDir);
            }
        }
    }

    private static void checkBundle(Set<JVMLocator.JVMLocation> ret, File bundleDir, String javaExecutable, String[] jdkFiles, String homeDir) {
        if (bundleDir.isDirectory()) {
            try {
                JVMLocator.JVMLocation jvmLocation = JVMLocator.checkJVMLocation(bundleDir, javaExecutable, jdkFiles);
                if (jvmLocation != null && jvmLocation.getJavaHome() != null) {
                    jvmLocation.setJavaHome(new File(jvmLocation.getJavaHome(), homeDir));
                    ret.add(jvmLocation);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static JVMLocator.JVMLocation getJVMLocation(File javaHome) throws IOException {
        JVMLocator.JVMLocation jvmLocation = JVMLocator.checkJVMLocation(javaHome = MacosJVMLocator.stripContentsHome(javaHome), NEW_JAVA_EXECUTABLE, NEW_JDK_FILES);
        if (jvmLocation != null) {
            jvmLocation.setJavaHome(new File(jvmLocation.getJavaHome(), NEW_HOME_DIR));
        } else {
            jvmLocation = JVMLocator.checkJVMLocation(javaHome, OLD_APPLE_JAVA_EXECUTABLE, OLD_APPLE_JDK_FILES);
            if (jvmLocation != null) {
                jvmLocation.setJavaHome(new File(jvmLocation.getJavaHome(), OLD_APPLE_HOME_DIR));
            }
        }
        return jvmLocation;
    }

    private static File stripContentsHome(File javaHome) {
        if (javaHome == null) {
            return null;
        }
        String path = javaHome.getPath();
        if (path.endsWith("/Contents/Home/jre")) {
            return javaHome.getParentFile().getParentFile().getParentFile();
        }
        if (path.endsWith("/Contents/Home")) {
            return javaHome.getParentFile().getParentFile();
        }
        return javaHome;
    }
}

