/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.nanoxml;

import com.jprofiler.agent.triggers.nanoxml.XMLParseException;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XMLElement {
    static final long serialVersionUID = 6685035139346394777L;
    public static final int NANOXML_MAJOR_VERSION = 2;
    public static final int NANOXML_MINOR_VERSION = 2;
    private Hashtable<String, String> attributes;
    private Vector<XMLElement> children;
    private String name;
    private String contents;
    private Hashtable<String, Object> entities;
    private int lineNr;
    private boolean ignoreCase;
    private boolean ignoreWhitespace;
    private char charReadTooMuch;
    private Reader reader;
    private int parserLineNr;

    public XMLElement() {
        this(new Hashtable<String, Object>(), false, true, true);
    }

    public XMLElement(Hashtable<String, Object> hashtable) {
        this(hashtable, false, true, true);
    }

    public XMLElement(boolean bl) {
        this(new Hashtable<String, Object>(), bl, true, true);
    }

    public XMLElement(Hashtable<String, Object> hashtable, boolean bl) {
        this(hashtable, bl, true, true);
    }

    public XMLElement(Hashtable<String, Object> hashtable, boolean bl, boolean bl2) {
        this(hashtable, bl, true, bl2);
    }

    protected XMLElement(Hashtable<String, Object> hashtable, boolean bl, boolean bl2, boolean bl3) {
        this.ignoreWhitespace = bl;
        this.ignoreCase = bl3;
        this.name = null;
        this.contents = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.entities = hashtable;
        this.lineNr = 0;
        Enumeration<String> enumeration = this.entities.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Object object = this.entities.get(string);
            if (!(object instanceof String)) continue;
            object = ((String)object).toCharArray();
            this.entities.put(string, object);
        }
        if (bl2) {
            this.entities.put("amp", new char[]{'&'});
            this.entities.put("quot", new char[]{'\"'});
            this.entities.put("apos", new char[]{'\''});
            this.entities.put("lt", new char[]{'<'});
            this.entities.put("gt", new char[]{'>'});
        }
    }

    public void addChild(XMLElement xMLElement) {
        this.children.addElement(xMLElement);
    }

    public void setAttribute(String string, Object object) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, object.toString());
    }

    public void addProperty(String string, Object object) {
        this.setAttribute(string, object);
    }

    public void setIntAttribute(String string, int n2) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, Integer.toString(n2));
    }

    public void addProperty(String string, int n2) {
        this.setIntAttribute(string, n2);
    }

    public void setDoubleAttribute(String string, double d2) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.put(string, Double.toString(d2));
    }

    public void addProperty(String string, double d2) {
        this.setDoubleAttribute(string, d2);
    }

    public int countChildren() {
        return this.children.size();
    }

    public Enumeration enumerateAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration enumeratePropertyNames() {
        return this.enumerateAttributeNames();
    }

    public Enumeration enumerateChildren() {
        return this.children.elements();
    }

    public Vector getChildren() {
        try {
            return (Vector)this.children.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContents() {
        return this.getContent();
    }

    public String getContent() {
        return this.contents;
    }

    public int getLineNr() {
        return this.lineNr;
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, null);
    }

    public Object getAttribute(String string, Object object) {
        Object object2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((object2 = this.attributes.get(string)) == null) {
            object2 = object;
        }
        return object2;
    }

    public Object getAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Object object;
        String string3;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string3 = this.attributes.get(string)) == null) {
            string3 = string2;
        }
        if ((object = hashtable.get(string3)) == null) {
            if (bl) {
                object = string3;
            } else {
                throw this.invalidValue(string, string3);
            }
        }
        return object;
    }

    public String getStringAttribute(String string) {
        return this.getStringAttribute(string, null);
    }

    public String getStringAttribute(String string, String string2) {
        return (String)this.getAttribute(string, string2);
    }

    public String getStringAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        return (String)this.getAttribute(string, hashtable, string2, bl);
    }

    public int getIntAttribute(String string) {
        return this.getIntAttribute(string, 0);
    }

    public int getIntAttribute(String string, int n2) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = this.attributes.get(string)) == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2);
        }
    }

    public int getIntAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Integer n2;
        String string3;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string3 = this.attributes.get(string)) == null) {
            string3 = string2;
        }
        try {
            n2 = (Integer)hashtable.get(string3);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (n2 == null) {
            if (!bl) {
                throw this.invalidValue(string, string3);
            }
            try {
                n2 = Integer.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, string3);
            }
        }
        return n2;
    }

    public double getDoubleAttribute(String string) {
        return this.getDoubleAttribute(string, 0.0);
    }

    public double getDoubleAttribute(String string, double d2) {
        String string2;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string2 = this.attributes.get(string)) == null) {
            return d2;
        }
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(string, string2);
        }
    }

    public double getDoubleAttribute(String string, Hashtable hashtable, String string2, boolean bl) {
        Double d2;
        String string3;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string3 = this.attributes.get(string)) == null) {
            string3 = string2;
        }
        try {
            d2 = (Double)hashtable.get(string3);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(string);
        }
        if (d2 == null) {
            if (!bl) {
                throw this.invalidValue(string, string3);
            }
            try {
                d2 = Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(string, string3);
            }
        }
        return d2;
    }

    public boolean getBooleanAttribute(String string, String string2, String string3, boolean bl) {
        String string4;
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        if ((string4 = this.attributes.get(string)) == null) {
            return bl;
        }
        if (string4.equals(string2)) {
            return true;
        }
        if (string4.equals(string3)) {
            return false;
        }
        throw this.invalidValue(string, string4);
    }

    public boolean getBooleanAttribute(String string, boolean bl) {
        return this.getBooleanAttribute(string, "true", "false", bl);
    }

    public int getIntProperty(String string, Hashtable hashtable, String string2) {
        return this.getIntAttribute(string, hashtable, string2, false);
    }

    public String getProperty(String string) {
        return this.getStringAttribute(string);
    }

    public String getProperty(String string, String string2) {
        return this.getStringAttribute(string, string2);
    }

    public int getProperty(String string, int n2) {
        return this.getIntAttribute(string, n2);
    }

    public double getProperty(String string, double d2) {
        return this.getDoubleAttribute(string, d2);
    }

    public boolean getProperty(String string, String string2, String string3, boolean bl) {
        return this.getBooleanAttribute(string, string2, string3, bl);
    }

    public Object getProperty(String string, Hashtable hashtable, String string2) {
        return this.getAttribute(string, hashtable, string2, false);
    }

    public String getStringProperty(String string, Hashtable hashtable, String string2) {
        return this.getStringAttribute(string, hashtable, string2, false);
    }

    public int getSpecialIntProperty(String string, Hashtable hashtable, String string2) {
        return this.getIntAttribute(string, hashtable, string2, true);
    }

    public double getSpecialDoubleProperty(String string, Hashtable hashtable, String string2) {
        return this.getDoubleAttribute(string, hashtable, string2, true);
    }

    public String getName() {
        return this.name;
    }

    public String getTagName() {
        return this.getName();
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int n2) throws IOException, XMLParseException {
        char c2;
        this.name = null;
        this.contents = "";
        this.attributes = new Hashtable();
        this.children = new Vector();
        this.charReadTooMuch = '\u0000';
        this.reader = reader;
        this.parserLineNr = n2;
        while (true) {
            if ((c2 = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            c2 = this.readChar();
            if (c2 != '!' && c2 != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(c2);
        this.scanElement(this);
    }

    public void parseString(String string) throws XMLParseException {
        try {
            this.parseFromReader(new StringReader(string), 1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseString(String string, int n2) throws XMLParseException {
        this.parseString(string.substring(n2));
    }

    public void parseString(String string, int n2, int n3) throws XMLParseException {
        this.parseString(string.substring(n2, n3));
    }

    public void parseString(String string, int n2, int n3, int n4) throws XMLParseException {
        string = string.substring(n2, n3);
        try {
            this.parseFromReader(new StringReader(string), n4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void parseCharArray(char[] cArray, int n2, int n3) throws XMLParseException {
        this.parseCharArray(cArray, n2, n3, 1);
    }

    public void parseCharArray(char[] cArray, int n2, int n3, int n4) throws XMLParseException {
        try {
            CharArrayReader charArrayReader = new CharArrayReader(cArray, n2, n3);
            this.parseFromReader(charArrayReader, n4);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeChild(XMLElement xMLElement) {
        this.children.removeElement(xMLElement);
    }

    public void removeAttribute(String string) {
        if (this.ignoreCase) {
            string = string.toUpperCase();
        }
        this.attributes.remove(string);
    }

    public void removeProperty(String string) {
        this.removeAttribute(string);
    }

    public void removeChild(String string) {
        this.removeAttribute(string);
    }

    protected XMLElement createAnotherElement() {
        return new XMLElement(this.entities, this.ignoreWhitespace, false, this.ignoreCase);
    }

    public void setContent(String string) {
        this.contents = string;
    }

    public void setTagName(String string) {
        this.setName(string);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public void write(Writer writer) throws IOException {
        Object object;
        Enumeration enumeration;
        if (this.name == null) {
            this.writeEncoded(writer, this.contents);
            return;
        }
        writer.write(60);
        writer.write(this.name);
        if (!this.attributes.isEmpty()) {
            enumeration = this.attributes.keys();
            while (enumeration.hasMoreElements()) {
                writer.write(32);
                object = enumeration.nextElement();
                String string = this.attributes.get(object);
                writer.write(((String)object).toLowerCase());
                writer.write(61);
                writer.write(34);
                this.writeEncoded(writer, string);
                writer.write(34);
            }
        }
        if (this.contents != null && this.contents.length() > 0) {
            writer.write(62);
            this.writeEncoded(writer, this.contents);
            writer.write(60);
            writer.write(47);
            writer.write(this.name);
            writer.write(62);
        } else if (this.children.isEmpty()) {
            writer.write(47);
            writer.write(62);
        } else {
            writer.write(62);
            enumeration = this.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                object = (XMLElement)enumeration.nextElement();
                ((XMLElement)object).write(writer);
            }
            writer.write(60);
            writer.write(47);
            writer.write(this.name);
            writer.write(62);
        }
    }

    protected void writeEncoded(Writer writer, String string) throws IOException {
        block7: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    writer.write(38);
                    writer.write(108);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '>': {
                    writer.write(38);
                    writer.write(103);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '&': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(109);
                    writer.write(112);
                    writer.write(59);
                    continue block7;
                }
                case '\"': {
                    writer.write(38);
                    writer.write(113);
                    writer.write(117);
                    writer.write(111);
                    writer.write(116);
                    writer.write(59);
                    continue block7;
                }
                case '\'': {
                    writer.write(38);
                    writer.write(97);
                    writer.write(112);
                    writer.write(111);
                    writer.write(115);
                    writer.write(59);
                    continue block7;
                }
                default: {
                    char c3 = c2;
                    if (c3 < ' ' || c3 > '~') {
                        writer.write(38);
                        writer.write(35);
                        writer.write(120);
                        writer.write(Integer.toString(c3, 16));
                        writer.write(59);
                        continue block7;
                    }
                    writer.write(c2);
                }
            }
        }
    }

    protected void scanIdentifier(StringBuilder stringBuilder) throws IOException {
        while (true) {
            char c2;
            if (!((c2 = this.readChar()) >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.' || c2 == ':' || c2 == '-' || c2 > '~')) {
                this.unreadChar(c2);
                return;
            }
            stringBuilder.append(c2);
        }
    }

    protected char scanWhitespace() throws IOException {
        char c2;
        block3: while (true) {
            c2 = this.readChar();
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return c2;
    }

    protected char scanWhitespace(StringBuilder stringBuilder) throws IOException {
        char c2;
        block4: while (true) {
            c2 = this.readChar();
            switch (c2) {
                case '\t': 
                case '\n': 
                case ' ': {
                    stringBuilder.append(c2);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return c2;
    }

    protected void scanString(StringBuilder stringBuilder) throws IOException {
        char c2 = this.readChar();
        if (c2 != '\'' && c2 != '\"') {
            throw this.expectedInput("' or \"");
        }
        char c3;
        while ((c3 = this.readChar()) != c2) {
            if (c3 == '&') {
                this.resolveEntity(stringBuilder);
                continue;
            }
            stringBuilder.append(c3);
        }
        return;
    }

    protected void scanPCData(StringBuilder stringBuilder) throws IOException {
        while (true) {
            char c2;
            if ((c2 = this.readChar()) == '<') {
                c2 = this.readChar();
                if (c2 == '!') {
                    this.checkCDATA(stringBuilder);
                    continue;
                }
                this.unreadChar(c2);
                return;
            }
            if (c2 == '&') {
                this.resolveEntity(stringBuilder);
                continue;
            }
            stringBuilder.append(c2);
        }
    }

    protected boolean checkCDATA(StringBuilder stringBuilder) throws IOException {
        char c2 = this.readChar();
        if (c2 != '[') {
            this.unreadChar(c2);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int n2 = 0;
        block4: while (n2 < 3) {
            int n3;
            c2 = this.readChar();
            switch (c2) {
                case ']': {
                    if (n2 < 2) {
                        ++n2;
                        continue block4;
                    }
                    stringBuilder.append(']');
                    stringBuilder.append(']');
                    n2 = 0;
                    continue block4;
                }
                case '>': {
                    if (n2 < 2) {
                        for (n3 = 0; n3 < n2; ++n3) {
                            stringBuilder.append(']');
                        }
                        n2 = 0;
                        stringBuilder.append('>');
                        continue block4;
                    }
                    n2 = 3;
                    continue block4;
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuilder.append(']');
            }
            stringBuilder.append(c2);
            n2 = 0;
        }
        return true;
    }

    protected void skipComment() throws IOException {
        int n2 = 2;
        while (n2 > 0) {
            char c2 = this.readChar();
            if (c2 == '-') {
                --n2;
                continue;
            }
            n2 = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void skipSpecialTag(int n2) throws IOException {
        char c2;
        int n3 = 1;
        char c3 = '\u0000';
        if (n2 == 0) {
            c2 = this.readChar();
            if (c2 == '[') {
                ++n2;
            } else if (c2 == '-') {
                c2 = this.readChar();
                if (c2 == '[') {
                    ++n2;
                } else if (c2 == ']') {
                    --n2;
                } else if (c2 == '-') {
                    this.skipComment();
                    return;
                }
            }
        }
        while (n3 > 0) {
            c2 = this.readChar();
            if (c3 == '\u0000') {
                if (c2 == '\"' || c2 == '\'') {
                    c3 = c2;
                } else if (n2 <= 0) {
                    if (c2 == '<') {
                        ++n3;
                    } else if (c2 == '>') {
                        --n3;
                    }
                }
                if (c2 == '[') {
                    ++n2;
                    continue;
                }
                if (c2 != ']') continue;
                --n2;
                continue;
            }
            if (c2 != c3) continue;
            c3 = '\u0000';
        }
    }

    protected boolean checkLiteral(String string) throws IOException {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.readChar() == string.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    protected char readChar() throws IOException {
        if (this.charReadTooMuch != '\u0000') {
            char c2 = this.charReadTooMuch;
            this.charReadTooMuch = '\u0000';
            return c2;
        }
        int n2 = this.reader.read();
        if (n2 < 0) {
            throw this.unexpectedEndOfData();
        }
        if (n2 == 10) {
            ++this.parserLineNr;
            return '\n';
        }
        return (char)n2;
    }

    protected void scanElement(XMLElement xMLElement) throws IOException {
        Object object;
        char c2;
        String string;
        StringBuilder stringBuilder;
        block24: {
            stringBuilder = new StringBuilder();
            this.scanIdentifier(stringBuilder);
            string = stringBuilder.toString();
            xMLElement.setName(string);
            c2 = this.scanWhitespace();
            while (c2 != '>' && c2 != '/') {
                stringBuilder.setLength(0);
                this.unreadChar(c2);
                this.scanIdentifier(stringBuilder);
                object = stringBuilder.toString();
                c2 = this.scanWhitespace();
                if (c2 != '=') {
                    throw this.expectedInput("=");
                }
                this.unreadChar(this.scanWhitespace());
                stringBuilder.setLength(0);
                this.scanString(stringBuilder);
                xMLElement.setAttribute((String)object, stringBuilder);
                c2 = this.scanWhitespace();
            }
            if (c2 == '/') {
                c2 = this.readChar();
                if (c2 != '>') {
                    throw this.expectedInput(">");
                }
                return;
            }
            stringBuilder.setLength(0);
            c2 = this.scanWhitespace(stringBuilder);
            if (c2 != '<') {
                this.unreadChar(c2);
                this.scanPCData(stringBuilder);
            } else {
                while ((c2 = this.readChar()) == '!') {
                    if (this.checkCDATA(stringBuilder)) {
                        this.scanPCData(stringBuilder);
                    } else {
                        c2 = this.scanWhitespace(stringBuilder);
                        if (c2 == '<') continue;
                        this.unreadChar(c2);
                        this.scanPCData(stringBuilder);
                    }
                    break block24;
                }
                if (c2 != '/' || this.ignoreWhitespace) {
                    stringBuilder.setLength(0);
                }
                if (c2 == '/') {
                    this.unreadChar(c2);
                }
            }
        }
        if (stringBuilder.length() == 0) {
            while (c2 != '/') {
                if (c2 == '!') {
                    c2 = this.readChar();
                    if (c2 != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    c2 = this.readChar();
                    if (c2 != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(c2);
                    object = this.createAnotherElement();
                    this.scanElement((XMLElement)object);
                    xMLElement.addChild((XMLElement)object);
                }
                c2 = this.scanWhitespace();
                if (c2 != '<') {
                    throw this.expectedInput("<");
                }
                c2 = this.readChar();
            }
            this.unreadChar(c2);
        } else if (this.ignoreWhitespace) {
            xMLElement.setContent(stringBuilder.toString().trim());
        } else {
            xMLElement.setContent(stringBuilder.toString());
        }
        c2 = this.readChar();
        if (c2 != '/') {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(string)) {
            throw this.expectedInput(string);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void resolveEntity(StringBuilder stringBuilder) throws IOException {
        char c2 = '\u0000';
        StringBuilder stringBuilder2 = new StringBuilder();
        while ((c2 = this.readChar()) != ';') {
            stringBuilder2.append(c2);
        }
        String string = stringBuilder2.toString();
        if (string.charAt(0) == '#') {
            try {
                c2 = string.charAt(1) == 'x' ? (char)Integer.parseInt(string.substring(2), 16) : (char)Integer.parseInt(string.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity(string);
            }
            stringBuilder.append(c2);
        } else {
            char[] cArray = (char[])this.entities.get(string);
            if (cArray == null) {
                throw this.unknownEntity(string);
            }
            stringBuilder.append(cArray);
        }
    }

    protected void unreadChar(char c2) {
        this.charReadTooMuch = c2;
    }

    protected XMLParseException invalidValueSet(String string) {
        String string2 = "Invalid value set (entity name = \"" + string + "\")";
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException invalidValue(String string, String string2) {
        String string3 = "Attribute \"" + string + "\" does not contain a valid value (\"" + string2 + "\")";
        return new XMLParseException(this.getName(), this.parserLineNr, string3);
    }

    protected XMLParseException unexpectedEndOfData() {
        String string = "Unexpected end of data reached";
        return new XMLParseException(this.getName(), this.parserLineNr, string);
    }

    protected XMLParseException syntaxError(String string) {
        String string2 = "Syntax error while parsing " + string;
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException expectedInput(String string) {
        String string2 = "Expected: " + string;
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }

    protected XMLParseException unknownEntity(String string) {
        String string2 = "Unknown or invalid entity: &" + string + ";";
        return new XMLParseException(this.getName(), this.parserLineNr, string2);
    }
}

