/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers;

import com.jprofiler.agent.d.b;
import com.jprofiler.agent.d.c;
import com.jprofiler.agent.d.d;
import com.jprofiler.agent.probe.h.a;
import com.jprofiler.agent.probe.h.e;
import com.jprofiler.agent.triggers.JvmStartTrigger;
import com.jprofiler.agent.triggers.JvmStopTrigger;
import com.jprofiler.agent.triggers.MethodTrigger;
import com.jprofiler.agent.triggers.OOMTrigger;
import com.jprofiler.agent.triggers.RuntimeTrigger;
import com.jprofiler.agent.triggers.ThresholdManager;
import com.jprofiler.agent.triggers.TimerTrigger;
import com.jprofiler.agent.triggers.TriggerLog;
import com.jprofiler.agent.triggers.TriggerTarget;
import com.jprofiler.agent.triggers.actions.ImmediateAction;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import com.jprofiler.agent.util.a.b.aa;
import com.jprofiler.agent.util.a.b.y;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TriggerManager {
    public static final a INTERCEPTOR = new a();
    private static List<RuntimeTrigger> triggers;
    public static boolean globalEnabled;

    public static void reset() {
        INTERCEPTOR.a();
        ThresholdManager.clearTriggers();
        if (triggers != null) {
            for (RuntimeTrigger runtimeTrigger : triggers) {
                runtimeTrigger.stop();
            }
        }
    }

    public static void readTriggers(XMLElement xMLElement, boolean bl) throws IOException {
        TriggerLog.init(xMLElement);
        TriggerManager.readEvents(xMLElement, bl);
    }

    private static void readEvents(XMLElement xMLElement, boolean bl) throws IOException {
        triggers = new ArrayList<RuntimeTrigger>();
        aa<e[]> aa2 = new aa<e[]>();
        if (xMLElement != null) {
            Vector vector = xMLElement.getChildren();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                XMLElement xMLElement2 = (XMLElement)vector.get(i2);
                String string = xMLElement2.getName();
                RuntimeTrigger runtimeTrigger = string.equals("methodInvocation") ? TriggerManager.createMethodTrigger(xMLElement2, aa2) : (string.equals("timer") ? new TimerTrigger(xMLElement2) : (string.equals("oom") ? new OOMTrigger(xMLElement2) : (string.equals("jvmStart") ? new JvmStartTrigger(xMLElement2, bl) : (string.equals("jvmStop") ? new JvmStopTrigger(xMLElement2) : ThresholdManager.createTrigger(xMLElement2)))));
                if (runtimeTrigger == null) {
                    System.err.println("JProfiler> unknown trigger event " + string);
                    continue;
                }
                triggers.add(runtimeTrigger);
            }
            INTERCEPTOR.a(aa2);
        }
    }

    private static RuntimeTrigger createMethodTrigger(XMLElement xMLElement, y<e[]> y2) throws IOException {
        MethodTrigger methodTrigger = new MethodTrigger(xMLElement);
        XMLElement xMLElement2 = b.a(xMLElement, "methods");
        if (xMLElement2 != null) {
            Vector vector = xMLElement2.getChildren();
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                XMLElement xMLElement3 = (XMLElement)vector.get(i2);
                c c2 = new c(xMLElement3);
                int n2 = d.a(c2);
                if (n2 == 0) continue;
                a.a(y2, n2, new TriggerTarget(c2, methodTrigger.getActionChain()));
            }
        }
        return methodTrigger;
    }

    public static synchronized void handleShutdownActions() {
        if (com.jprofiler.agent.d.a.d && triggers != null) {
            for (RuntimeTrigger runtimeTrigger : triggers) {
                if (!(runtimeTrigger instanceof JvmStopTrigger) || !runtimeTrigger.isEnabled()) continue;
                TriggerManager.executeNoMethodActions(runtimeTrigger.getActions(), true);
            }
        }
    }

    public static synchronized void setGroupEnabled(boolean bl, String string) {
        if (com.jprofiler.agent.d.a.d && triggers != null) {
            boolean bl2 = false;
            for (RuntimeTrigger runtimeTrigger : triggers) {
                if (!runtimeTrigger.getUsedGroupId().equals(string)) continue;
                runtimeTrigger.setEnabled(bl);
                bl2 = true;
            }
            if (!bl2) {
                throw new IllegalArgumentException("No trigger with group ID " + string + " was found.");
            }
        }
    }

    public static long getTimeMillis(int n2, String string) {
        if (string.equals("h")) {
            return (long)n2 * 60L * 60L * 1000L;
        }
        if (string.equals("m")) {
            return (long)n2 * 60L * 1000L;
        }
        return (long)n2 * 1000L;
    }

    private static void executeNoMethodActions(List<TriggerAction> list, boolean bl) {
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                TriggerAction triggerAction = list.get(i2);
                if (bl && triggerAction instanceof ImmediateAction) {
                    ((ImmediateAction)((Object)triggerAction)).executeImmediate();
                    continue;
                }
                triggerAction.execute(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void executeNoMethodActions(List<TriggerAction> list) {
        TriggerManager.executeNoMethodActions(list, false);
    }

    static {
        globalEnabled = true;
    }
}

