/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher.service;

import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.launcher.service.CommonHandler;
import com.install4j.runtime.launcher.util.LauncherUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;

public class LockHandler
extends CommonHandler {
    private static final boolean PUBLIC_SERVICE_STATUS = Boolean.parseBoolean(System.getProperty("install4j.publicServiceStatus", "true"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isRunning() {
        File watcherFile = this.getWatcherFile();
        if (watcherFile.exists()) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(watcherFile, "r");
                FileLock fileLock = randomAccessFile.getChannel().tryLock(0L, Long.MAX_VALUE, true);
                boolean bl = fileLock == null;
                return bl;
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not determine status of " + this.getDaemonName() + ". Exiting. Id file: " + watcherFile);
                System.exit(1);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return false;
    }

    @Override
    protected void finishStartFileCreation(File watcherFile, DataOutputStream out, FileOutputStream fout) throws IOException {
        out.flush();
        if (PUBLIC_SERVICE_STATUS && !LauncherUtil.isWindows()) {
            UnixFileSystem.setMode("+r", watcherFile);
        }
        try {
            FileLock fileLock = fout.getChannel().tryLock();
            if (fileLock == null) {
                throw new IOException("could not lock file");
            }
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            // empty catch block
        }
    }

    @Override
    protected void updateWatcherFile(File watcherFile) {
    }
}

