/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.platform.unix.UnixConfigFile;
import org.jetbrains.annotations.Nullable;

public class ServiceFile
extends UnixConfigFile {
    private static final String GROUP_UNIT = "Unit";
    private static final String GROUP_SERVICE = "Service";
    private static final String GROUP_INSTALL = "Install";

    @Override
    @Nullable
    protected UnixConfigFile.Group getMainGroup() {
        return null;
    }

    @Override
    protected boolean isUniqueKeys() {
        return false;
    }

    public static ServiceFile createForUser(String commandLine, String description, boolean useExec, boolean graphicalOnly) {
        ServiceFile serviceFile = new ServiceFile();
        serviceFile.add(GROUP_UNIT, "Description", description);
        if (graphicalOnly) {
            serviceFile.add(GROUP_UNIT, "After", "graphical-session.target");
            serviceFile.add(GROUP_UNIT, "Wants", "graphical-session.target");
        }
        serviceFile.addServiceGroup(commandLine, useExec);
        serviceFile.add(GROUP_INSTALL, "WantedBy", graphicalOnly ? "graphical-session.target" : "default.target");
        return serviceFile;
    }

    public static ServiceFile createForServiceLauncher(String target, String description, boolean useExec) {
        ServiceFile serviceFile = new ServiceFile();
        String wantedBy = "multi-user.target graphical.target";
        serviceFile.add(GROUP_UNIT, "Description", description);
        serviceFile.add(GROUP_UNIT, "Before", wantedBy);
        serviceFile.add(GROUP_UNIT, "After", "network-online.target remote-fs.target time-sync.target");
        serviceFile.add(GROUP_UNIT, "Wants", "network-online.target");
        if (!target.startsWith("\"")) {
            target = "\"" + target + "\"";
        }
        serviceFile.addServiceGroup(target + " start-launchd", useExec);
        serviceFile.add(GROUP_INSTALL, "WantedBy", wantedBy);
        return serviceFile;
    }

    private void addServiceGroup(String commandLine, boolean useExec) {
        this.add(GROUP_SERVICE, "Type", useExec ? "exec" : "simple");
        this.add(GROUP_SERVICE, "ExecStart", commandLine);
        this.add(GROUP_SERVICE, "SuccessExitStatus", "0 143");
        this.add(GROUP_SERVICE, "KillMode", "process");
    }
}

