/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.ejt.internal.util.CommonStringUtil;
import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.alert.Alert;
import com.install4j.runtime.alert.AlertOptionPane;
import com.install4j.runtime.alert.AlertResult;
import com.install4j.runtime.alert.AlertType;
import com.install4j.runtime.beans.LazyColor;
import com.install4j.runtime.beans.LazyUiManagerColor;
import com.install4j.runtime.beans.LightOrDarkColor;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.applications.InstallerApplication;
import com.install4j.runtime.beans.applications.UninstallerApplication;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.LookAndFeelHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import com.install4j.runtime.wizard.WizardDialog;
import com.install4j.runtime.wizard.WizardFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GUIHelper {
    public static final int BASELINE_LEADING = 512;
    public static final Color CONTENT_BACKGROUND_COLOR = new LightOrDarkColor(Color.WHITE, new Color(49, 52, 53));
    private static final LazyColor SEPARATOR_COLOR = new LazyUiManagerColor("Separator.foreground");
    private static String browserExecutable = "";

    public static String getBrowserExecutable() {
        return browserExecutable;
    }

    public static void setBrowserExecutable(String browserExecutable) {
        GUIHelper.browserExecutable = browserExecutable;
    }

    public static void setLanguage(String languageId) {
        HelperCommunication.helperUnsupported();
        if (InstallerUtil.isInProcess()) {
            LookAndFeelHelper.setLookAndFeel();
            return;
        }
        if (languageId != null) {
            String country;
            int index = languageId.indexOf("_");
            if (index > -1) {
                country = languageId.substring(index + 1);
                languageId = languageId.substring(0, index);
            } else {
                country = "";
            }
            try {
                Locale.setDefault(new Locale(languageId, country));
            }
            catch (Exception exception) {}
        } else {
            languageId = Locale.getDefault().getLanguage();
        }
        LookAndFeelHelper.setLookAndFeel();
        if (Objects.equals(languageId, "ja") || Objects.equals(languageId, "ko") || languageId.startsWith("zh")) {
            Font font = UIManager.getFont("Label.font");
            UIManager.put("OptionPane.font", font);
            UIManager.put("OptionPane.messageFont", font);
            UIManager.put("OptionPane.buttonFont", font);
        }
        String fontOffset = System.getProperty("install4j.font.offset");
        String javaVersion = System.getProperty("java.version");
        if (fontOffset != null) {
            GUIHelper.adjustFontSize(Integer.parseInt(fontOffset));
        } else if (Objects.equals(languageId, "zh_TW") && javaVersion.startsWith("1.4")) {
            GUIHelper.adjustFontSize(2);
        }
    }

    private static void adjustFontSize(int adjustment) {
        HelperCommunication.helperUnsupported();
        UIDefaults defaults = UIManager.getDefaults();
        LinkedList<Object> newDefaults = new LinkedList<Object>();
        HashMap<Font, Font> newFonts = new HashMap<Font, Font>();
        for (Object key : defaults.keySet()) {
            Object value = defaults.get(key);
            if (!(value instanceof Font)) continue;
            Font oldFont = (Font)value;
            Font newFont = newFonts.computeIfAbsent(oldFont, f -> new Font(f.getName(), f.getStyle(), f.getSize() + adjustment));
            newDefaults.add(key);
            newDefaults.add(newFont);
        }
        defaults.putDefaults(newDefaults.toArray());
    }

    public static int showOptionDialog(Component parent, String mainMessage, String contentMessage, String[] options, int messageType) throws UserCanceledException {
        String[] keys = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            int index = option.indexOf(38);
            if (index > -1 && index < option.length() - 1) {
                keys[i] = option.substring(index + 1, index + 2).toLowerCase(Locale.ENGLISH);
            } else {
                String key = option.substring(0, 1).toLowerCase(Locale.ENGLISH);
                boolean found = false;
                for (int j = 0; j < i; ++j) {
                    if (!Objects.equals(keys[j], key)) continue;
                    found = true;
                    break;
                }
                keys[i] = !found ? key : String.valueOf(i);
            }
            options[i] = option.replaceAll("&", "");
        }
        if (InstallerUtil.isUnattendedWithoutAlerts()) {
            return -1;
        }
        if (InstallerUtil.isConsole()) {
            return ConsoleImpl.getInstance().askOption(GUIHelper.toSingleAlertMessage(mainMessage, contentMessage), options, keys, 0);
        }
        LookAndFeelHelper.setLookAndFeel();
        Component nonNullParent = GUIHelper.getNonNullParent(parent);
        try {
            return GUIHelper.invokeOnEDT(() -> GUIHelper.showOptionDialogInternal(nonNullParent, mainMessage, contentMessage, messageType, options));
        }
        catch (Exception e) {
            InstallerUtil.reportException(e);
            return -1;
        }
    }

    private static String toSingleAlertMessage(String mainMessage, String contentMessage) {
        return contentMessage == null ? mainMessage : contentMessage;
    }

    private static int showOptionDialogInternal(Component parent, String mainMessage, String contentMessage, int messageType, String[] options) {
        HelperCommunication.helperUnsupported();
        Alert<String> alert = Alert.create(parent, Messages.getString(".SetupAppTitle"), mainMessage, contentMessage).addButtons(options).defaultButton(options[0]).cancelButton(options[options.length - 1]).alertType(AlertType.fromOptionType(messageType, AlertType.QUESTION));
        AlertResult<String> alertResult = alert.show();
        return alertResult.getSelectedIndex();
    }

    public static Window getParentWindow() {
        if (InstallerUtil.isUnattendedWithoutAlerts() || InstallerUtil.isConsole()) {
            return null;
        }
        HelperCommunication.helperUnsupported();
        Window[] windows = Window.getWindows();
        if (windows != null) {
            Window showingWindow = null;
            Window nonTempFrame = null;
            for (Window window : windows) {
                if (!GUIHelper.isDialogOrFrame(window)) continue;
                if (window.isShowing()) {
                    showingWindow = window;
                    if (window.isActive()) {
                        return window;
                    }
                }
                if (window instanceof AlertOptionPane.TempFrame) continue;
                nonTempFrame = window;
            }
            if (showingWindow != null) {
                return showingWindow;
            }
            if (nonTempFrame != null) {
                return nonTempFrame;
            }
        }
        return null;
    }

    public static Window getCurrentWizardWindow() {
        if (InstallerUtil.isUnattendedWithoutAlerts() || InstallerUtil.isConsole()) {
            return null;
        }
        HelperCommunication.helperUnsupported();
        Window[] windows = Window.getWindows();
        if (windows != null) {
            Window showingWindow = null;
            Window activeWindow = null;
            Window matchingWindow = null;
            for (Window window : windows) {
                if (!(window instanceof WizardDialog) && !(window instanceof WizardFrame)) continue;
                if (window.isShowing()) {
                    showingWindow = window;
                }
                if (window.isActive()) {
                    activeWindow = window;
                }
                matchingWindow = window;
            }
            if (activeWindow != null) {
                return activeWindow;
            }
            if (showingWindow != null) {
                return showingWindow;
            }
            if (matchingWindow != null) {
                return matchingWindow;
            }
        }
        return null;
    }

    private static boolean isDialogOrFrame(Window window) {
        return window instanceof Dialog || window instanceof Frame;
    }

    public static void showMessage(Component parent, String message, int messageType) {
        GUIHelper.showMessage(parent, message, null, messageType);
    }

    public static void showMessage(Component parent, String message, String contentMessage, int messageType) {
        if (InstallerUtil.isUnattendedWithoutAlerts()) {
            Logger.getInstance().log(null, message, messageType != 0);
            ConsoleImpl.getInstance().println(message);
        } else if (InstallerUtil.isConsole()) {
            ConsoleImpl.getInstance().println(message);
        } else {
            LookAndFeelHelper.setLookAndFeel();
            Component nonNullParent = GUIHelper.getNonNullParent(parent);
            try {
                GUIHelper.invokeOnEDT(() -> GUIHelper.showMessageInternal(nonNullParent, message, contentMessage, messageType));
            }
            catch (Exception e) {
                InstallerUtil.reportException(e);
            }
        }
    }

    @NotNull
    private static Component getNonNullParent(@Nullable Component parent) {
        if (parent != null) {
            return parent;
        }
        Window parentWindow = GUIHelper.getParentWindow();
        if (parentWindow != null) {
            return parentWindow;
        }
        return new AlertOptionPane.TempFrame();
    }

    private static void showMessageInternal(Component parent, String mainMessage, String contentMessage, int messageType) {
        HelperCommunication.helperUnsupported();
        Alert alert = Alert.create(parent, Messages.getString(".SetupAppTitle"), mainMessage, contentMessage).alertType(AlertType.fromOptionType(messageType, AlertType.INFORMATION));
        alert.show();
    }

    public static boolean showURL(String urlSpec) {
        if (InstallerUtil.isUnattendedWithoutAlerts() || InstallerUtil.isConsole()) {
            return true;
        }
        Window window = GUIHelper.getParentWindow();
        try {
            if (!GUIHelper.showUrlWithDesktop(urlSpec)) {
                GUIHelper.showBrowserError(window);
                return false;
            }
        }
        catch (IOException e) {
            GUIHelper.showBrowserError(window);
            return false;
        }
        return true;
    }

    private static boolean showUrlWithDesktop(String urlSpec) throws IOException {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(CommonStringUtil.encodeUrlSpaces(urlSpec)));
            return true;
        }
        catch (IOException e) {
            Logger.getInstance().error(null, "The URI " + urlSpec + " cannot be shown.");
            Logger.getInstance().log(e);
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().error(null, "The URI " + urlSpec + " cannot be shown.");
            Logger.getInstance().log(t);
            throw new IOException(t);
        }
    }

    public static Color getSeparatorColor() {
        HelperCommunication.helperUnsupported();
        return SEPARATOR_COLOR;
    }

    public static boolean confirmCancel(Component parent) {
        HelperCommunication.helperUnsupported();
        int result = 0;
        try {
            String message = null;
            Application application = InstallerConfig.getCurrentApplication();
            if (application instanceof InstallerApplication) {
                message = Messages.getString(".ExitSetupMessage");
            } else if (application instanceof UninstallerApplication) {
                message = Messages.getString(".ExitUninstallerMessage");
            } else if (application instanceof CustomApplication) {
                CustomApplication customApplication = (CustomApplication)application;
                if (customApplication.isShowCancelMessage()) {
                    message = customApplication.getCancelMessage();
                }
            } else {
                message = Messages.getString(".ExitApplication");
            }
            if (message != null) {
                result = GUIHelper.showOptionDialog(parent, message, null, new String[]{Messages.getString(".ButtonExit"), Messages.getString(".ButtonContinue")}, 3);
            }
        }
        catch (UserCanceledException userCanceledException) {
            // empty catch block
        }
        return result == 0;
    }

    private static void showBrowserError(Window window) {
        if (!Boolean.getBoolean("install4j.noBrowserError")) {
            GUIHelper.showMessage(window, Messages.getString(".ErrorStartingBrowser"), 0);
        }
    }

    public static void makeTransparent(JComponent component) {
        HelperCommunication.helperUnsupported();
        if (component.getBackground() instanceof UIResource && (component instanceof JPanel || component instanceof JRadioButton || component instanceof JCheckBox || component instanceof JSlider || component instanceof JSplitPane || component instanceof JButton) && !LookAndFeelHelper.getLookAndFeelHandler().isPreventTransparency(component)) {
            component.setOpaque(false);
        }
        int componentCount = component.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = component.getComponent(i);
            if (!(child instanceof JComponent)) continue;
            GUIHelper.makeTransparent((JComponent)child);
        }
    }

    public static void invokeLater(Runnable runnable) {
        HelperCommunication.helperUnsupported();
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    public static void showPath(String path) {
        if (InstallerUtil.isUnattendedWithoutAlerts() || InstallerUtil.isConsole()) {
            return;
        }
        File file = new File(path);
        boolean directory = file.isDirectory();
        if (InstallerUtil.isMacOS()) {
            String[] stringArray;
            LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/usr/bin/open"));
            if (directory) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = file.getAbsolutePath();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "-R";
                stringArray = stringArray3;
                stringArray3[1] = file.getAbsolutePath();
            }
            LaunchHelper.launchApplication(launchDescriptor.arguments(stringArray));
        } else {
            String[] commandArray;
            File workingDirectory = null;
            if (InstallerUtil.isWindows()) {
                if (path.indexOf(32) > -1) {
                    path = FolderInfo.getShortPathName(path);
                }
                commandArray = new String[]{"explorer.exe", (directory ? "" : "/select,") + path};
            } else {
                commandArray = new String[]{"/bin/sh", "-c", "xdg-open .;  if [ $? -ne 0 ]; then xterm; fi"};
                workingDirectory = directory ? file : file.getParentFile();
            }
            try {
                new ProcessBuilder(commandArray).directory(workingDirectory).start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static JSeparator createHorizontalSeparator() {
        JSeparator separator = new JSeparator(0);
        if (Util.isMacOS()) {
            separator.setUI(new BasicSeparatorUI());
        }
        return separator;
    }

    public static void setEmptyBorder(JComponent component, int top, int left, int bottom, int right) {
        component.setBorder(BorderFactory.createEmptyBorder(top, left, bottom, right));
        component.addPropertyChangeListener(event -> {
            if (Objects.equals(event.getPropertyName(), "componentOrientation")) {
                boolean leftToRight = component.getComponentOrientation().isLeftToRight();
                component.setBorder(BorderFactory.createEmptyBorder(top, leftToRight ? left : right, bottom, leftToRight ? right : left));
            }
        });
    }

    public static void applyComponentOrientation(Component c) {
        c.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    public static void invokeOnEDT(Runnable runnable) {
        HelperCommunication.helperUnsupported();
        HelperCommunication.checkEdtWaiting();
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <V> V invokeOnEDT(Callable<V> callable) {
        HelperCommunication.helperUnsupported();
        HelperCommunication.checkEdtWaiting();
        if (EventQueue.isDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        Throwable[] throwable = new Throwable[1];
        Object[] result = new Object[1];
        try {
            EventQueue.invokeAndWait(() -> {
                try {
                    result[0] = callable.call();
                }
                catch (Throwable t) {
                    throwable[0] = t;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (throwable[0] != null) {
            throw new RuntimeException(throwable[0]);
        }
        return (V)result[0];
    }

    public static String getHexValue(Color color) {
        StringBuffer buffer = new StringBuffer();
        GUIHelper.appendComponent(buffer, color.getRed());
        GUIHelper.appendComponent(buffer, color.getGreen());
        GUIHelper.appendComponent(buffer, color.getBlue());
        return buffer.toString();
    }

    private static void appendComponent(StringBuffer buffer, int component) {
        buffer.append(StringUtil.padLeft(Integer.toHexString(component), '0', 2));
    }

    public static <T> T invokeLaterAndWait(Callable<T> callable) {
        if (!EventQueue.isDispatchThread()) {
            return GUIHelper.invokeOnEDT(callable);
        }
        SecondaryLoop loop = Toolkit.getDefaultToolkit().getSystemEventQueue().createSecondaryLoop();
        ArrayList result = new ArrayList();
        ArrayList exception = new ArrayList();
        EventQueue.invokeLater(() -> {
            try {
                result.add(callable.call());
            }
            catch (Throwable t) {
                exception.add(t);
            }
            finally {
                loop.exit();
            }
        });
        loop.enter();
        if (!exception.isEmpty()) {
            throw new RuntimeException((Throwable)exception.get(0));
        }
        return (T)result.get(0);
    }
}

