/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.probe.payload;

import com.jprofiler.agent.probe.d;
import com.jprofiler.agent.probe.l;
import com.jprofiler.api.agent.probe.InterceptorContext;
import com.jprofiler.api.agent.probe.PayloadInfo;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasePayloadInfo
implements PayloadInfo,
Serializable,
Cloneable {
    protected static final int OFFSET_DEFERRED = -10000;
    public static final int EXTERNAL_CALL_TREE_ID = Integer.MAX_VALUE;
    public static final int INVALID_CALL_TREE_ID = 0x7FFFFFFE;
    public static final int DATA_CALL_TREE_ID = 0;
    public static final int DATA_THREAD_ID = 1;
    public static final int DATA_RUNNABLE = 2;
    public static final int DATA_WAITING = 3;
    public static final int DATA_BLOCKED = 4;
    public static final int DATA_NETIO = 5;
    public static final int DATA_TIMESTAMP = 6;
    public static final int DATA_LENGTH = 7;
    protected int callTreeId;
    protected long threadId;
    protected long runnableMicro;
    protected long waitingMicro;
    protected long blockedMicro;
    protected long netioMicro;
    protected long timeStampMicro;
    protected int count = 1;
    protected Object descriptor;

    public BasePayloadInfo() {
    }

    public BasePayloadInfo(Object object) {
        this.descriptor = object;
    }

    public BasePayloadInfo(InterceptorContext interceptorContext, String string) {
        this.setDescription(interceptorContext, string);
    }

    protected BasePayloadInfo(Object object, long l2, int n2, int n3) {
        this(object);
        this.setTime(n2, l2);
        this.count = n3;
    }

    public void setCallTreeId(int n2) {
        this.callTreeId = n2;
    }

    public void setThreadId(long l2) {
        this.threadId = l2;
    }

    public void setRunnableMicro(long l2) {
        this.runnableMicro = l2;
    }

    public void setWaitingMicro(long l2) {
        this.waitingMicro = l2;
    }

    public void setBlockedMicro(long l2) {
        this.blockedMicro = l2;
    }

    public void setNetioMicro(long l2) {
        this.netioMicro = l2;
    }

    public void setTimeStampMicro(long l2) {
        this.timeStampMicro = l2;
    }

    public int getCallTreeId() {
        return this.callTreeId;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getRunnableMicro() {
        return this.runnableMicro;
    }

    public long getWaitingMicro() {
        return this.waitingMicro;
    }

    public long getBlockedMicro() {
        return this.blockedMicro;
    }

    public long getNetioMicro() {
        return this.netioMicro;
    }

    public long getTimeStampMicro() {
        return this.timeStampMicro;
    }

    public final long getTime(int n2) {
        switch (n2) {
            case 1: {
                return this.getRunnableMicro();
            }
            case 2: {
                return this.getWaitingMicro();
            }
            case 3: {
                return this.getBlockedMicro();
            }
            case 5: {
                return this.getNetioMicro();
            }
            case 4: {
                return this.getRunnableMicro() + this.getWaitingMicro() + this.getBlockedMicro() + this.getNetioMicro();
            }
        }
        return 0L;
    }

    private void setTime(int n2, long l2) {
        switch (n2) {
            case 1: {
                this.runnableMicro = l2;
                break;
            }
            case 2: {
                this.waitingMicro = l2;
                break;
            }
            case 3: {
                this.blockedMicro = l2;
                break;
            }
            case 5: {
                this.netioMicro = l2;
                break;
            }
            case 4: {
                this.runnableMicro = l2;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n2));
            }
        }
    }

    public String toString() {
        return "type: " + this.getType() + ", descr: " + this.getDescription() + ", count: " + this.getCount() + ", ct: " + this.getCallTreeId() + ", tm: " + this.getThreadId() + ", r: " + this.getRunnableMicro() + ", w: " + this.getWaitingMicro() + ", b: " + this.getBlockedMicro() + ", n: " + this.getNetioMicro() + ", ts: " + this.getTimeStampMicro();
    }

    public void subtractTime(BasePayloadInfo basePayloadInfo) {
        this.runnableMicro -= basePayloadInfo.runnableMicro;
        this.waitingMicro -= basePayloadInfo.waitingMicro;
        this.blockedMicro -= basePayloadInfo.blockedMicro;
        this.netioMicro -= basePayloadInfo.netioMicro;
    }

    public void addTime(BasePayloadInfo basePayloadInfo, double d2) {
        this.runnableMicro += (long)((double)basePayloadInfo.runnableMicro * d2);
        this.waitingMicro += (long)((double)basePayloadInfo.waitingMicro * d2);
        this.blockedMicro += (long)((double)basePayloadInfo.blockedMicro * d2);
        this.netioMicro += (long)((double)basePayloadInfo.netioMicro * d2);
    }

    public final void initTime(BasePayloadInfo basePayloadInfo) {
        this.runnableMicro = basePayloadInfo.runnableMicro;
        this.waitingMicro = basePayloadInfo.waitingMicro;
        this.blockedMicro = basePayloadInfo.blockedMicro;
        this.netioMicro = basePayloadInfo.netioMicro;
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
    }

    public final void calcDifference(BasePayloadInfo basePayloadInfo, boolean bl) {
        if (basePayloadInfo.getTimeStampMicro() > this.getTimeStampMicro()) {
            this.runnableMicro = basePayloadInfo.runnableMicro - this.runnableMicro;
            this.waitingMicro = basePayloadInfo.waitingMicro - this.waitingMicro;
            this.blockedMicro = basePayloadInfo.blockedMicro - this.blockedMicro;
            this.netioMicro = basePayloadInfo.netioMicro - this.netioMicro;
        } else {
            this.runnableMicro -= basePayloadInfo.runnableMicro;
            this.waitingMicro -= basePayloadInfo.waitingMicro;
            this.blockedMicro -= basePayloadInfo.blockedMicro;
            this.netioMicro -= basePayloadInfo.netioMicro;
        }
        if (bl) {
            this.callTreeId = basePayloadInfo.callTreeId;
            this.threadId = basePayloadInfo.threadId;
        }
    }

    public Collection<? extends BasePayloadInfo> getSecondaryPayloads() {
        return null;
    }

    public int getType() {
        return 0;
    }

    public final int getCount() {
        return this.count;
    }

    public l getJProfilerDescriptor() {
        return this.descriptor instanceof l ? (l)this.descriptor : null;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.getType());
        dataOutput.writeInt(this.descriptor == null ? 0 : this.getJProfilerDescriptor().b());
        dataOutput.writeInt(this.count);
        dataOutput.writeLong(this.callTreeId);
        dataOutput.writeLong(this.threadId);
        dataOutput.writeLong(this.runnableMicro);
        dataOutput.writeLong(this.waitingMicro);
        dataOutput.writeLong(this.blockedMicro);
        dataOutput.writeLong(this.netioMicro);
        dataOutput.writeLong(this.timeStampMicro);
    }

    public void multiplyTime(double d2) {
        this.runnableMicro = (long)((double)this.runnableMicro * d2);
        this.waitingMicro = (long)((double)this.waitingMicro * d2);
        this.blockedMicro = (long)((double)this.blockedMicro * d2);
        this.netioMicro = (long)((double)this.netioMicro * d2);
    }

    public void merge(BasePayloadInfo basePayloadInfo) {
        this.runnableMicro += basePayloadInfo.runnableMicro;
        this.waitingMicro += basePayloadInfo.waitingMicro;
        this.blockedMicro += basePayloadInfo.blockedMicro;
        this.netioMicro += basePayloadInfo.netioMicro;
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
        this.count += basePayloadInfo.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeAsync(BasePayloadInfo basePayloadInfo) {
        BasePayloadInfo basePayloadInfo2 = this;
        synchronized (basePayloadInfo2) {
            this.runnableMicro += basePayloadInfo.runnableMicro;
            this.waitingMicro += basePayloadInfo.waitingMicro;
            this.blockedMicro += basePayloadInfo.blockedMicro;
            this.netioMicro += basePayloadInfo.netioMicro;
            this.timeStampMicro = basePayloadInfo.timeStampMicro;
            this.count += basePayloadInfo.count;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BasePayloadInfo)) {
            return false;
        }
        BasePayloadInfo basePayloadInfo = (BasePayloadInfo)object;
        if (!this.isDescriptionEqual(basePayloadInfo)) {
            return false;
        }
        return this.callTreeId == basePayloadInfo.callTreeId && this.threadId == basePayloadInfo.threadId && this.getType() == basePayloadInfo.getType();
    }

    protected boolean isDescriptionEqual(BasePayloadInfo basePayloadInfo) {
        if (this.descriptor == null) {
            return basePayloadInfo.descriptor == null;
        }
        if (this.descriptor.toString() == null) {
            return basePayloadInfo.descriptor != null && basePayloadInfo.descriptor.toString() == null;
        }
        return basePayloadInfo.descriptor != null && this.descriptor.toString().equals(basePayloadInfo.descriptor.toString());
    }

    public int hashCode() {
        int n2 = this.descriptor != null && this.descriptor.toString() != null ? this.descriptor.toString().hashCode() : 0;
        n2 = 29 * n2 + this.callTreeId;
        n2 = 29 * n2 + (int)(this.threadId ^ this.threadId >>> 32);
        n2 = 29 * n2 + this.getType();
        return n2;
    }

    @Override
    public final String getDescription() {
        return this.descriptor == null ? "" : this.descriptor.toString();
    }

    @Override
    public final void setDescription(InterceptorContext interceptorContext, String string) {
        this.descriptor = ((com.jprofiler.agent.probe.g.d)interceptorContext).e().d(string);
    }

    @Override
    public Object getMemento() {
        return null;
    }

    @Override
    public void setMemento(Object object) {
    }

    @Override
    public PayloadInfo calculateTime(InterceptorContext interceptorContext) {
        ((com.jprofiler.agent.probe.g.d)interceptorContext).e().e(this);
        return this;
    }

    @Override
    public PayloadInfo discardTime() {
        this.runnableMicro = 0L;
        this.waitingMicro = 0L;
        this.blockedMicro = 0L;
        this.netioMicro = 0L;
        return this;
    }

    public Object getDescriptor() {
        return this.descriptor;
    }

    public final void save(DataOutput dataOutput, boolean bl) throws IOException {
        this.write(dataOutput);
        if (bl) {
            Collection<? extends BasePayloadInfo> collection = this.getSecondaryPayloads();
            if (collection != null) {
                for (BasePayloadInfo basePayloadInfo : collection) {
                    dataOutput.writeBoolean(true);
                    basePayloadInfo.write(dataOutput);
                }
            }
            dataOutput.writeBoolean(false);
        }
    }

    public void substractVmStartTime(long l2) {
        this.timeStampMicro -= l2;
        if (this.timeStampMicro < 0L) {
            this.timeStampMicro = 0L;
        }
    }

    public void setDeferred() {
        if (this.getCallTreeId() > 0) {
            this.setCallTreeId(-this.getCallTreeId());
        }
    }

    public void clear() {
        this.discardTime();
        this.count = 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public void setCount(int n2) {
        this.count = n2;
    }

    public void addAllDescriptors(Map<String, l> map) {
        if (this.descriptor instanceof l && this.descriptor.toString() != null) {
            map.put(this.descriptor.toString(), (l)this.descriptor);
        }
    }

    public boolean isInvalid() {
        return this.callTreeId == 0x7FFFFFFE;
    }

    public void copyData(long[] lArray) {
        this.callTreeId = (int)lArray[0];
        this.threadId = lArray[1];
        this.runnableMicro = lArray[2];
        this.waitingMicro = lArray[3];
        this.blockedMicro = lArray[4];
        this.netioMicro = lArray[5];
        this.timeStampMicro = lArray[6];
    }

    public void copyData(d d2) {
        this.callTreeId = d2.a();
        this.threadId = d2.b();
        this.timeStampMicro = d2.c();
    }

    public final void copyData(BasePayloadInfo basePayloadInfo, int n2) {
        this.runnableMicro = basePayloadInfo.runnableMicro / (long)n2;
        this.waitingMicro = basePayloadInfo.waitingMicro / (long)n2;
        this.blockedMicro = basePayloadInfo.blockedMicro / (long)n2;
        this.netioMicro = basePayloadInfo.netioMicro / (long)n2;
        this.callTreeId = basePayloadInfo.callTreeId;
        this.threadId = basePayloadInfo.threadId;
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
    }

    public void initTimestamp(BasePayloadInfo basePayloadInfo) {
        this.timeStampMicro = basePayloadInfo.timeStampMicro;
    }

    public boolean isDeferred() {
        return false;
    }

    public void calcDifference(long[] lArray) {
        if (this.callTreeId == 0) {
            this.callTreeId = (int)lArray[0];
        }
        if (lArray[6] > this.getTimeStampMicro()) {
            this.runnableMicro = lArray[2] - this.runnableMicro;
            this.waitingMicro = lArray[3] - this.waitingMicro;
            this.blockedMicro = lArray[4] - this.blockedMicro;
            this.netioMicro = lArray[5] - this.netioMicro;
        } else {
            this.runnableMicro -= lArray[2];
            this.waitingMicro -= lArray[3];
            this.blockedMicro -= lArray[4];
            this.netioMicro -= lArray[5];
        }
    }
}

