package com.install4j.api.screens;

import com.install4j.api.beans.AbstractBean;
import com.install4j.api.beans.Anchor;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.formcomponents.WidgetStyleHandler;

/**
 * Abstract base class for uninstaller screens.
 * All methods that have a reasonable default answer are overridden in the class.
 * This class saves the uninstaller context that is set by the framework and provides a getter for it.
 *
 * @author ej-technologies GmbH
 */
public abstract class AbstractUninstallerScreen extends AbstractBean implements UninstallerScreen, InstallerEventListener {

    private UninstallerContext context;
    private WidgetStyleHandler widgetStyleHandler;

    @Override
    public void setUninstallerContext(UninstallerContext context) {
        this.context = context;
    }

    @Override
    public void setWidgetStyleHandler(WidgetStyleHandler widgetStyleHandler) {
        this.widgetStyleHandler = widgetStyleHandler;
    }

    @Override
    public boolean isNextVisible() {
        return true;
    }

    @Override
    public boolean isPreviousVisible() {
        return true;
    }

    @Override
    public boolean isCancelVisible() {
        return true;
    }

    @Override
    public boolean isHiddenForNext() {
        return false;
    }

    @Override
    public boolean isHiddenForPrevious() {
        return false;
    }

    @Override
    public void activated() {
    }

    @Override
    public void deactivated() {
    }

    @Override
    public void installerEvent(InstallerEvent event) {
    }

    @Override
    public boolean next() {
        return true;
    }

    @Override
    public boolean previous() {
        return true;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public void willActivate() {

    }

    /**
     * Returns a default value for the anchor of the screen component.
     * @return {@link Anchor#NORTHWEST}
     * @see com.install4j.api.beans.VisualContainerBean#getAnchor()
     */
    @Override
    public Anchor getAnchor() {
        return Anchor.NORTHWEST;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean handleUnattended() {
        return true;
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        console.printHeader(getTitle());
        return true;
    }

    @Override
    public ProgressInterface getProgressInterface(ProgressInterface defaultProgressInterface) {
        return defaultProgressInterface;
    }

    @Override
    public boolean isCreateLazily() {
        return false;
    }

    /**
     * Returns the {@code UninstallerContext} that the framework has associated with
     * this custom screen in {@link #setUninstallerContext(UninstallerContext)}.
     * @return the uninstaller context.
     */
    public UninstallerContext getUninstallerContext() {
        return context;
    }

    /**
     * Returns the {@code WidgetStyleHandler} that the framework has associated with
     * this custom screen in {@link #setWidgetStyleHandler(WidgetStyleHandler)}.
     *
     * @return the widget style handler
     */
    public WidgetStyleHandler getWidgetStyleHandler() {
        return widgetStyleHandler;
    }

}
