/**
 * This package contains classes that allow you to interact with the installer and its environment.
 * <p>
 * See the <a href="../../../../overview-summary.html">API overview</a> for general remarks on
 * how to use the install4j API.
 * </p>
 * <p>
 * The {@link com.install4j.api.context.Context} interface contains all methods that are available in both installer and uninstaller.
 * Concrete interfaces are {@link com.install4j.api.context.InstallerContext} and {@link com.install4j.api.context.UninstallerContext}.
 * </p>
 * <p>
 * Context objects are available as parameters in all script/expression properties in the install4j GUI.
 * </p>
 * <p>
 * Context objects are passed to the {@code install} and {@code uninstall} methods of
 * <a href="../actions/package-summary.html">actions</a>.
 * <a href="../screens/package-summary.html">Screens</a> and
 * <a href="../formcomponents/package-summary.html">form components</a>
 * receive an appropriate context via a setter method after they are constructed.
 * </p>
 */
package com.install4j.api.context;