package com.install4j.api.context;

/**
 * The user notification interface during unattended installations. By default, no
 * progress information is shown during unattended installations. For each installer application, you can set the
 * "Progress interface creation" script property to provide your own means of displaying progress information.
 * For example, you might want to go to full-screen mode during update installers on dedicated special-purpose computers.
 * <p>
 * This class adds a few methods to the default {@link ProgressInterface ProgressInterface} interface that are only
 * relevant in unattended mode.
 *
 * @author ej-technologies GmbH
 * @see ProgressInterface
 * @see Context#getProgressInterface()
 */
public interface UnattendedProgressInterface extends ProgressInterface {
    /**
     * Called when the progress interface is created and destroyed.
     * At startup, this method is called with a parameter of {@code true}, at exit it is called with a
     * parameter of {@code false}. You should use this method for the lif-cycle of a window or similar resources.
     * @param visible {@code true} at startup and {@code false} at exit
     */
    void setVisible(boolean visible);

    /**
     * Called if the cancel button is enabled or disabled.
     * @param enabled {@code true} or {@code false}
     * @see WizardContext#setControlButtonEnabled(ControlButtonType, boolean)
     */
    void setCancelButtonEnabled(boolean enabled);

    /**
     * Called if the cancel button is made visible or invisible.
     * @param visible {@code true} or {@code false}
     * @see WizardContext#setControlButtonVisible(ControlButtonType, boolean)
     */
    void setCancelButtonVisible(boolean visible);

    @Deprecated
    default boolean isAskForProxy() {
        return false;
    }
}
