/**
 * This package contains the interfaces and abstract base classes for actions.
 * <p>
 * See the <a href="../../../../overview-summary.html">API overview</a> for general remarks on
 * how to use the install4j API.
 * </p>
 * <p>
 * The {@link com.install4j.api.actions.Action} interface is a marker interface that indicates that a bean is an action. The concrete interfaces
 * are {@link com.install4j.api.actions.InstallAction} and {@link com.install4j.api.actions.UninstallAction}.
 * {@link com.install4j.api.actions.AutoUninstallAction} is implemented by
 * install actions that wish to automatically be invoked during the uninstallation in order to revert their changes.
 * </p>
 * <p>
 * When you develop your own actions, it is recommended that you extend one of the abstract base classes in this package
 * rather than implement the interfaces themselves.
 * </p>
 * <p>
 * Actions that run the elevated helper process - either because the bean info requires elevation or the user configured
 * it in the IDE - <b>must not declare non-serializable fields</b>. If such fields are required for some purpose at runtime,
 * declare them as {@code transient}, for example
 * </p>
 * <pre>
 * private transient Process process;
 * </pre>
 */
package com.install4j.api.actions;