package com.install4j.api;

import java.io.Serializable;

/**
 * Represents a running process on Windows and macOS.
 * @author ej-technologies GmbH
 */
public abstract class ProcessInfo implements Serializable {

    private int processId;
    private String moduleName;

    /**
     * Called by implementations.
     */
    protected ProcessInfo(int processId, String moduleName) {
        this.processId = processId;
        this.moduleName = moduleName;
    }

    /**
     * Retrieves the full executable path of the process.
     *
     * @return the executable path
     */
    public String getModuleName() {
        return moduleName;
    }

    /**
     * Retrieves the process id.
     *
     * @return the process id
     */
    public int getProcessId() {
        return processId;
    }

    /**
     * Get the title of one of the visible top-level windows of this process.
     * @return the title
     */
    public abstract String getWindowTitle();

    @Override
    public String toString() {
        return
            "processId=" + processId +
            ", moduleName='" + moduleName + '\'' +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ProcessInfo that = (ProcessInfo)o;

        if (processId != that.processId) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return processId;
    }
}
