/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.customizers.installationtype;

import com.ejt.internal.c.b;
import com.ejt.internal.gui.bm;
import com.install4j.api.beaninfo.ProjectReportProperty;
import com.install4j.b.d.b.aa;
import com.install4j.b.d.e.e.t;
import com.install4j.b.j;
import com.install4j.config.c.c;
import com.install4j.config.e;
import com.install4j.runtime.beans.customizers.AbstractCustomizer;
import com.install4j.runtime.beans.customizers.installationtype.InstallationTypeRenderer;
import com.install4j.runtime.beans.customizers.installationtype.InstallationTypeSelector;
import com.install4j.runtime.beans.screens.InstallationTypeScreen;
import com.install4j.runtime.beans.screens.installationtype.ComponentsSelectionType;
import com.install4j.runtime.beans.screens.installationtype.InstallationTypeConfig;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InstallationTypeCustomizer
extends AbstractCustomizer
implements aa.a {
    public static final String TITLE = "Installation types";
    private InstallationTypeSelector selector;
    private InstallationTypeScreen screen;
    private t view;

    public InstallationTypeCustomizer(t t2) {
        this.view = t2;
    }

    public t getView() {
        return this.view;
    }

    @Override
    protected void save() {
        this.screen.setInstallationTypeConfigs(this.selector.getElements());
    }

    @Override
    public void setObject(Object object) {
        this.screen = (InstallationTypeScreen)object;
        this.selector.setElements(this.getInstallationTypeConfigs());
    }

    @Override
    public boolean isIdUnique(String string, Object object) {
        for (InstallationTypeConfig installationTypeConfig : this.selector.getElements()) {
            if (installationTypeConfig == object || !installationTypeConfig.getCustomizedId().equals(string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNameUnique(String string, Object object) {
        for (InstallationTypeConfig installationTypeConfig : this.selector.getElements()) {
            if (installationTypeConfig == object || !installationTypeConfig.getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    public List<InstallationTypeConfig> getInstallationTypeConfigs() {
        if (this.screen == null) {
            return new ArrayList<InstallationTypeConfig>();
        }
        return this.screen.getInstallationTypeConfigs();
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.selector = new InstallationTypeSelector(this);
    }

    @Override
    protected void setupComponent() {
        super.setupComponent();
        this.addTab(TITLE, InstallationTypeRenderer.ICON_DEFAULT.large(), this.createPanel());
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("insets 0, wrap", "[grow]", "[][grow]"));
        jPanel.add((Component)new bm("Installation types are defined by a configurable set of components. The first installation type is selected by default. "), "growx");
        jPanel.add((Component)this.selector, "grow");
        return jPanel;
    }

    public void modified() {
        this.getPropertyChangeSupport().firePropertyChange("installationTypes", null, null);
    }

    public ProjectReportProperty[] getProjectReportProperties() {
        return new ProjectReportProperty[]{new ProjectReportProperty(TITLE, this.getInstallationTypesHTML())};
    }

    private String getInstallationTypesHTML() {
        List<InstallationTypeConfig> list = this.getInstallationTypeConfigs();
        if (list.isEmpty()) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        for (InstallationTypeConfig installationTypeConfig : list) {
            j.b(printWriter, this.getHeaderHTML(installationTypeConfig), InstallationTypeRenderer.getIcon(installationTypeConfig, false));
            this.addSingleConfigHTML(printWriter, installationTypeConfig);
            j.e(printWriter);
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    private String getHeaderHTML(InstallationTypeConfig installationTypeConfig) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<b>");
        stringBuilder.append(b.a(installationTypeConfig.getName()));
        stringBuilder.append("</b>");
        if (this.getExportOptions().a()) {
            stringBuilder.append("<font color=\"#808080\"> [ID ");
            stringBuilder.append(installationTypeConfig.getId());
            stringBuilder.append("]</font>");
        }
        return stringBuilder.toString();
    }

    private void addSingleConfigHTML(PrintWriter printWriter, InstallationTypeConfig installationTypeConfig) {
        j.a(printWriter, new String[][]{{"Description", b.a(installationTypeConfig.getDescription())}, {"Display description", j.a(installationTypeConfig.isDisplayDescription())}, {"User can customize components", j.a(installationTypeConfig.isUserCanCustomize())}, {"Selected components", this.getComponentsHTML(installationTypeConfig)}}, false);
    }

    private String getComponentsHTML(InstallationTypeConfig installationTypeConfig) {
        ComponentsSelectionType componentsSelectionType = installationTypeConfig.getComponentsSelectionType();
        if (componentsSelectionType == ComponentsSelectionType.ALL) {
            return "All components";
        }
        if (componentsSelectionType == ComponentsSelectionType.DEFAULT) {
            return "Default selected components";
        }
        StringBuilder stringBuilder = new StringBuilder();
        e e2 = this.getFrame().u().y();
        List list = installationTypeConfig.getSelectedComponentIds();
        if (list.isEmpty()) {
            stringBuilder.append("(none selected)");
        } else {
            stringBuilder.append("<ul>");
            for (Object e3 : list) {
                c c2 = e2.h((String)e3);
                if (c2 == null) continue;
                stringBuilder.append("<li>");
                stringBuilder.append(b.a(c2.e(false)));
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</ul>");
        }
        return stringBuilder.toString();
    }
}

