/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.applications;

import com.install4j.api.beaninfo.BeanInitializer;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.FilePropertyDescriptor;
import com.install4j.api.beaninfo.FileSelectionMode;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.applications.ApplicationWithPath;
import com.install4j.runtime.beans.applications.ApplicationWithPathBeanInfo;
import com.install4j.runtime.beans.applications.CustomApplication;
import com.install4j.runtime.beans.common.BeanInfoUtil;

@BeanInfo
public class CustomApplicationBeanInfo
extends ApplicationWithPathBeanInfo
implements BeanInitializer {
    private static final String PROPERTY_WINDOW_TITLE = "windowTitle";
    private static final String PROPERTY_CHANGE_WORKING_DIR = "changeWorkingDir";
    private static final String PROPERTY_WORKING_DIR = "workingDir";
    private static final String PROPERTY_VISTA_EXECUTION_LEVEL = "vistaExecutionLevel";
    private static final String PROPERTY_SHOW_CANCEL_MESSAGE = "showCancelMessage";
    private static final String PROPERTY_CANCEL_MESSAGE = "cancelMessage";
    private static final String PROPERTY_SINGLE_INSTANCE = "singleInstance";
    public static final String PROPERTY_CREATE_EXECUTABLE = "createExecutable";

    public CustomApplicationBeanInfo() {
        super("Custom application", "A custom installer application is installed by the installer. Users can start it manually or it can be executed programmatically from your own code via the API.", (Class<? extends ApplicationWithPath>)CustomApplication.class, false);
        this.addPropertyDescriptor(this.categoryExecutable(Install4JPropertyDescriptor.create((String)PROPERTY_CREATE_EXECUTABLE, (Class)this.getBeanClass(), (String)"Create executable", (String)"If selected, an executable for this installer application will be created. If not selected, this application launcher can only be invoked with the <tt>com.install4j.api.launcher.ApplicationLauncher</tt> API or an automatic launcher integration.<p>For macOS single bundles, executables for installer applications are never created.</p>")));
        this.addPropertyDescriptor(this.executableProperty(Install4JPropertyDescriptor.create((String)PROPERTY_SINGLE_INSTANCE, (Class)this.getBeanClass(), (String)"Single instance", (String)"If checked the application will ensure at startup that there is only one instance running per user account.")));
        this.addPropertyDescriptor(this.categoryGuiOptions(Install4JPropertyDescriptor.create((String)PROPERTY_WINDOW_TITLE, (Class)this.getBeanClass(), (String)"Window title", (String)"The title of the application window.")));
        this.addPropertyDescriptor(this.categoryGuiOptions(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_CANCEL_MESSAGE, (Class)this.getBeanClass(), (String)"Show message when user cancels", (String)"If selected, a message will be shown when the user cancels the installer application by clicking on the \"Cancel\" button or closing the application frame.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_SHOW_CANCEL_MESSAGE, Install4JPropertyDescriptor.create((String)PROPERTY_CANCEL_MESSAGE, (Class)this.getBeanClass(), (String)"Cancel message", (String)"The message that is shown if the user cancels the installer application by clicking on the \"Cancel\" button or closing the application frame. The options that are presented to the user are \"Cancel\" or \"Continue\".")));
        this.addPropertyDescriptor(this.categoryExecutionOptions(Install4JPropertyDescriptor.create((String)PROPERTY_CHANGE_WORKING_DIR, (Class)this.getBeanClass(), (String)"Change working directory", (String)"If selected the working directory will be changed to the value in 'Working directory' at startup.")));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_CHANGE_WORKING_DIR, (Install4JPropertyDescriptor)FilePropertyDescriptor.create((String)PROPERTY_WORKING_DIR, (Class)this.getBeanClass(), (String)"Working directory", (String)"The working directory to be used when 'Change working directory' is selected.", (FileSelectionMode)FileSelectionMode.DIRECTORIES_ONLY, (String)"noInstallerVariables")));
        this.addPropertyDescriptor(this.categoryWindows(Install4JPropertyDescriptor.create((String)PROPERTY_VISTA_EXECUTION_LEVEL, (Class)this.getBeanClass(), (String)"Execution level", (String)"The execution level for this application. If you want to modify files in the installation direction, you most likely need administrator rights. This is only relevant for Windows Vista and higher.")));
        this.addDescriptors();
    }

    @Override
    protected Install4JPropertyDescriptor executableProperty(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        return install4JPropertyDescriptor.setParentProperty(PROPERTY_CREATE_EXECUTABLE);
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        if (((Boolean)this.getPropertyValue(PROPERTY_CHANGE_WORKING_DIR, bean)).booleanValue()) {
            this.checkNotEmpty(PROPERTY_WORKING_DIR, bean);
        }
    }

    @Override
    protected void validateExecutableProperties(Bean bean) throws BeanValidationException {
        CustomApplication customApplication = (CustomApplication)bean;
        if (customApplication.isCreateExecutable()) {
            super.validateExecutableProperties(bean);
        }
    }

    public void initializeBean(Bean bean) {
        ((CustomApplication)bean).setWindowTitle("${compiler:sys.fullName}");
    }
}

