/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.beaninfo.ActionElevationType;
import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.net.DownloadAction;
import com.install4j.runtime.beans.actions.net.DownloadActionBeanInfo;
import com.install4j.runtime.beans.actions.net.DownloadFileAction;
import com.install4j.runtime.beans.common.BeanInfoUtil;

@BeanInfo
public class DownloadFileActionBeanInfo
extends DownloadActionBeanInfo {
    private static final String PROPERTY_TARGET_FILE = "targetFile";
    private static final String PROPERTY_RETRY_IF_INTERRUPTED = "retryIfInterrupted";
    private static final String PROPERTY_CHECK_DIGEST = "checkDigest";
    private static final String PROPERTY_DIGEST_URL = "digestUrl";
    private static final String PROPERTY_DONT_ASK_FOR_RETRY = "dontAskForRetry";
    private static final String PROPERTY_SHOW_PROGRESS = "showProgress";
    private static final String PROPERTY_DELETE_ON_EXIT = "deleteOnExit";
    private static final String PROPERTY_SHOW_FILE_NAME = "showFileName";

    public DownloadFileActionBeanInfo() {
        super("Download file", "Download a URL and save it to a file", "HTTP and network", true, false, (Integer)null, (Class<? extends DownloadAction>)DownloadFileAction.class);
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_RETRY_IF_INTERRUPTED, (Class)this.getBeanClass(), (String)"Retry if interrupted", (String)"If selected, ask the user to retry if a successfully started download is interrupted."));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_CHECK_DIGEST, (Class)this.getBeanClass(), (String)"Check digest", (String)"If selected, the action will try to download a file named <tt>sha256sums</tt> or <tt>md5sums</tt> from either the directory of the above URL or from the optional URL given below. If the download is successful and the file contains an entry for the target file name, it will be checked. If the checksums do not match and the \"Silent failure\" option is not selected, a dialog will be shown that offers the possibility to retry the download."));
        this.addPropertyDescriptor(this.reparent(Install4JPropertyDescriptor.create((String)"digestAlgorithm", (Class)this.getBeanClass(), (String)"Digest algorithm", (String)"The digest algorithm to use. This also determines the file name for the digest URL.")));
        this.addPropertyDescriptor(this.reparent(Install4JPropertyDescriptor.create((String)PROPERTY_DIGEST_URL, (Class)this.getBeanClass(), (String)"Optional digest file URL", (String)"An optional URL for the digest file. If specified, only this URL will be used.")));
        this.addPropertyDescriptor(this.reparent(Install4JPropertyDescriptor.create((String)PROPERTY_DONT_ASK_FOR_RETRY, (Class)this.getBeanClass(), (String)"Silent failure", (String)"If selected, the action will fail immediately if a mismatch in the checksums occurs. Otherwise, the user will be presented with a dialog box that explains the failure and offers the possibility to retry the download.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_PROGRESS, (Class)this.getBeanClass(), (String)"Show progress", (String)"If selected, and a progress bar is available on the current screen, the action will show its progress in the progress bar."));
        this.addPropertyDescriptor(BeanInfoUtil.reparent(PROPERTY_SHOW_PROGRESS, Install4JPropertyDescriptor.create((String)PROPERTY_SHOW_FILE_NAME, (Class)this.getBeanClass(), (String)"Show file name", (String)"If selected, the name of the downloaded file and the target directory will be displayed. This setting has no effect if \"Show progress\" is not selected.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_DELETE_ON_EXIT, (Class)this.getBeanClass(), (String)"Delete downloaded file on exit", (String)"If selected, the downloaded file will be deleted when the installer application terminates."));
        this.setDefaultActionElevationType(ActionElevationType.ELEVATE);
    }

    @Override
    protected String getUrlShortDescription() {
        return "The URL from which the file should be downloaded. The URL must start with <tt>http://</tt> or <tt>https://</tt>. If you add a query string, it must already be URL encoded.";
    }

    @Override
    protected void addRequestProperties() {
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)PROPERTY_TARGET_FILE, (Class)this.getBeanClass(), (String)"Target file", (String)"The file to which the downloaded URL will be saved."));
        super.addRequestProperties();
    }

    private Install4JPropertyDescriptor reparent(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_CHECK_DIGEST);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> Boolean.TRUE.equals(object));
        return install4JPropertyDescriptor;
    }

    @Override
    public void validateBean(Bean bean) throws BeanValidationException {
        super.validateBean(bean);
        this.checkNotEmpty(PROPERTY_TARGET_FILE, bean);
    }
}

