/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.firewall;

import com.install4j.api.beaninfo.BeanValidationException;
import com.install4j.api.beaninfo.BeanValidator;
import com.install4j.api.beaninfo.Install4JPropertyDescriptor;
import com.install4j.api.beans.Bean;
import com.install4j.runtime.beans.BeanInfo;
import com.install4j.runtime.beans.actions.SystemActionBeanInfo;
import com.install4j.runtime.beans.actions.firewall.AddWindowsFirewallRuleAction;
import com.install4j.runtime.beans.common.CategoryUtil;
import java.beans.PropertyDescriptor;

@BeanInfo
public class AddWindowsFirewallRuleActionBeanInfo
extends SystemActionBeanInfo
implements BeanValidator {
    private static final String PROPERTY_LAUNCHER_ID = "launcherId";
    private static final String PROPERTY_EXECUTABLE_PATH = "executablePath";
    private static final String PROPERTY_RULE_NAME = "ruleName";
    private static final String PROPERTY_PUBLIC_PROFILE = "publicProfile";
    private static final String CATEGORY_PROFILES = "Profiles";
    private static final String CATEGORY_PORTS_AND_ADDRESSES = "Ports and Addresses";
    public static final String PORT_LIST = "A list of port numbers or port ranges separated by commas.<p>Example: 80, 8080, 5000-5100</p>";

    public AddWindowsFirewallRuleActionBeanInfo() {
        super("Add a Windows firewall rule", "Add a Windows firewall rule. This action will be automatically reverted by the 'Uninstall files' action.", "HTTP and network", true, false, null, AddWindowsFirewallRuleAction.class);
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)"direction", (Class)this.getBeanClass(), (String)"Direction", (String)"If the rule should be created for incoming or outgoing traffic.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_LAUNCHER_ID, (Class)this.getBeanClass(), (String)"Launcher", (String)"The launcher that the rule will be created for.", (String)"launcherOrOther")));
        this.addPropertyDescriptor(this.reparent(Install4JPropertyDescriptor.create((String)PROPERTY_EXECUTABLE_PATH, (Class)this.getBeanClass(), (String)"Executable path", (String)"The executable path.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)PROPERTY_RULE_NAME, (Class)this.getBeanClass(), (String)"Rule name", (String)"The name of the firewall rule. This is displayed in the Windows management console.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)"description", (Class)this.getBeanClass(), (String)"Description", (String)"An optional description of the rule. This is displayed in the Windows management console.")));
        this.addPropertyDescriptor(CategoryUtil.categoryGeneral(Install4JPropertyDescriptor.create((String)"group", (Class)this.getBeanClass(), (String)"Group", (String)"An optional group name of the rule. This is displayed in the Windows management console.")));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryPortsAndAddresses(Install4JPropertyDescriptor.create((String)"protocol", (Class)this.getBeanClass(), (String)"Protocol", (String)"The network protocol for the rule.")));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryPortsAndAddresses(Install4JPropertyDescriptor.create((String)"localPorts", (Class)this.getBeanClass(), (String)"Local Ports", (String)PORT_LIST)));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryPortsAndAddresses(Install4JPropertyDescriptor.create((String)"localAddresses", (Class)this.getBeanClass(), (String)"Local IP Addresses", (String)"One or more comma-delimited tokens specifying the local addresses from which the application can listen for traffic. Valid tokens include:<ul><li>\"*\" indicates any local address. If present, this must be the only token included.</li><li>A valid IPv4 or IPv6 address.</li><li>A subnet can be specified using either the subnet mask or network prefix notation. If neither a subnet mask not a network prefix is specified, the subnet mask defaults to 255.255.255.255.</li><li>An IPv4 or IPv6 address range in the format of \"start address - end address\" with no spaces included.</li></ul>")));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryPortsAndAddresses(Install4JPropertyDescriptor.create((String)"remotePorts", (Class)this.getBeanClass(), (String)"Remote Ports", (String)PORT_LIST)));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryPortsAndAddresses(Install4JPropertyDescriptor.create((String)"remoteAddresses", (Class)this.getBeanClass(), (String)"Remote IP Addresses", (String)"One or more comma-delimited tokens specifying the remote addresses from which the application can listen for traffic. Valid tokens include:<ul><li>\"*\" indicates any remote address. If present, this must be the only token included.</li><li>A valid IPv4 or IPv6 address.</li><li>A subnet can be specified using either the subnet mask or network prefix notation. If neither a subnet mask not a network prefix is specified, the subnet mask defaults to 255.255.255.255.</li><li>An IPv4 or IPv6 address range in the format of \"start address - end address\" with no spaces included.</li><li>\"Defaultgateway\"</li><li>\"DHCP\"</li><li>\"DNS\"</li><li>\"WINS\"</li><li>\"LocalSubnet\" indicates any local address on the local subnet. This token is not case-sensitive.</li></ul>")));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryProfiles(Install4JPropertyDescriptor.create((String)"domainProfile", (Class)this.getBeanClass(), (String)"Domain Profile", (String)"Add rule to the domain profile. The domain profile applies to networks where the host system can authenticate to a domain controller. ")));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryProfiles(Install4JPropertyDescriptor.create((String)"privateProfile", (Class)this.getBeanClass(), (String)"Private Profile", (String)"Add rule to the private profile. The private profile is a user-assigned profile and is used to designate private or home networks. ")));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryProfiles(Install4JPropertyDescriptor.create((String)PROPERTY_PUBLIC_PROFILE, (Class)this.getBeanClass(), (String)"Public Profile", (String)"Add rule to the public profile. The public profile is used to designate public networks such as Wi-Fi hotspots at coffee shops, airports, and other locations. This is the default profile.")));
        this.addPropertyDescriptor(Install4JPropertyDescriptor.create((String)"avoidPublicProfile", (Class)this.getBeanClass(), (String)"Avoid Public Profile", (String)"Only add rule to the public profile if the public profile is the only currently active profile.").setParentProperty(PROPERTY_PUBLIC_PROFILE));
        this.addPropertyDescriptor(AddWindowsFirewallRuleActionBeanInfo.categoryProfiles(Install4JPropertyDescriptor.create((String)"onlyActiveProfiles", (Class)this.getBeanClass(), (String)"Only Currently Active Profiles", (String)"Only add rules to the currently active profiles.")));
        this.setFullPrivilegesRequired(true);
        this.setWindowsOnly(true);
        this.setCategorySortOrder(new String[]{"General", CATEGORY_PORTS_AND_ADDRESSES, CATEGORY_PROFILES});
    }

    private static Install4JPropertyDescriptor categoryProfiles(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory(CATEGORY_PROFILES);
        return install4JPropertyDescriptor;
    }

    private static Install4JPropertyDescriptor categoryPortsAndAddresses(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setPropertyCategory(CATEGORY_PORTS_AND_ADDRESSES);
        return install4JPropertyDescriptor;
    }

    private Install4JPropertyDescriptor reparent(Install4JPropertyDescriptor install4JPropertyDescriptor) {
        install4JPropertyDescriptor.setParentProperty(PROPERTY_LAUNCHER_ID);
        install4JPropertyDescriptor.setVisibilityDiscriminator((bean, object) -> object == null);
        return install4JPropertyDescriptor;
    }

    public void validateBean(Bean bean) throws BeanValidationException {
        PropertyDescriptor propertyDescriptor = this.findPropertyDescriptor(PROPERTY_LAUNCHER_ID);
        String string = (String)this.getPropertyValue(propertyDescriptor, bean);
        if (string == null) {
            this.checkNotEmpty(PROPERTY_EXECUTABLE_PATH, bean);
        } else {
            this.checkNotEmpty(PROPERTY_LAUNCHER_ID, bean);
        }
        this.checkNotEmpty(PROPERTY_RULE_NAME, bean);
    }
}

